/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader.javassist;

import javassist.ClassPool;
import javassist.CtClass;
import org.powermock.core.classloader.ClassMarker;
import org.powermock.core.transformers.ClassWrapper;

class JavaAssistClassMarkerFactory {
    JavaAssistClassMarkerFactory() {
    }

    static ClassMarker createClassMarker(ClassPool classPool) {
        return new InterfaceClassMarker(classPool);
    }

    private static class InterfaceClassMarker
    implements ClassMarker {
        private final ClassPool classPool;

        InterfaceClassMarker(ClassPool classPool) {
            this.classPool = classPool;
        }

        @Override
        public <T> void mark(ClassWrapper<T> type) {
            T unwrapped = type.unwrap();
            if (unwrapped instanceof CtClass) {
                this.mark((CtClass)unwrapped);
            }
        }

        public void mark(CtClass type) {
            CtClass powerMockInterface = this.classPool.makeInterface("org.powermock.core.classloader.PowerMockModified");
            type.addInterface(powerMockInterface);
            powerMockInterface.detach();
        }
    }
}

