/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.ForkedRunner;
import org.openjdk.jmh.runner.link.BinaryLinkClient;
import org.openjdk.jmh.runner.options.Options;

class ForkedMain {
    private static final AtomicBoolean hangupFuse = new AtomicBoolean();
    private static final AtomicReference<BinaryLinkClient> linkRef = new AtomicReference();
    private static volatile boolean gracefullyFinished;
    private static volatile Throwable exception;
    private static volatile PrintStream nakedErr;

    ForkedMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            throw new IllegalArgumentException("Expected two arguments for forked VM");
        }
        Runtime.getRuntime().addShutdownHook(new HangupThread());
        ShutdownTimeoutThread shutdownThread = new ShutdownTimeoutThread();
        try {
            String hostName = argv[0];
            int hostPort = Integer.valueOf(argv[1]);
            BinaryLinkClient link = new BinaryLinkClient(hostName, hostPort);
            linkRef.set(link);
            Options options = link.handshake();
            nakedErr = System.err;
            System.setErr(link.getErrStream());
            System.setOut(link.getOutStream());
            ForkedRunner runner = new ForkedRunner(options, link);
            runner.run();
            gracefullyFinished = true;
        }
        catch (Throwable ex) {
            exception = ex;
            gracefullyFinished = false;
        }
        finally {
            shutdownThread.start();
        }
        if (!gracefullyFinished) {
            System.exit(1);
        }
    }

    static void hangup() {
        BinaryLinkClient link;
        if (!hangupFuse.compareAndSet(false, true)) {
            return;
        }
        if (!gracefullyFinished) {
            Throwable ex = exception;
            if (ex == null) {
                ex = new IllegalStateException("<failure: VM prematurely exited before JMH had finished with it, explicit System.exit was called?>");
            }
            String msg = ex.getMessage();
            BinaryLinkClient link2 = linkRef.get();
            if (link2 != null) {
                try {
                    link2.getOutputFormat().println(msg);
                    link2.pushException(new BenchmarkException(ex));
                }
                catch (Exception e) {
                    ex.printStackTrace(nakedErr);
                }
            } else {
                ex.printStackTrace(nakedErr);
            }
        }
        if ((link = (BinaryLinkClient)linkRef.getAndSet(null)) != null) {
            try {
                link.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ShutdownTimeoutThread
    extends Thread {
        private static final int TIMEOUT = Integer.getInteger("jmh.shutdownTimeout", 30);
        private static final int TIMEOUT_STEP = Integer.getInteger("jmh.shutdownTimeout.step", 5);

        public ShutdownTimeoutThread() {
            this.setName("JMH-Shutdown-Timeout");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            BinaryLinkClient link;
            String msg;
            long waitMore;
            long start = System.nanoTime();
            do {
                try {
                    TimeUnit.SECONDS.sleep(TIMEOUT_STEP);
                }
                catch (InterruptedException e) {
                    return;
                }
                waitMore = TimeUnit.SECONDS.toNanos(TIMEOUT) - (System.nanoTime() - start);
                msg = "<JMH had finished, but forked VM did not exit, are there stray running threads? Waiting " + TimeUnit.NANOSECONDS.toSeconds(waitMore) + " seconds more...>";
                link = (BinaryLinkClient)linkRef.get();
                if (link != null) {
                    link.getOutputFormat().println(msg);
                    continue;
                }
                nakedErr.println(msg);
            } while (waitMore > 0L);
            msg = "<shutdown timeout of " + TIMEOUT + " seconds expired, forcing forked VM to exit>";
            link = (BinaryLinkClient)linkRef.get();
            if (link != null) {
                link.getOutputFormat().println(msg);
            } else {
                nakedErr.println(msg);
            }
            ForkedMain.hangup();
            Runtime.getRuntime().halt(0);
        }
    }

    private static class HangupThread
    extends Thread {
        private HangupThread() {
        }

        @Override
        public void run() {
            ForkedMain.hangup();
        }
    }
}

