/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.Profiler;
import org.openjdk.jmh.profile.ProfilerFactory;
import org.openjdk.jmh.results.BenchmarkTaskResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.IterationResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.Defaults;
import org.openjdk.jmh.runner.InfraControl;
import org.openjdk.jmh.runner.WorkerThreadFactory;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.ClassUtils;
import org.openjdk.jmh.util.Utils;

class BenchmarkHandler {
    private final ExecutorService executor;
    private final ThreadLocal<Object> instances;
    private final OutputFormat out;
    private final List<InternalProfiler> profilers;
    private final List<InternalProfiler> profilersRev;
    private final Method method;
    private static final ExecutorType EXECUTOR_TYPE = Enum.valueOf(ExecutorType.class, System.getProperty("jmh.executor", ExecutorType.FIXED_TPE.name()));

    public BenchmarkHandler(OutputFormat out, Options options, BenchmarkParams executionParams) {
        String target = executionParams.generatedBenchmark();
        int lastDot = target.lastIndexOf(46);
        final Class<?> clazz = ClassUtils.loadClass(target.substring(0, lastDot));
        this.method = BenchmarkHandler.findBenchmarkMethod(clazz, target.substring(lastDot + 1));
        this.profilers = BenchmarkHandler.createProfilers(options);
        this.profilersRev = new ArrayList<InternalProfiler>(this.profilers);
        Collections.reverse(this.profilersRev);
        this.instances = new ThreadLocal<Object>(){

            @Override
            protected Object initialValue() {
                try {
                    return clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Class " + clazz.getName() + " instantiation error ", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Class " + clazz.getName() + " instantiation error ", e);
                }
            }
        };
        this.out = out;
        try {
            this.executor = EXECUTOR_TYPE.createExecutor(executionParams.getThreads(), executionParams.getBenchmark());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static List<InternalProfiler> createProfilers(Options options) {
        ArrayList<InternalProfiler> list = new ArrayList<InternalProfiler>();
        for (Class<? extends Profiler> prof : options.getProfilers()) {
            if (!ProfilerFactory.isInternal(prof)) continue;
            list.add((InternalProfiler)ProfilerFactory.prepareProfiler(prof, options.verbosity().orElse(Defaults.VERBOSITY)));
        }
        return list;
    }

    static ThreadParams[] distributeThreads(int threads, int[] groups) {
        ThreadParams[] result = new ThreadParams[threads];
        int totalGroupThreads = Utils.sum(groups);
        int totalGroups = (int)Math.ceil(1.0 * (double)threads / (double)totalGroupThreads);
        int totalSubgroups = groups.length;
        int currentGroupThread = 0;
        int currentSubgroupThread = 0;
        int currentGroup = 0;
        int currentSubgroup = 0;
        for (int t = 0; t < threads; ++t) {
            while (currentSubgroupThread >= groups[currentSubgroup]) {
                if (++currentSubgroup == groups.length) {
                    ++currentGroup;
                    currentSubgroup = 0;
                    currentGroupThread = 0;
                }
                currentSubgroupThread = 0;
            }
            result[t] = new ThreadParams(t, threads, currentGroup, totalGroups, currentSubgroup, totalSubgroups, currentGroupThread, totalGroupThreads, currentSubgroupThread, groups[currentSubgroup]);
            ++currentGroupThread;
            ++currentSubgroupThread;
        }
        return result;
    }

    public static Method findBenchmarkMethod(Class<?> clazz, String methodName) {
        Method method = null;
        for (Method m : ClassUtils.enumerateMethods(clazz)) {
            if (!m.getName().equals(methodName)) continue;
            if (BenchmarkHandler.isValidBenchmarkSignature(m)) {
                if (method != null) {
                    throw new IllegalArgumentException("Ambiguous methods: \n" + method + "\n and \n" + m + "\n, which one to execute?");
                }
                method = m;
                continue;
            }
            throw new IllegalArgumentException("Benchmark parameters do not match the signature contract.");
        }
        if (method == null) {
            throw new IllegalArgumentException("No matching methods found in benchmark");
        }
        return method;
    }

    private static boolean isValidBenchmarkSignature(Method m) {
        if (m.getReturnType() != BenchmarkTaskResult.class) {
            return false;
        }
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (parameterTypes.length != 2) {
            return false;
        }
        if (parameterTypes[0] != InfraControl.class) {
            return false;
        }
        return parameterTypes[1] == ThreadParams.class;
    }

    protected void startProfilers(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        for (InternalProfiler prof : this.profilers) {
            try {
                prof.beforeIteration(benchmarkParams, iterationParams);
            }
            catch (Throwable ex) {
                throw new BenchmarkException(ex);
            }
        }
    }

    protected void stopProfilers(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iterationResults) {
        for (InternalProfiler prof : this.profilersRev) {
            try {
                iterationResults.addResults(prof.afterIteration(benchmarkParams, iterationParams, iterationResults));
            }
            catch (Throwable ex) {
                throw new BenchmarkException(ex);
            }
        }
    }

    public void shutdown() {
        if (EXECUTOR_TYPE.shutdownForbidden() || this.executor == null) {
            return;
        }
        while (true) {
            this.executor.shutdown();
            try {
                if (this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            this.out.println("Failed to stop executor service " + this.executor + ", trying again; check for the unaccounted running threads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IterationResult runIteration(BenchmarkParams benchmarkParams, IterationParams params, boolean last) {
        IterationResult result;
        int numThreads = benchmarkParams.getThreads();
        TimeValue runtime = params.getTime();
        CountDownLatch preSetupBarrier = new CountDownLatch(numThreads);
        CountDownLatch preTearDownBarrier = new CountDownLatch(numThreads);
        ArrayList<Result> iterationResults = new ArrayList<Result>();
        InfraControl control = new InfraControl(benchmarkParams, params, preSetupBarrier, preTearDownBarrier, last);
        BenchmarkTask[] runners = new BenchmarkTask[numThreads];
        ThreadParams[] threadParamses = BenchmarkHandler.distributeThreads(numThreads, benchmarkParams.getThreadGroups());
        for (int i = 0; i < runners.length; ++i) {
            runners[i] = new BenchmarkTask(control, threadParamses[i]);
        }
        long waitDeadline = System.nanoTime() + benchmarkParams.getTimeout().convertTo(TimeUnit.NANOSECONDS);
        this.startProfilers(benchmarkParams, params);
        HashMap<BenchmarkTask, Future<BenchmarkTaskResult>> results = new HashMap<BenchmarkTask, Future<BenchmarkTaskResult>>();
        for (BenchmarkTask runner : runners) {
            results.put(runner, this.executor.submit(runner));
        }
        control.awaitWarmupReady();
        switch (benchmarkParams.getMode()) {
            case SingleShotTime: {
                break;
            }
            default: {
                try {
                    runtime.sleep();
                    break;
                }
                catch (InterruptedException arr$) {
                    // empty catch block
                }
            }
        }
        control.isDone = true;
        control.awaitWarmdownReady();
        long allOps = 0L;
        long measuredOps = 0L;
        try {
            int expected = numThreads;
            while (expected > 0) {
                for (Map.Entry re : results.entrySet()) {
                    BenchmarkTask task = (BenchmarkTask)re.getKey();
                    Future fr = (Future)re.getValue();
                    try {
                        long waitFor = Math.max(TimeUnit.MILLISECONDS.toNanos(100L), waitDeadline - System.nanoTime());
                        BenchmarkTaskResult btr = (BenchmarkTaskResult)fr.get(waitFor, TimeUnit.NANOSECONDS);
                        iterationResults.addAll(btr.getResults());
                        allOps += btr.getAllOps();
                        measuredOps += btr.getMeasuredOps();
                        --expected;
                    }
                    catch (InterruptedException ex) {
                        throw new BenchmarkException(ex);
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause().getCause().getCause();
                        throw new BenchmarkException(cause);
                    }
                    catch (TimeoutException e) {
                        Thread runner = task.runner;
                        if (runner == null) continue;
                        this.out.print("(*interrupt*) ");
                        runner.interrupt();
                    }
                }
            }
        }
        finally {
            result = new IterationResult(benchmarkParams, params, new IterationResultMetaData(allOps, measuredOps));
            result.addResults(iterationResults);
            this.stopProfilers(benchmarkParams, params, result);
        }
        return result;
    }

    class BenchmarkTask
    implements Callable<BenchmarkTaskResult> {
        private volatile Thread runner;
        private final InfraControl control;
        private final ThreadParams threadParams;

        BenchmarkTask(InfraControl control, ThreadParams threadParams) {
            this.control = control;
            this.threadParams = threadParams;
        }

        @Override
        public BenchmarkTaskResult call() throws Exception {
            try {
                this.runner = Thread.currentThread();
                BenchmarkTaskResult benchmarkTaskResult = (BenchmarkTaskResult)BenchmarkHandler.this.method.invoke(BenchmarkHandler.this.instances.get(), this.control, this.threadParams);
                return benchmarkTaskResult;
            }
            catch (Throwable e) {
                this.control.preSetupForce();
                this.control.preTearDownForce();
                if (this.control.benchmarkParams.shouldSynchIterations()) {
                    try {
                        this.control.announceWarmupReady();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.control.announceWarmdownReady();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new Exception(e);
            }
            finally {
                this.runner = null;
            }
        }
    }

    private static enum ExecutorType {
        CACHED_TPE{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) {
                return Executors.newCachedThreadPool(new WorkerThreadFactory(prefix));
            }
        }
        ,
        FIXED_TPE{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) {
                return Executors.newFixedThreadPool(maxThreads, new WorkerThreadFactory(prefix));
            }
        }
        ,
        FJP{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) throws Exception {
                Constructor<?> c = Class.forName("java.util.concurrent.ForkJoinPool").getConstructor(Integer.TYPE);
                return (ExecutorService)c.newInstance(maxThreads);
            }
        }
        ,
        FJP_COMMON{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) throws Exception {
                Method m = Class.forName("java.util.concurrent.ForkJoinPool").getMethod("commonPool", new Class[0]);
                return (ExecutorService)m.invoke(null, new Object[0]);
            }

            @Override
            boolean shutdownForbidden() {
                return true;
            }
        }
        ,
        CUSTOM{

            @Override
            ExecutorService createExecutor(int maxThreads, String prefix) throws Exception {
                String className = System.getProperty("jmh.executor.class");
                return (ExecutorService)Class.forName(className).getConstructor(Integer.TYPE, String.class).newInstance(maxThreads, prefix);
            }
        };


        abstract ExecutorService createExecutor(int var1, String var2) throws Exception;

        boolean shutdownForbidden() {
            return false;
        }
    }
}

