/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormat;
import org.openjdk.jmh.util.ClassUtils;
import org.openjdk.jmh.util.ScoreFormatter;

class TextResultFormat
implements ResultFormat {
    private final PrintStream out;

    public TextResultFormat(PrintStream out) {
        this.out = out;
    }

    @Override
    public void writeOut(Collection<RunResult> runResults) {
        int COLUMN_PAD = 2;
        ArrayList<String> benchNames = new ArrayList<String>();
        for (RunResult runResult : runResults) {
            benchNames.add(runResult.getParams().getBenchmark());
            for (String label : runResult.getSecondaryResults().keySet()) {
                benchNames.add(runResult.getParams().getBenchmark() + ":" + label);
            }
        }
        Map<String, String> benchPrefixes = ClassUtils.denseClassNames(benchNames);
        int nameLen = "Benchmark".length();
        for (String prefix : benchPrefixes.values()) {
            nameLen = Math.max(nameLen, prefix.length());
        }
        HashMap<String, Integer> paramLengths = new HashMap<String, Integer>();
        TreeSet<String> params = new TreeSet<String>();
        for (RunResult runResult : runResults) {
            BenchmarkParams bp = runResult.getParams();
            for (String k : bp.getParamsKeys()) {
                params.add(k);
                Integer len = (Integer)paramLengths.get(k);
                if (len == null) {
                    len = ("(" + k + ")").length() + 2;
                }
                paramLengths.put(k, Math.max(len, bp.getParam(k).length() + 2));
            }
        }
        int modeLen = "Mode".length();
        int samplesLen = "Cnt".length();
        int scoreLen = "Score".length();
        int scoreErrLen = "Error".length();
        int unitLen = "Units".length();
        for (RunResult res : runResults) {
            Result primRes = res.getPrimaryResult();
            modeLen = Math.max(modeLen, res.getParams().getMode().shortLabel().length());
            samplesLen = Math.max(samplesLen, String.format("%d", primRes.getSampleCount()).length());
            scoreLen = Math.max(scoreLen, ScoreFormatter.format(primRes.getScore()).length());
            scoreErrLen = Math.max(scoreErrLen, ScoreFormatter.format(primRes.getScoreError()).length());
            unitLen = Math.max(unitLen, primRes.getScoreUnit().length());
            for (Result subRes : res.getSecondaryResults().values()) {
                samplesLen = Math.max(samplesLen, String.format("%d", subRes.getSampleCount()).length());
                scoreLen = Math.max(scoreLen, ScoreFormatter.format(subRes.getScore()).length());
                scoreErrLen = Math.max(scoreErrLen, ScoreFormatter.format(subRes.getScoreError()).length());
                unitLen = Math.max(unitLen, subRes.getScoreUnit().length());
            }
        }
        modeLen += 2;
        samplesLen += 2;
        scoreLen += 2;
        ++scoreErrLen;
        unitLen += 2;
        this.out.printf("%-" + nameLen + "s", "Benchmark");
        for (String k : params) {
            this.out.printf("%" + paramLengths.get(k) + "s", "(" + k + ")");
        }
        this.out.printf("%" + modeLen + "s", "Mode");
        this.out.printf("%" + samplesLen + "s", "Cnt");
        this.out.printf("%" + scoreLen + "s", "Score");
        this.out.print("  ");
        this.out.printf("%" + scoreErrLen + "s", "Error");
        this.out.printf("%" + unitLen + "s", "Units");
        this.out.println();
        for (RunResult res : runResults) {
            this.out.printf("%-" + nameLen + "s", benchPrefixes.get(res.getParams().getBenchmark()));
            for (String string : params) {
                String v = res.getParams().getParam(string);
                this.out.printf("%" + paramLengths.get(string) + "s", v == null ? "N/A" : v);
            }
            Result pRes = res.getPrimaryResult();
            this.out.printf("%" + modeLen + "s", res.getParams().getMode().shortLabel());
            if (pRes.getSampleCount() > 1L) {
                this.out.printf("%" + samplesLen + "d", pRes.getSampleCount());
            } else {
                this.out.printf("%" + samplesLen + "s", "");
            }
            this.out.print(ScoreFormatter.format(scoreLen, pRes.getScore()));
            if (!Double.isNaN(pRes.getScoreError()) && !ScoreFormatter.isApproximate(pRes.getScore())) {
                this.out.print(" \u00b1");
                this.out.print(ScoreFormatter.formatError(scoreErrLen, pRes.getScoreError()));
            } else {
                this.out.print("  ");
                this.out.printf("%" + scoreErrLen + "s", "");
            }
            this.out.printf("%" + unitLen + "s", pRes.getScoreUnit());
            this.out.println();
            for (Map.Entry entry : res.getSecondaryResults().entrySet()) {
                String label = (String)entry.getKey();
                Result subRes = (Result)entry.getValue();
                this.out.printf("%-" + nameLen + "s", benchPrefixes.get(res.getParams().getBenchmark() + ":" + label));
                for (String k : params) {
                    String v = res.getParams().getParam(k);
                    this.out.printf("%" + paramLengths.get(k) + "s", v == null ? "N/A" : v);
                }
                this.out.printf("%" + modeLen + "s", res.getParams().getMode().shortLabel());
                if (subRes.getSampleCount() > 1L) {
                    this.out.printf("%" + samplesLen + "d", subRes.getSampleCount());
                } else {
                    this.out.printf("%" + samplesLen + "s", "");
                }
                this.out.print(ScoreFormatter.format(scoreLen, subRes.getScore()));
                if (!Double.isNaN(subRes.getScoreError()) && !ScoreFormatter.isApproximate(subRes.getScore())) {
                    this.out.print(" \u00b1");
                    this.out.print(ScoreFormatter.formatError(scoreErrLen, subRes.getScoreError()));
                } else {
                    this.out.print("  ");
                    this.out.printf("%" + scoreErrLen + "s", "");
                }
                this.out.printf("%" + unitLen + "s", subRes.getScoreUnit());
                this.out.println();
            }
        }
    }
}

