/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.Deduplicator;
import org.openjdk.jmh.util.ScoreFormatter;
import org.openjdk.jmh.util.SingletonStatistics;
import org.openjdk.jmh.util.Statistics;

public abstract class Result<T extends Result<T>>
implements Serializable {
    private static final long serialVersionUID = -7332879501317733312L;
    private static final Deduplicator<String> DEDUP = new Deduplicator();
    protected final ResultRole role;
    protected final String label;
    protected final String unit;
    protected final Statistics statistics;
    protected final AggregationPolicy policy;

    public Result(ResultRole role, String label, Statistics s, String unit, AggregationPolicy policy) {
        this.role = role;
        this.label = DEDUP.dedup(label);
        this.unit = DEDUP.dedup(unit);
        this.statistics = s;
        this.policy = policy;
    }

    protected static Statistics of(double v) {
        return new SingletonStatistics(v);
    }

    public String getLabel() {
        return this.label;
    }

    public ResultRole getRole() {
        return this.role;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public final String getScoreUnit() {
        return this.unit;
    }

    public double getScore() {
        switch (this.policy) {
            case AVG: {
                return this.statistics.getMean();
            }
            case SUM: {
                return this.statistics.getSum();
            }
            case MAX: {
                return this.statistics.getMax();
            }
        }
        throw new IllegalStateException("Unknown aggregation policy: " + (Object)((Object)this.policy));
    }

    public double getScoreError() {
        switch (this.policy) {
            case AVG: {
                return this.statistics.getMeanErrorAt(0.999);
            }
            case SUM: 
            case MAX: {
                return Double.NaN;
            }
        }
        throw new IllegalStateException("Unknown aggregation policy: " + (Object)((Object)this.policy));
    }

    public double[] getScoreConfidence() {
        switch (this.policy) {
            case AVG: {
                return this.statistics.getConfidenceIntervalAt(0.999);
            }
            case SUM: 
            case MAX: {
                double score = this.getScore();
                return new double[]{score, score};
            }
        }
        throw new IllegalStateException("Unknown aggregation policy: " + (Object)((Object)this.policy));
    }

    public long getSampleCount() {
        return this.statistics.getN();
    }

    protected abstract Aggregator<T> getThreadAggregator();

    protected abstract Aggregator<T> getIterationAggregator();

    protected T getZeroResult() {
        return null;
    }

    public String toString() {
        if (!Double.isNaN(this.getScoreError()) && !ScoreFormatter.isApproximate(this.getScore())) {
            return String.format("%s \u00b1(99.9%%) %s %s", ScoreFormatter.format(this.getScore()), ScoreFormatter.formatError(this.getScoreError()), this.getScoreUnit());
        }
        return String.format("%s %s", ScoreFormatter.format(this.getScore()), this.getScoreUnit());
    }

    public String extendedInfo() {
        return this.simpleExtendedInfo();
    }

    protected String simpleExtendedInfo() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Statistics stats = this.getStatistics();
        if (stats.getN() > 2L && !ScoreFormatter.isApproximate(this.getScore())) {
            double[] interval = this.getScoreConfidence();
            pw.println(String.format("  %s \u00b1(99.9%%) %s %s [%s]", new Object[]{ScoreFormatter.format(this.getScore()), ScoreFormatter.formatError((interval[1] - interval[0]) / 2.0), this.getScoreUnit(), this.policy}));
            pw.println(String.format("  (min, avg, max) = (%s, %s, %s), stdev = %s%n  CI (99.9%%): [%s, %s] (assumes normal distribution)", ScoreFormatter.format(stats.getMin()), ScoreFormatter.format(stats.getMean()), ScoreFormatter.format(stats.getMax()), ScoreFormatter.formatError(stats.getStandardDeviation()), ScoreFormatter.format(interval[0]), ScoreFormatter.format(interval[1])));
        } else {
            pw.println(String.format("  %s %s", ScoreFormatter.format(stats.getMean()), this.getScoreUnit()));
        }
        pw.close();
        return sw.toString();
    }

    protected String percentileExtendedInfo() {
        Statistics stats = this.getStatistics();
        StringBuilder sb = new StringBuilder();
        if (stats.getN() > 2L) {
            sb.append("  Samples, N = ").append(stats.getN()).append("\n");
            double[] interval = stats.getConfidenceIntervalAt(0.999);
            sb.append(String.format("        mean = %s \u00b1(99.9%%) %s", ScoreFormatter.format(10, stats.getMean()), ScoreFormatter.formatError((interval[1] - interval[0]) / 2.0)));
            sb.append(" ").append(this.getScoreUnit()).append("\n");
            sb.append(String.format("         min = %s %s\n", ScoreFormatter.format(10, stats.getMin()), this.getScoreUnit()));
            for (double p : new double[]{0.0, 0.5, 0.9, 0.95, 0.99, 0.999, 0.9999, 0.99999, 0.999999}) {
                sb.append(String.format("  %9s = %s %s\n", "p(" + String.format("%7.4f", p * 100.0) + ")", ScoreFormatter.format(10, stats.getPercentile(p * 100.0)), this.getScoreUnit()));
            }
            sb.append(String.format("         max = %s %s\n", ScoreFormatter.format(10, stats.getMax()), this.getScoreUnit()));
        }
        return sb.toString();
    }
}

