/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.AbstractPerfAsmProfiler;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.util.Deduplicator;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.TreeMultiset;
import org.openjdk.jmh.util.Utils;

public class WinPerfAsmProfiler
extends AbstractPerfAsmProfiler {
    private static final String[] EVENTS = new String[]{"SampledProfile"};
    protected static final Collection<String> FAIL_MSGS = new ArrayList<String>();
    private static final String XPERF_DIR = System.getProperty("jmh.perfasm.xperf.dir");
    private static final String XPERF_PROVIDERS = System.getProperty("jmh.perfasm.xperf.providers", "loader+proc_thread+profile");
    private static final String SYMBOL_DIR = System.getProperty("jmh.perfasm.symbol.dir");
    private static final String PATH = XPERF_DIR != null && !XPERF_DIR.isEmpty() ? XPERF_DIR + File.separatorChar + "xperf" : "xperf";
    private volatile String pid;

    public WinPerfAsmProfiler() throws IOException {
        super(EVENTS);
    }

    @Override
    public boolean checkSupport(List<String> msgs) {
        if (FAIL_MSGS.isEmpty()) {
            return true;
        }
        msgs.addAll(FAIL_MSGS);
        return false;
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
        Collection<String> errs = Utils.tryWith(PATH, "-on", XPERF_PROVIDERS);
        if (!errs.isEmpty()) {
            throw new IllegalStateException("Failed to start xperf: " + errs);
        }
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        if (pid == 0L) {
            throw new IllegalStateException(this.label() + " needs the forked VM PID, but it is not initialized.");
        }
        this.pid = String.valueOf(pid);
        return super.afterTrial(br, pid, stdOut, stdErr);
    }

    @Override
    public String label() {
        return "xperfasm";
    }

    @Override
    public String getDescription() {
        return "Windows xperf + PrintAssembly Profiler";
    }

    @Override
    protected void parseEvents() {
        Collection<String> errs = Utils.tryWith(PATH, "-d", this.perfBinData);
        if (!errs.isEmpty()) {
            throw new IllegalStateException("Failed to stop xperf: " + errs);
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{PATH, "-i", this.perfBinData, "-symbols", "-a", "dumper"}, new String[]{"_NT_SYMBOL_PATH=" + SYMBOL_DIR});
            FileOutputStream fos = new FileOutputStream(this.perfParsedData);
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), fos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), fos);
            errDrainer.start();
            outDrainer.start();
            p.waitFor();
            errDrainer.join();
            outDrainer.join();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractPerfAsmProfiler.PerfEvents readEvents(double skipSec) {
        AbstractPerfAsmProfiler.PerfEvents perfEvents;
        FileReader fr = null;
        try {
            String line;
            Deduplicator<String> dedup = new Deduplicator<String>();
            fr = new FileReader(this.perfParsedData);
            BufferedReader reader = new BufferedReader(fr);
            HashMap<Long, String> methods = new HashMap<Long, String>();
            HashMap<Long, String> libs = new HashMap<Long, String>();
            LinkedHashMap<String, Multiset<Long>> events = new LinkedHashMap<String, Multiset<Long>>();
            for (String evName : EVENTS) {
                events.put(evName, new TreeMultiset());
            }
            while ((line = reader.readLine()) != null) {
                String timeStr;
                double time;
                String[] elems = (line = line.trim()).split(",");
                String evName = elems[0].trim();
                if (!EVENTS[0].equals(evName)) continue;
                String pidStr = elems[2].trim();
                int pidOpenIdx = pidStr.indexOf("(");
                int pidCloseIdx = pidStr.indexOf(")");
                if (pidOpenIdx == -1 || pidCloseIdx == -1 || pidCloseIdx < pidOpenIdx || !this.pid.equals(pidStr = pidStr.substring(pidOpenIdx + 1, pidCloseIdx).trim()) || (time = Double.valueOf(timeStr = elems[1].trim()) / 1000000.0) < skipSec) continue;
                String addrStr = elems[4].trim().replace("0x", "");
                String libSymStr = elems[7].trim();
                String lib = libSymStr.substring(0, libSymStr.indexOf(33));
                String symbol = libSymStr.substring(libSymStr.indexOf(33) + 1);
                Multiset evs = (Multiset)events.get(evName);
                assert (evs != null);
                try {
                    Long addr = Long.valueOf(addrStr, 16);
                    evs.add(addr);
                    methods.put(addr, dedup.dedup(symbol));
                    libs.put(addr, dedup.dedup(lib));
                }
                catch (NumberFormatException e) {
                    evs.add(0L);
                }
            }
            methods.put(0L, "<kernel>");
            perfEvents = new AbstractPerfAsmProfiler.PerfEvents(this.tracedEvents, events, methods, libs);
        }
        catch (IOException e) {
            AbstractPerfAsmProfiler.PerfEvents perfEvents2;
            try {
                perfEvents2 = new AbstractPerfAsmProfiler.PerfEvents(this.tracedEvents);
            }
            catch (Throwable throwable) {
                FileUtils.safelyClose(fr);
                throw throwable;
            }
            FileUtils.safelyClose(fr);
            return perfEvents2;
        }
        FileUtils.safelyClose(fr);
        return perfEvents;
    }

    @Override
    protected String perfBinaryExtension() {
        return ".etl";
    }

    static {
        Collection<String> errs = Utils.tryWith(PATH);
        if (errs != null && !errs.isEmpty()) {
            FAIL_MSGS.addAll(errs);
        }
    }
}

