/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.openjdk.jmh.profile.ClassloaderProfiler;
import org.openjdk.jmh.profile.CompilerProfiler;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.profile.HotspotClassloadingProfiler;
import org.openjdk.jmh.profile.HotspotCompilationProfiler;
import org.openjdk.jmh.profile.HotspotMemoryProfiler;
import org.openjdk.jmh.profile.HotspotRuntimeProfiler;
import org.openjdk.jmh.profile.HotspotThreadProfiler;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.LinuxPerfAsmProfiler;
import org.openjdk.jmh.profile.LinuxPerfNormProfiler;
import org.openjdk.jmh.profile.LinuxPerfProfiler;
import org.openjdk.jmh.profile.Profiler;
import org.openjdk.jmh.profile.StackProfiler;
import org.openjdk.jmh.profile.WinPerfAsmProfiler;
import org.openjdk.jmh.runner.options.VerboseMode;

public class ProfilerFactory {
    public static List<Class<? extends Profiler>> getAvailableProfilers() {
        ArrayList<Class<? extends Profiler>> profs = new ArrayList<Class<? extends Profiler>>();
        profs.add(ClassloaderProfiler.class);
        profs.add(CompilerProfiler.class);
        profs.add(GCProfiler.class);
        profs.add(HotspotClassloadingProfiler.class);
        profs.add(HotspotCompilationProfiler.class);
        profs.add(HotspotMemoryProfiler.class);
        profs.add(HotspotRuntimeProfiler.class);
        profs.add(HotspotThreadProfiler.class);
        profs.add(StackProfiler.class);
        profs.add(LinuxPerfProfiler.class);
        profs.add(LinuxPerfNormProfiler.class);
        profs.add(LinuxPerfAsmProfiler.class);
        profs.add(WinPerfAsmProfiler.class);
        profs.addAll(ProfilerFactory.getDiscoveredProfilers());
        return profs;
    }

    public static List<Class<? extends Profiler>> getDiscoveredProfilers() {
        ArrayList<Class<? extends Profiler>> profs = new ArrayList<Class<? extends Profiler>>();
        for (Profiler s : ServiceLoader.load(Profiler.class)) {
            profs.add(s.getClass());
        }
        return profs;
    }

    public static boolean checkSupport(Class<? extends Profiler> klass, List<String> msgs) {
        try {
            Profiler prof = klass.newInstance();
            return prof.checkSupport(msgs);
        }
        catch (InstantiationException e) {
            msgs.add("Unable to instantiate " + klass);
            return false;
        }
        catch (IllegalAccessException e) {
            msgs.add("Unable to instantiate " + klass);
            return false;
        }
    }

    public static String getDescription(Class<? extends Profiler> klass) {
        try {
            Profiler prof = klass.newInstance();
            return prof.getDescription();
        }
        catch (InstantiationException e) {
            return "(unable to instantiate the profiler)";
        }
        catch (IllegalAccessException e) {
            return "(unable to instantiate the profiler)";
        }
    }

    public static Class<? extends Profiler> getProfilerByName(String name) {
        try {
            Class<?> klass = Class.forName(name);
            if (Profiler.class.isAssignableFrom(klass)) {
                return klass;
            }
        }
        catch (ClassNotFoundException klass) {
            // empty catch block
        }
        List<Class<? extends Profiler>> profilers = ProfilerFactory.getAvailableProfilers();
        for (Class clazz : profilers) {
            try {
                Profiler prof = (Profiler)clazz.newInstance();
                if (!prof.label().equalsIgnoreCase(name)) continue;
                return clazz;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        return null;
    }

    public static Profiler prepareProfiler(Class<? extends Profiler> klass, VerboseMode verboseMode) {
        try {
            return klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getLabel(Class<? extends Profiler> klass) {
        try {
            Profiler prof = klass.newInstance();
            return prof.label();
        }
        catch (InstantiationException e) {
            return "(unable to instantiate the profiler)";
        }
        catch (IllegalAccessException e) {
            return "(unable to instantiate the profiler)";
        }
    }

    public static boolean isInternal(Class<? extends Profiler> klass) {
        return InternalProfiler.class.isAssignableFrom(klass);
    }

    public static boolean isExternal(Class<? extends Profiler> klass) {
        return ExternalProfiler.class.isAssignableFrom(klass);
    }
}

