/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.ListStatistics;
import org.openjdk.jmh.util.ScoreFormatter;
import org.openjdk.jmh.util.Statistics;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfNormProfiler
implements ExternalProfiler {
    private static final int DELAY_MSEC = Integer.getInteger("jmh.perfnorm.delayMs", -1);
    private static final String[] USER_EVENTS = System.getProperty("jmh.perfnorm.events", "").split(",");
    private static final Boolean USE_DEFAULT_STAT = Boolean.getBoolean("jmh.perfnorm.useDefaultStat");
    private static final long HIGH_PASS_FILTER = Long.getLong("jmh.perfnorm.filterHigh", 100000000000L);
    private static final int INCREMENT_INTERVAL = Integer.getInteger("jmh.perfnorm.intervalMs", 100);
    private static final boolean IS_SUPPORTED;
    private static final boolean IS_INCREMENTABLE;
    private static final Collection<String> FAIL_MSGS;
    private static final String[] INTERESTING_EVENTS;
    private static final Collection<String> SUPPORTED_EVENTS;

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (USE_DEFAULT_STAT.booleanValue()) {
            cmd.addAll(Arrays.asList("perf", "stat", "--log-fd", "2", "-x,", "-d", "-d", "-d"));
        } else {
            cmd.addAll(Arrays.asList("perf", "stat", "--log-fd", "2", "-x,", "-e", Utils.join(SUPPORTED_EVENTS, ",")));
        }
        if (IS_INCREMENTABLE) {
            cmd.addAll(Arrays.asList("-I", String.valueOf(INCREMENT_INTERVAL)));
        }
        return cmd;
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return this.process(br, stdOut, stdErr);
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    @Override
    public boolean checkSupport(List<String> msgs) {
        if (IS_SUPPORTED) {
            return true;
        }
        msgs.addAll(FAIL_MSGS);
        return false;
    }

    @Override
    public String label() {
        return "perfnorm";
    }

    @Override
    public String getDescription() {
        return "Linux perf statistics, normalized by operation count";
    }

    public long getDelay(BenchmarkResult br) {
        if (DELAY_MSEC == -1) {
            BenchmarkResultMetaData md = br.getMetadata();
            if (md != null) {
                return TimeUnit.MILLISECONDS.toNanos(md.getMeasurementTime() - md.getStartTime());
            }
            IterationParams wp = br.getParams().getWarmup();
            return (long)wp.getCount() * wp.getTime().convertTo(TimeUnit.NANOSECONDS) + TimeUnit.SECONDS.toNanos(1L);
        }
        return TimeUnit.MILLISECONDS.toNanos(DELAY_MSEC);
    }

    private Collection<? extends Result> process(BenchmarkResult br, File stdOut, File stdErr) {
        Set<PerfResult> set;
        FileReader fr;
        block18: {
            BenchmarkResultMetaData md;
            String line;
            HashMultiset<String> events = new HashMultiset<String>();
            fr = null;
            fr = new FileReader(stdErr);
            BufferedReader reader = new BufferedReader(fr);
            long delayNs = this.getDelay(br);
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (IS_INCREMENTABLE) {
                    int idx1 = line.indexOf(",");
                    int idx2 = line.lastIndexOf(",");
                    if (idx1 == -1 || idx2 == -1) continue;
                    String time = line.substring(0, idx1).trim();
                    String count = line.substring(idx1, idx2 + 1).trim();
                    String event = line.substring(idx2 + 1).trim();
                    try {
                        double timeSec = NumberFormat.getInstance().parse(time).doubleValue();
                        if (timeSec * (double)TimeUnit.SECONDS.toNanos(1L) < (double)delayNs) {
                        }
                    }
                    catch (ParseException e) {}
                    continue;
                    try {
                        long lValue = NumberFormat.getInstance().parse(count).longValue();
                        if (lValue > HIGH_PASS_FILTER) continue;
                        events.add(event, lValue);
                    }
                    catch (ParseException e) {}
                    continue;
                }
                int idx = line.lastIndexOf(",");
                if (idx == -1) continue;
                String count = line.substring(0, idx).trim();
                String event = line.substring(idx + 1).trim();
                try {
                    long lValue = NumberFormat.getInstance().parse(count).longValue();
                    events.add(event, lValue);
                }
                catch (ParseException e) {}
            }
            if (!IS_INCREMENTABLE) {
                System.out.println();
                System.out.println();
                System.out.println("WARNING: Your system uses old \"perf\", which cannot print data incrementally (-I).\nTherefore, perf performance data includes benchmark warmup.");
            }
            if ((md = br.getMetadata()) == null) break block18;
            long totalOpts = IS_INCREMENTABLE ? md.getMeasurementOps() : md.getWarmupOps() + md.getMeasurementOps();
            ArrayList<PerfResult> results = new ArrayList<PerfResult>();
            for (String key : events.keys()) {
                results.add(new PerfResult(key, (double)events.count(key) * 1.0 / (double)totalOpts));
            }
            long cycles = events.count("cycles");
            long instructions = events.count("instructions");
            if (cycles != 0L && instructions != 0L) {
                results.add(new PerfResult("CPI", 1.0 * (double)cycles / (double)instructions));
            } else {
                results.add(new PerfResult("CPI", Double.NaN));
            }
            ArrayList<PerfResult> arrayList = results;
            FileUtils.safelyClose(fr);
            return arrayList;
        }
        try {
            set = Collections.singleton(new PerfResult("N/A", Double.NaN));
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileUtils.safelyClose(fr);
                throw throwable;
            }
        }
        FileUtils.safelyClose(fr);
        return set;
    }

    static {
        INTERESTING_EVENTS = new String[]{"cycles", "instructions", "branches", "branch-misses", "bus-cycles", "ref-cycles", "context-switches", "cpu-migrations", "page-faults", "minor-faults", "major-faults", "alignment-faults", "emulation-faults", "L1-dcache-loads", "L1-dcache-load-misses", "L1-dcache-stores", "L1-dcache-store-misses", "L1-icache-loads", "L1-icache-load-misses", "LLC-loads", "LLC-stores", "dTLB-loads", "dTLB-load-misses", "dTLB-stores", "dTLB-store-misses", "iTLB-loads", "iTLB-load-misses", "stalled-cycles-frontend", "stalled-cycles-backend"};
        SUPPORTED_EVENTS = new ArrayList<String>();
        FAIL_MSGS = Utils.tryWith("perf", "stat", "--log-fd", "2", "-x,", "echo", "1");
        IS_SUPPORTED = FAIL_MSGS.isEmpty();
        Collection<String> incremental = Utils.tryWith("perf", "stat", "--log-fd", "2", "-x,", "-I", String.valueOf(INCREMENT_INTERVAL), "echo", "1");
        IS_INCREMENTABLE = incremental.isEmpty();
        for (String ev : USER_EVENTS) {
            if (ev.trim().isEmpty()) continue;
            SUPPORTED_EVENTS.add(ev);
        }
        if (SUPPORTED_EVENTS.isEmpty()) {
            for (String ev : INTERESTING_EVENTS) {
                Collection<String> res = Utils.tryWith("perf", "stat", "--log-fd", "2", "-x,", "-e", "cycles,instructions," + ev, "echo", "1");
                if (!res.isEmpty()) continue;
                SUPPORTED_EVENTS.add(ev);
            }
        }
    }

    static class PerfResultAggregator
    implements Aggregator<PerfResult> {
        PerfResultAggregator() {
        }

        @Override
        public PerfResult aggregate(Collection<PerfResult> results) {
            String key = "";
            ListStatistics stat = new ListStatistics();
            for (PerfResult r : results) {
                key = r.key;
                stat.addValue(r.getScore());
            }
            return new PerfResult(key, stat);
        }
    }

    static class PerfResult
    extends Result<PerfResult> {
        private static final long serialVersionUID = -1262685915873231436L;
        private final String key;

        public PerfResult(String key, double value) {
            this(key, PerfResult.of(value));
        }

        public PerfResult(String key, Statistics stat) {
            super(ResultRole.SECONDARY, "\u00b7" + key, stat, "#/op", AggregationPolicy.AVG);
            this.key = key;
        }

        @Override
        protected Aggregator<PerfResult> getThreadAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Aggregator<PerfResult> getIterationAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        public String toString() {
            return String.format(" %s %s/op", ScoreFormatter.format(this.getScore()), this.key);
        }

        @Override
        public String extendedInfo() {
            return "";
        }
    }
}

