/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.AbstractPerfAsmProfiler;
import org.openjdk.jmh.util.Deduplicator;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.TreeMultiset;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfAsmProfiler
extends AbstractPerfAsmProfiler {
    private static final long SAMPLE_FREQUENCY = Long.getLong("jmh.perfasm.frequency", 1000L);
    private static final String[] EVENTS = System.getProperty("jmh.perfasm.events", "cycles,instructions").split(",");
    private static final boolean IS_SUPPORTED;
    private static final boolean IS_DELAYED;
    private static final Collection<String> FAIL_MSGS;

    @Override
    public boolean checkSupport(List<String> msgs) {
        if (IS_SUPPORTED) {
            return true;
        }
        msgs.addAll(FAIL_MSGS);
        return false;
    }

    public LinuxPerfAsmProfiler() throws IOException {
        super(EVENTS);
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Arrays.asList("perf", "record", "-F" + SAMPLE_FREQUENCY, "-e" + Utils.join(EVENTS, ","), "-o" + this.perfBinData);
    }

    @Override
    public String label() {
        return "perfasm";
    }

    @Override
    public String getDescription() {
        return "Linux perf + PrintAssembly Profiler";
    }

    @Override
    protected void parseEvents() {
        try {
            Process p = Runtime.getRuntime().exec("perf script -f time,event,ip,sym,dso -i " + this.perfBinData);
            FileOutputStream fos = new FileOutputStream(this.perfParsedData);
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), fos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), fos);
            errDrainer.start();
            outDrainer.start();
            p.waitFor();
            errDrainer.join();
            outDrainer.join();
            FileUtils.safelyClose(fos);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractPerfAsmProfiler.PerfEvents readEvents(double skipSec) {
        AbstractPerfAsmProfiler.PerfEvents perfEvents;
        FileReader fr = null;
        try {
            String line;
            Deduplicator<String> dedup = new Deduplicator<String>();
            fr = new FileReader(this.perfParsedData);
            BufferedReader reader = new BufferedReader(fr);
            HashMap<Long, String> methods = new HashMap<Long, String>();
            HashMap<Long, String> libs = new HashMap<Long, String>();
            LinkedHashMap<String, Multiset<Long>> events = new LinkedHashMap<String, Multiset<Long>>();
            for (String evName : EVENTS) {
                events.put(evName, new TreeMultiset());
            }
            Double startTime = null;
            while ((line = reader.readLine()) != null) {
                Long addr;
                Multiset evs;
                String[] elems;
                if (line.startsWith("#") || (elems = line.trim().split("[ ]+")).length < 4) continue;
                String strTime = elems[0].replace(":", "");
                String evName = elems[1].replace(":", "");
                String strAddr = elems[2];
                String symbol = Utils.join(Arrays.copyOfRange(elems, 3, elems.length - 1), " ");
                String lib = elems[elems.length - 1];
                lib = lib.substring(lib.lastIndexOf("/") + 1, lib.length()).replace("(", "").replace(")", "");
                try {
                    Double time = Double.valueOf(strTime);
                    if (startTime == null) {
                        startTime = time;
                    } else if (time - startTime < skipSec) {
                    }
                }
                catch (NumberFormatException e) {}
                continue;
                if ((evs = (Multiset)events.get(evName)) == null) continue;
                try {
                    addr = Long.valueOf(strAddr, 16);
                }
                catch (NumberFormatException e) {
                    try {
                        addr = new BigInteger(strAddr, 16).longValue();
                    }
                    catch (NumberFormatException e1) {
                        addr = 0L;
                    }
                }
                evs.add(addr);
                methods.put(addr, dedup.dedup(symbol));
                libs.put(addr, dedup.dedup(lib));
            }
            methods.put(0L, "<unknown>");
            perfEvents = new AbstractPerfAsmProfiler.PerfEvents(this.tracedEvents, events, methods, libs);
        }
        catch (IOException e) {
            AbstractPerfAsmProfiler.PerfEvents perfEvents2;
            try {
                perfEvents2 = new AbstractPerfAsmProfiler.PerfEvents(this.tracedEvents);
            }
            catch (Throwable throwable) {
                FileUtils.safelyClose(fr);
                throw throwable;
            }
            FileUtils.safelyClose(fr);
            return perfEvents2;
        }
        FileUtils.safelyClose(fr);
        return perfEvents;
    }

    @Override
    protected String perfBinaryExtension() {
        return ".perfbin";
    }

    static {
        FAIL_MSGS = Utils.tryWith("perf", "stat", "--log-fd", "2", "echo", "1");
        IS_SUPPORTED = FAIL_MSGS.isEmpty();
        Collection<String> delay = Utils.tryWith("perf", "stat", "--log-fd", "2", "-D", "1", "echo", "1");
        IS_DELAYED = delay.isEmpty();
    }
}

