/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.AbstractHotspotProfiler;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import sun.management.HotspotThreadMBean;
import sun.management.counter.Counter;

public class HotspotThreadProfiler
extends AbstractHotspotProfiler {
    public List<Counter> getCounters() {
        return ((HotspotThreadMBean)AbstractHotspotProfiler.getInstance("HotspotThreadMBean")).getInternalThreadingCounters();
    }

    @Override
    public String label() {
        return "hs_thr";
    }

    @Override
    public String getDescription() {
        return "HotSpot (tm) threading subsystem via implementation-specific MBeans";
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult result) {
        Map<String, Long> current = this.counters().getCurrent();
        return Arrays.asList(new ProfilerResult("\u00b7threads.alive", current.get("java.threads.live").longValue(), "threads", AggregationPolicy.AVG), new ProfilerResult("\u00b7threads.daemon", current.get("java.threads.daemon").longValue(), "threads", AggregationPolicy.AVG), new ProfilerResult("\u00b7threads.started", current.get("java.threads.started").longValue(), "threads", AggregationPolicy.MAX));
    }
}

