/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.Multisets;
import org.openjdk.jmh.util.Utils;

public abstract class AbstractPerfAsmProfiler
implements ExternalProfiler {
    private static final double THRESHOLD_RATE = Double.valueOf(System.getProperty("jmh.perfasm.hotThreshold", "0.10"));
    private static final int SHOW_TOP = Integer.getInteger("jmh.perfasm.top", 20);
    private static final int THRESHOLD_TOO_BIG = Integer.getInteger("jmh.perfasm.tooBigThreshold", 1000);
    private static final int PRINT_MARGIN = Integer.getInteger("jmh.perfasm.printMargin", 10);
    private static final int MERGE_MARGIN = Integer.getInteger("jmh.perfasm.mergeMargin", 32);
    private static final int DELAY_MSEC = Integer.getInteger("jmh.perfasm.delayMs", -1);
    private static final Boolean SKIP_ASSEMBLY = Boolean.getBoolean("jmh.perfasm.skipAsm");
    private static final Boolean SKIP_INTERPRETER = Boolean.getBoolean("jmh.perfasm.skipInterpreter");
    private static final Boolean SKIP_VM_STUBS = Boolean.getBoolean("jmh.perfasm.skipVMStubs");
    private static final Boolean SAVE_PERF_OUTPUT = Boolean.getBoolean("jmh.perfasm.savePerf");
    private static final String SAVE_PERF_OUTPUT_TO = System.getProperty("jmh.perfasm.savePerfTo", ".");
    private static final String SAVE_PERF_OUTPUT_TO_FILE = System.getProperty("jmh.perfasm.savePerfToFile");
    private static final Boolean SAVE_PERF_BIN_OUTPUT = Boolean.getBoolean("jmh.perfasm.savePerfBin");
    private static final String SAVE_PERF_BIN_OUTPUT_TO = System.getProperty("jmh.perfasm.savePerfBinTo", ".");
    private static final String SAVE_PERF_BIN_OUTPUT_TO_FILE = System.getProperty("jmh.perfasm.savePerfBinToFile");
    private static final Boolean SAVE_LOG_OUTPUT = Boolean.getBoolean("jmh.perfasm.saveLog");
    private static final String SAVE_LOG_OUTPUT_TO = System.getProperty("jmh.perfasm.saveLogTo", ".");
    private static final String SAVE_LOG_OUTPUT_TO_FILE = System.getProperty("jmh.perfasm.saveLogToFile");
    private static final Boolean PRINT_COMPILATION_INFO = Boolean.getBoolean("jmh.perfasm.printCompilationInfo");
    private static final String ASSEMBLY_SYNTAX = System.getProperty("jmh.perfasm.assemblySyntax");
    protected final String[] tracedEvents;
    protected String hsLog;
    protected String perfBinData;
    protected String perfParsedData;

    protected AbstractPerfAsmProfiler(String[] events) throws IOException {
        this.tracedEvents = events;
        this.hsLog = FileUtils.tempFile("hslog").getAbsolutePath();
        this.perfBinData = FileUtils.tempFile("perfbin").getAbsolutePath();
        this.perfParsedData = FileUtils.tempFile("perfparsed").getAbsolutePath();
    }

    @Override
    public abstract boolean checkSupport(List<String> var1);

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        if (!SKIP_ASSEMBLY.booleanValue()) {
            ArrayList<String> opts = new ArrayList<String>();
            opts.addAll(Arrays.asList("-XX:+UnlockDiagnosticVMOptions", "-XX:+LogCompilation", "-XX:LogFile=" + this.hsLog, "-XX:+PrintAssembly"));
            if (!SKIP_INTERPRETER.booleanValue()) {
                opts.add("-XX:+PrintInterpreter");
            }
            if (!SKIP_VM_STUBS.booleanValue()) {
                opts.add("-XX:+PrintNMethods");
                opts.add("-XX:+PrintNativeNMethods");
                opts.add("-XX:+PrintSignatureHandlers");
                opts.add("-XX:+PrintAdapterHandlers");
                opts.add("-XX:+PrintStubCode");
            }
            if (PRINT_COMPILATION_INFO.booleanValue()) {
                opts.add("-XX:+PrintCompilation");
                opts.add("-XX:+PrintInlining");
                opts.add("-XX:+TraceClassLoading");
            }
            if (ASSEMBLY_SYNTAX != null) {
                opts.add("-XX:PrintAssemblyOptions=" + ASSEMBLY_SYNTAX);
            }
            return opts;
        }
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        PerfResult result = this.processAssembly(br, stdOut, stdErr);
        return Collections.singleton(result);
    }

    @Override
    public boolean allowPrintOut() {
        return false;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    protected abstract void parseEvents();

    protected abstract PerfEvents readEvents(double var1);

    protected abstract String perfBinaryExtension();

    private PerfResult processAssembly(BenchmarkResult br, File stdOut, File stdErr) {
        long delayNs;
        this.parseEvents();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Assembly assembly = this.readAssembly(new File(this.hsLog));
        if (assembly.size() > 0) {
            pw.printf("PrintAssembly processed: %d total address lines.%n", assembly.size());
        } else if (SKIP_ASSEMBLY.booleanValue()) {
            pw.println();
            pw.println("PrintAssembly skipped, Java methods are not resolved.");
            pw.println();
        } else {
            pw.println();
            pw.println("ERROR: No address lines detected in assembly capture, make sure your JDK is PrintAssembly-enabled:\n    https://wikis.oracle.com/display/HotSpotInternals/PrintAssembly");
            pw.println();
        }
        if (DELAY_MSEC == -1) {
            BenchmarkResultMetaData md = br.getMetadata();
            if (md != null) {
                delayNs = TimeUnit.MILLISECONDS.toNanos(md.getMeasurementTime() - md.getStartTime());
            } else {
                IterationParams wp = br.getParams().getWarmup();
                delayNs = (long)wp.getCount() * wp.getTime().convertTo(TimeUnit.NANOSECONDS) + TimeUnit.SECONDS.toNanos(1L);
            }
        } else {
            delayNs = TimeUnit.MILLISECONDS.toNanos(DELAY_MSEC);
        }
        double skipSec = 1.0 * (double)delayNs / (double)TimeUnit.SECONDS.toNanos(1L);
        final PerfEvents events = this.readEvents(skipSec);
        if (!events.isEmpty()) {
            pw.printf("Perf output processed (skipped %.3f seconds):%n", skipSec);
            int cnt = 1;
            for (String event : this.tracedEvents) {
                pw.printf(" Column %d: %s (%d events)%n", cnt, event, events.get(event).size());
                ++cnt;
            }
            pw.println();
        } else {
            pw.println();
            pw.println("ERROR: No perf data, make sure \"perf stat echo 1\" is indeed working;\n or the collection delay is not running past the benchmark time.");
            pw.println();
        }
        List<Region> regions = this.makeRegions(assembly, events);
        final String mainEvent = this.tracedEvents[0];
        Collections.sort(regions, new Comparator<Region>(){

            @Override
            public int compare(Region o1, Region o2) {
                return Long.valueOf(o2.getEventCount(events, mainEvent)).compareTo(o1.getEventCount(events, mainEvent));
            }
        });
        long threshold = (long)(THRESHOLD_RATE * (double)events.getTotalEvents(mainEvent).longValue());
        boolean headerPrinted = false;
        int cnt = 1;
        for (Region r : regions) {
            if (r.getEventCount(events, mainEvent) <= threshold) continue;
            if (!headerPrinted) {
                pw.printf("Hottest code regions (>%.2f%% \"%s\" events):%n", THRESHOLD_RATE * 100.0, mainEvent);
                headerPrinted = true;
            }
            this.printDottedLine(pw, "Hottest Region " + cnt);
            pw.printf(" [0x%x:0x%x] in %s%n%n", r.begin, r.end, r.getName());
            r.printCode(pw, events);
            this.printDottedLine(pw);
            for (String event : this.tracedEvents) {
                AbstractPerfAsmProfiler.printLine(pw, events, event, r.getEventCount(events, event));
            }
            pw.println("<total for region " + cnt + ">");
            pw.println();
            ++cnt;
        }
        HashMultiset<String> total = new HashMultiset<String>();
        HashMultiset<String> other = new HashMultiset<String>();
        this.printDottedLine(pw, "Hottest Regions");
        int shown = 0;
        for (Region r : regions) {
            if (shown++ < SHOW_TOP) {
                for (String event : this.tracedEvents) {
                    AbstractPerfAsmProfiler.printLine(pw, events, event, r.getEventCount(events, event));
                }
                pw.printf("[0x%x:0x%x] in %s%n", r.begin, r.end, r.getName());
            } else {
                for (String event : this.tracedEvents) {
                    other.add(event, r.getEventCount(events, event));
                }
            }
            for (String event : this.tracedEvents) {
                total.add(event, r.getEventCount(events, event));
            }
        }
        if (regions.size() - SHOW_TOP > 0) {
            for (String event : this.tracedEvents) {
                AbstractPerfAsmProfiler.printLine(pw, events, event, other.count(event));
            }
            pw.println("<...other " + (regions.size() - SHOW_TOP) + " warm regions...>");
        }
        this.printDottedLine(pw);
        for (String event : this.tracedEvents) {
            AbstractPerfAsmProfiler.printLine(pw, events, event, total.count(event));
        }
        pw.println("<totals>");
        pw.println();
        HashMap methodsByType = new HashMap();
        for (String event : this.tracedEvents) {
            methodsByType.put(event, new HashMultiset());
        }
        this.printDottedLine(pw, "Hottest Methods (after inlining)");
        HashMap methods = new HashMap();
        for (String event : this.tracedEvents) {
            methods.put(event, new HashMultiset());
        }
        for (Region r : regions) {
            for (String event : this.tracedEvents) {
                long count = r.getEventCount(events, event);
                ((Multiset)methods.get(event)).add(r.getName(), count);
                ((Multiset)methodsByType.get(event)).add(r.getType(), count);
            }
        }
        HashMultiset<String> total2 = new HashMultiset<String>();
        HashMultiset<String> other2 = new HashMultiset<String>();
        int shownMethods = 0;
        List<String> top = Multisets.sortedDesc((Multiset)methods.get(mainEvent));
        for (String m : top) {
            if (shownMethods++ < SHOW_TOP) {
                for (String event : this.tracedEvents) {
                    AbstractPerfAsmProfiler.printLine(pw, events, event, ((Multiset)methods.get(event)).count(m));
                }
                pw.printf("%s%n", m);
            } else {
                for (String event : this.tracedEvents) {
                    other2.add(event, ((Multiset)methods.get(event)).count(m));
                }
            }
            for (String event : this.tracedEvents) {
                total2.add(event, ((Multiset)methods.get(event)).count(m));
            }
        }
        if (top.size() - SHOW_TOP > 0) {
            for (String event : this.tracedEvents) {
                AbstractPerfAsmProfiler.printLine(pw, events, event, other2.count(event));
            }
            pw.println("<...other " + (top.size() - SHOW_TOP) + " warm methods...>");
        }
        this.printDottedLine(pw);
        for (String event : this.tracedEvents) {
            AbstractPerfAsmProfiler.printLine(pw, events, event, total2.count(event));
        }
        pw.println("<totals>");
        pw.println();
        this.printDottedLine(pw, "Distribution by Area");
        for (String m : Multisets.sortedDesc((Multiset)methodsByType.get(mainEvent))) {
            for (String event : this.tracedEvents) {
                AbstractPerfAsmProfiler.printLine(pw, events, event, ((Multiset)methodsByType.get(event)).count(m));
            }
            pw.printf("%s%n", m);
        }
        this.printDottedLine(pw);
        for (String event : this.tracedEvents) {
            AbstractPerfAsmProfiler.printLine(pw, events, event, ((Multiset)methodsByType.get(event)).size());
        }
        pw.println("<totals>");
        pw.println();
        HashSet<Long> addrHistory = new HashSet<Long>();
        for (Long addr : assembly.addressMap.keySet()) {
            if (addrHistory.add(addr)) continue;
            pw.println("WARNING: Duplicate instruction addresses detected. This is probably due to compiler reusing\n the code arena for the new generated code. We can not differentiate between methods sharing\nthe same addresses, and therefore the profile might be wrong. Increasing generated code\nstorage might help.");
        }
        int sum = 0;
        for (Long v : events.totalCounts.values()) {
            sum = (int)((long)sum + v);
        }
        if (sum < 1000) {
            pw.println("WARNING: The perf event count is suspiciously low (" + sum + "). The performance data might be\n" + "inaccurate or misleading. Try to do the profiling again, or tune up the sampling frequency.");
        }
        if (SAVE_PERF_OUTPUT.booleanValue()) {
            String target = SAVE_PERF_OUTPUT_TO_FILE == null ? SAVE_PERF_OUTPUT_TO + "/" + br.getParams().id() + ".perf" : SAVE_PERF_OUTPUT_TO_FILE;
            try {
                FileUtils.copy(this.perfParsedData, target);
                pw.println("Perf output saved to " + target);
            }
            catch (IOException e) {
                pw.println("Unable to save perf output to " + target);
            }
        }
        if (SAVE_PERF_BIN_OUTPUT.booleanValue()) {
            String target = SAVE_PERF_BIN_OUTPUT_TO_FILE == null ? SAVE_PERF_BIN_OUTPUT_TO + "/" + br.getParams().id() + this.perfBinaryExtension() : SAVE_PERF_BIN_OUTPUT_TO_FILE;
            try {
                FileUtils.copy(this.perfBinData, target);
                pw.println("Perf binary output saved to " + target);
            }
            catch (IOException e) {
                pw.println("Unable to save perf binary output to " + target);
            }
        }
        if (SAVE_LOG_OUTPUT.booleanValue()) {
            String target = SAVE_LOG_OUTPUT_TO_FILE == null ? SAVE_LOG_OUTPUT_TO + "/" + br.getParams().id() + ".log" : SAVE_LOG_OUTPUT_TO_FILE;
            try {
                FileOutputStream asm = new FileOutputStream(target);
                PrintWriter pwAsm = new PrintWriter(asm);
                for (ASMLine line : assembly.lines) {
                    for (String event : this.tracedEvents) {
                        long count = line.addr != null ? events.get(event).count(line.addr) : 0L;
                        AbstractPerfAsmProfiler.printLine(pwAsm, events, event, count);
                    }
                    pwAsm.println(line.code);
                }
                pwAsm.flush();
                FileUtils.safelyClose(asm);
                pw.println("Perf-annotated Hotspot log is saved to " + target);
            }
            catch (IOException e) {
                pw.println("Unable to save Hotspot log to " + target);
            }
        }
        pw.flush();
        pw.close();
        return new PerfResult(sw.toString());
    }

    private static void printLine(PrintWriter pw, PerfEvents events, String event, long count) {
        if (count > 0L) {
            pw.printf("%6.2f%%  ", 100.0 * (double)count / (double)events.getTotalEvents(event).longValue());
        } else {
            pw.printf("%9s", "");
        }
    }

    void printDottedLine(PrintWriter pw) {
        this.printDottedLine(pw, null);
    }

    void printDottedLine(PrintWriter pw, String header) {
        int HEADER_WIDTH = 100;
        pw.print("....");
        if (header != null) {
            header = "[" + header + "]";
            pw.print(header);
        } else {
            header = "";
        }
        for (int c = 0; c < 96 - header.length(); ++c) {
            pw.print(".");
        }
        pw.println();
    }

    List<Region> makeRegions(Assembly asms, PerfEvents events) {
        ArrayList<Region> regions = new ArrayList<Region>();
        SortedSet<Long> addrs = events.getAllAddresses();
        HashSet<Long> eventfulAddrs = new HashSet<Long>();
        Long lastBegin = null;
        Long lastAddr = null;
        for (Long addr : addrs) {
            if (addr == 0L) {
                regions.add(new UnknownRegion());
                continue;
            }
            if (lastAddr == null) {
                lastAddr = addr;
                lastBegin = addr;
            } else {
                if (addr - lastAddr > (long)MERGE_MARGIN) {
                    List<ASMLine> regionLines = asms.getLines(lastBegin, lastAddr, PRINT_MARGIN);
                    if (!regionLines.isEmpty()) {
                        regions.add(new GeneratedRegion(this.tracedEvents, asms, lastBegin, lastAddr, regionLines, eventfulAddrs));
                    } else {
                        regions.add(new NativeRegion(events, (long)lastBegin, (long)lastAddr, eventfulAddrs));
                    }
                    lastBegin = addr;
                    eventfulAddrs = new HashSet();
                }
                lastAddr = addr;
            }
            eventfulAddrs.add(addr);
        }
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Collection<String>> splitAssembly(File stdOut) {
        FileReader in = null;
        try {
            String line;
            HashMultimap<Long, String> writerToLines = new HashMultimap<Long, String>();
            Long writerId = -1L;
            Pattern pWriterThread = Pattern.compile("(.*)<writer thread='(.*)'>(.*)");
            in = new FileReader(stdOut);
            BufferedReader br = new BufferedReader(in);
            while ((line = br.readLine()) != null) {
                if (line.contains("<writer thread=")) {
                    Matcher m = pWriterThread.matcher(line);
                    if (!m.matches()) continue;
                    try {
                        writerId = Long.valueOf(m.group(2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                writerToLines.put(writerId, line);
            }
            ArrayList<Collection<String>> r = new ArrayList<Collection<String>>();
            Iterator i$ = writerToLines.keys().iterator();
            while (i$.hasNext()) {
                long id = (Long)i$.next();
                r.add(writerToLines.get(id));
            }
            ArrayList<Collection<String>> arrayList = r;
            FileUtils.safelyClose(in);
            return arrayList;
        }
        catch (IOException e) {
            List<Collection<String>> list = Collections.emptyList();
            return list;
        }
        finally {
            FileUtils.safelyClose(in);
        }
    }

    Assembly readAssembly(File stdOut) {
        ArrayList<ASMLine> lines = new ArrayList<ASMLine>();
        TreeMap<Long, Integer> addressMap = new TreeMap<Long, Integer>();
        TreeMap<Long, String> methodMap = new TreeMap<Long, String>();
        for (Collection<String> cs : this.splitAssembly(stdOut)) {
            String method = null;
            String prevLine = "";
            for (String line : cs) {
                String trim = line.trim();
                if (trim.isEmpty()) continue;
                String[] elements = trim.split(" ");
                ASMLine asmLine = new ASMLine(line);
                if (elements.length >= 1 && elements[0].startsWith("0x")) {
                    try {
                        Long addr = Long.valueOf(elements[0].replace("0x", "").replace(":", ""), 16);
                        int idx = lines.size();
                        addressMap.put(addr, idx);
                        if (method != null) {
                            methodMap.put(addr, method);
                            method = null;
                        }
                        asmLine = new ASMLine(addr, line);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (line.contains("# {method}")) {
                    method = elements.length == 6 ? (elements[5].replace("/", ".") + "::" + elements[2]).replace("'", "") : (elements.length == 7 ? (elements[6].replace("/", ".") + "::" + elements[3]).replace("'", "") : "<name unparseable>");
                    method = method.replace("&apos;", "");
                    method = method.replace("&lt;", "<");
                    method = method.replace("&gt;", ">");
                } else if (prevLine.contains("--------")) {
                    if (line.trim().endsWith("bytes")) {
                        method = "<stub: " + line.substring(0, line.indexOf("[")).trim() + ">";
                    }
                } else if (line.contains("StubRoutines::")) {
                    method = elements[0];
                }
                lines.add(asmLine);
                prevLine = line;
            }
        }
        return new Assembly(lines, addressMap, methodMap);
    }

    static class UnknownRegion
    extends Region {
        UnknownRegion() {
            super("<unknown>", 0L, 0L, Collections.singleton(0L));
        }

        @Override
        public void printCode(PrintWriter pw, PerfEvents events) {
            pw.println(" <no assembly is recorded, unknown region>");
        }

        @Override
        public String getType() {
            return "<unknown>";
        }
    }

    static class NativeRegion
    extends Region {
        private final String lib;

        NativeRegion(PerfEvents events, long begin, long end, Set<Long> eventfulAddrs) {
            super(NativeRegion.generateName(events, eventfulAddrs), begin, end, eventfulAddrs);
            this.lib = NativeRegion.resolveLib(events, eventfulAddrs);
        }

        static String generateName(PerfEvents events, Set<Long> eventfulAddrs) {
            HashSet<String> methods = new HashSet<String>();
            for (Long ea : eventfulAddrs) {
                methods.add(events.methods.get(ea));
            }
            return Utils.join(methods, "; ");
        }

        static String resolveLib(PerfEvents events, Set<Long> eventfulAddrs) {
            HashSet<String> libs = new HashSet<String>();
            for (Long ea : eventfulAddrs) {
                libs.add(events.libs.get(ea));
            }
            return Utils.join(libs, "; ");
        }

        @Override
        public void printCode(PrintWriter pw, PerfEvents events) {
            pw.println(" <no assembly is recorded, native region>");
        }

        @Override
        public String getType() {
            return "<native code in (" + this.lib + ")>";
        }

        @Override
        public String getName() {
            return this.method + " (" + this.lib + ")";
        }
    }

    static class GeneratedRegion
    extends Region {
        final String[] tracedEvents;
        final Collection<ASMLine> code;

        GeneratedRegion(String[] tracedEvents, Assembly asms, long begin, long end, Collection<ASMLine> code, Set<Long> eventfulAddrs) {
            super(GeneratedRegion.generateName(asms, eventfulAddrs), begin, end, eventfulAddrs);
            this.tracedEvents = tracedEvents;
            this.code = code;
        }

        static String generateName(Assembly asm, Set<Long> eventfulAddrs) {
            HashSet<String> methods = new HashSet<String>();
            for (Long ea : eventfulAddrs) {
                String m = asm.getMethod(ea);
                if (m == null) continue;
                methods.add(m);
            }
            return Utils.join(methods, "; ");
        }

        @Override
        public void printCode(PrintWriter pw, PerfEvents events) {
            if (this.code.size() > THRESHOLD_TOO_BIG) {
                pw.printf(" <region is too big to display, has %d lines, but threshold is %d>%n", this.code.size(), THRESHOLD_TOO_BIG);
            } else {
                for (ASMLine line : this.code) {
                    for (String event : this.tracedEvents) {
                        long count = line.addr != null ? events.get(event).count(line.addr) : 0L;
                        AbstractPerfAsmProfiler.printLine(pw, events, event, count);
                    }
                    pw.println(line.code);
                }
            }
        }

        @Override
        public String getType() {
            return "<generated code>";
        }
    }

    static class Region {
        final String method;
        final long begin;
        final long end;
        final Set<Long> eventfulAddrs;
        final Map<String, Long> eventCountCache;

        Region(String method, long begin, long end, Set<Long> eventfulAddrs) {
            this.method = method;
            this.begin = begin;
            this.end = end;
            this.eventfulAddrs = eventfulAddrs;
            this.eventCountCache = new HashMap<String, Long>();
        }

        long getEventCount(PerfEvents events, String event) {
            if (!this.eventCountCache.containsKey(event)) {
                Multiset<Long> evs = events.get(event);
                long count = 0L;
                for (Long addr : this.eventfulAddrs) {
                    count += evs.count(addr);
                }
                this.eventCountCache.put(event, count);
            }
            return this.eventCountCache.get(event);
        }

        public void printCode(PrintWriter pw, PerfEvents events) {
            pw.println("<no code>");
        }

        public String getName() {
            return this.method;
        }

        public String getType() {
            return "<unknown>";
        }
    }

    static class ASMLine {
        final Long addr;
        final String code;

        ASMLine(String code) {
            this(null, code);
        }

        ASMLine(Long addr, String code) {
            this.addr = addr;
            this.code = code;
        }
    }

    static class Assembly {
        final List<ASMLine> lines;
        final SortedMap<Long, Integer> addressMap;
        final SortedMap<Long, String> methodMap;

        public Assembly(List<ASMLine> lines, SortedMap<Long, Integer> addressMap, SortedMap<Long, String> methodMap) {
            this.lines = lines;
            this.addressMap = addressMap;
            this.methodMap = methodMap;
        }

        public Assembly() {
            this(new ArrayList<ASMLine>(), new TreeMap<Long, Integer>(), new TreeMap<Long, String>());
        }

        public int size() {
            return this.addressMap.size();
        }

        public List<ASMLine> getLines(long begin, long end, int window) {
            SortedMap<Long, Integer> tailMap = this.addressMap.tailMap(begin);
            if (tailMap.isEmpty()) {
                return Collections.emptyList();
            }
            Long beginAddr = tailMap.firstKey();
            Integer beginIdx = (Integer)this.addressMap.get(beginAddr);
            SortedMap<Long, Integer> headMap = this.addressMap.headMap(end);
            if (headMap.isEmpty()) {
                return Collections.emptyList();
            }
            Long endAddr = headMap.lastKey();
            Integer endIdx = (Integer)this.addressMap.get(endAddr);
            beginIdx = Math.max(0, beginIdx - window);
            endIdx = Math.min(this.lines.size(), endIdx + 2 + window);
            if (beginIdx < endIdx) {
                return this.lines.subList(beginIdx, endIdx);
            }
            return Collections.emptyList();
        }

        public String getMethod(long addr) {
            if (this.methodMap.containsKey(addr)) {
                return (String)this.methodMap.get(addr);
            }
            SortedMap<Long, String> head = this.methodMap.headMap(addr);
            if (head.isEmpty()) {
                return "<unresolved>";
            }
            return (String)this.methodMap.get(head.lastKey());
        }
    }

    protected static class PerfEvents {
        final Map<String, Multiset<Long>> events;
        final Map<Long, String> methods;
        final Map<Long, String> libs;
        final Map<String, Long> totalCounts;

        PerfEvents(String[] tracedEvents, Map<String, Multiset<Long>> events, Map<Long, String> methods, Map<Long, String> libs) {
            this.events = events;
            this.methods = methods;
            this.libs = libs;
            this.totalCounts = new HashMap<String, Long>();
            for (String event : tracedEvents) {
                this.totalCounts.put(event, events.get(event).size());
            }
        }

        public PerfEvents(String[] tracedEvents) {
            this(tracedEvents, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        }

        public boolean isEmpty() {
            return this.events.isEmpty();
        }

        public Multiset<Long> get(String event) {
            return this.events.get(event);
        }

        public SortedSet<Long> getAllAddresses() {
            TreeSet<Long> addrs = new TreeSet<Long>();
            for (Multiset<Long> e : this.events.values()) {
                addrs.addAll(e.keys());
            }
            return addrs;
        }

        public Long getTotalEvents(String event) {
            return this.totalCounts.get(event);
        }
    }

    static class PerfResultAggregator
    implements Aggregator<PerfResult> {
        PerfResultAggregator() {
        }

        @Override
        public PerfResult aggregate(Collection<PerfResult> results) {
            String output = "";
            for (PerfResult r : results) {
                output = output + r.output;
            }
            return new PerfResult(output);
        }
    }

    static class PerfResult
    extends Result<PerfResult> {
        private static final long serialVersionUID = 6871141606856800453L;
        private final String output;

        public PerfResult(String output) {
            super(ResultRole.SECONDARY, "\u00b7asm", PerfResult.of(Double.NaN), "---", AggregationPolicy.AVG);
            this.output = output;
        }

        @Override
        protected Aggregator<PerfResult> getThreadAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Aggregator<PerfResult> getIterationAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        public String toString() {
            return "(text only)";
        }

        @Override
        public String extendedInfo() {
            return this.output;
        }
    }
}

