/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Timeout;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorUtils;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.GenerationException;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.MethodInvocation;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.Optional;

class MethodGroup
implements Comparable<MethodGroup> {
    private final ClassInfo ci;
    private final String name;
    private final Set<MethodInvocation> methods;
    private final EnumSet<Mode> modes;
    private final Map<String, String[]> params;
    private boolean strictFP;

    public MethodGroup(ClassInfo ci, String name) {
        this.ci = ci;
        this.name = name;
        this.methods = new TreeSet<MethodInvocation>();
        this.modes = EnumSet.noneOf(Mode.class);
        this.params = new TreeMap<String, String[]>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodGroup methodGroup = (MethodGroup)o;
        return this.name.equals(methodGroup.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(MethodGroup o) {
        return this.name.compareTo(o.name);
    }

    public void addMethod(MethodInfo method, int threads) {
        if (!this.methods.add(new MethodInvocation(method, threads))) {
            throw new GenerationException("Duplicate @" + Benchmark.class.getSimpleName() + " method. JMH needs an uniquely named method, regardless of the arguments list.", method);
        }
    }

    public Collection<MethodInfo> methods() {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (MethodInvocation m : this.methods) {
            result.add(m.method);
        }
        return result;
    }

    public Optional<Integer> getTotalThreadCount() {
        Iterator<Threads> i$ = this.getAll(Threads.class).iterator();
        if (i$.hasNext()) {
            Threads ann = i$.next();
            return Optional.of(ann.value());
        }
        return Optional.none();
    }

    public String getName() {
        return this.name;
    }

    public void addParamValues(String name, String[] value) {
        this.params.put(name, value);
    }

    public void addStrictFP(boolean sfp) {
        this.strictFP |= sfp;
    }

    public boolean isStrictFP() {
        return this.strictFP;
    }

    public void addModes(Mode eMode) {
        this.modes.add(eMode);
    }

    public void addModes(Mode[] eModes) {
        Collections.addAll(this.modes, eModes);
    }

    public Set<Mode> getModes() {
        return this.modes;
    }

    public int[] getThreads() {
        int[] threads = new int[this.methods.size()];
        int c = 0;
        for (MethodInvocation mi : this.methods) {
            threads[c++] = mi.threads;
        }
        return threads;
    }

    public Optional<Integer> getOperationsPerInvocation() {
        Iterator<OperationsPerInvocation> i$ = this.getAll(OperationsPerInvocation.class).iterator();
        if (i$.hasNext()) {
            OperationsPerInvocation ann = i$.next();
            return Optional.of(ann.value());
        }
        return Optional.none();
    }

    public Optional<TimeUnit> getOutputTimeUnit() {
        Iterator<OutputTimeUnit> i$ = this.getAll(OutputTimeUnit.class).iterator();
        if (i$.hasNext()) {
            OutputTimeUnit ann = i$.next();
            return Optional.of(ann.value());
        }
        return Optional.none();
    }

    public Optional<Integer> getWarmupIterations() {
        for (Warmup ann : this.getAll(Warmup.class)) {
            if (ann.iterations() == -1) continue;
            return Optional.of(ann.iterations());
        }
        return Optional.none();
    }

    public Optional<TimeValue> getWarmupTime() {
        for (Warmup ann : this.getAll(Warmup.class)) {
            if (ann.time() == -1) continue;
            return Optional.of(new TimeValue(ann.time(), ann.timeUnit()));
        }
        return Optional.none();
    }

    public Optional<Integer> getWarmupBatchSize() {
        for (Warmup ann : this.getAll(Warmup.class)) {
            if (ann.batchSize() == -1) continue;
            return Optional.of(ann.batchSize());
        }
        return Optional.none();
    }

    public Optional<Integer> getMeasurementIterations() {
        for (Measurement ann : this.getAll(Measurement.class)) {
            if (ann.iterations() == -1) continue;
            return Optional.of(ann.iterations());
        }
        return Optional.none();
    }

    public Optional<TimeValue> getMeasurementTime() {
        for (Measurement ann : this.getAll(Measurement.class)) {
            if (ann.time() == -1) continue;
            return Optional.of(new TimeValue(ann.time(), ann.timeUnit()));
        }
        return Optional.none();
    }

    public Optional<Integer> getMeasurementBatchSize() {
        for (Measurement ann : this.getAll(Measurement.class)) {
            if (ann.batchSize() == -1) continue;
            return Optional.of(ann.batchSize());
        }
        return Optional.none();
    }

    public Optional<Integer> getForks() {
        for (Fork ann : this.getAll(Fork.class)) {
            if (ann.value() == -1) continue;
            return Optional.of(ann.value());
        }
        return Optional.none();
    }

    public Optional<Integer> getWarmupForks() {
        for (Fork ann : this.getAll(Fork.class)) {
            if (ann.warmups() == -1) continue;
            return Optional.of(ann.warmups());
        }
        return Optional.none();
    }

    public Optional<String> getJvm() {
        for (Fork ann : this.getAll(Fork.class)) {
            if (ann.jvm().equals("blank_blank_blank_2014")) continue;
            return Optional.of(ann.jvm());
        }
        return Optional.none();
    }

    public Optional<Collection<String>> getJvmArgs() {
        for (Fork ann : this.getAll(Fork.class)) {
            String[] args = ann.jvmArgs();
            if (args.length == 1 && args[0].equals("blank_blank_blank_2014")) continue;
            return Optional.of(Arrays.asList(args));
        }
        return Optional.none();
    }

    public Optional<Collection<String>> getJvmArgsAppend() {
        for (Fork ann : this.getAll(Fork.class)) {
            String[] args = ann.jvmArgsAppend();
            if (args.length == 1 && args[0].equals("blank_blank_blank_2014")) continue;
            return Optional.of(Arrays.asList(args));
        }
        return Optional.none();
    }

    public Optional<Collection<String>> getJvmArgsPrepend() {
        for (Fork ann : this.getAll(Fork.class)) {
            String[] args = ann.jvmArgsPrepend();
            if (args.length == 1 && args[0].equals("blank_blank_blank_2014")) continue;
            return Optional.of(Arrays.asList(args));
        }
        return Optional.none();
    }

    public Optional<TimeValue> getTimeout() {
        Iterator<Timeout> i$ = this.getAll(Timeout.class).iterator();
        if (i$.hasNext()) {
            Timeout ann = i$.next();
            return Optional.of(new TimeValue(ann.time(), ann.timeUnit()));
        }
        return Optional.none();
    }

    private <T extends Annotation> Collection<T> getAll(Class<T> annClass) {
        Collection<Object> results = new ArrayList();
        for (MethodInvocation mi : this.methods) {
            Collection<T> anns = BenchmarkGeneratorUtils.getAnnSuperAll(mi.method, this.ci, annClass);
            if (!(results.isEmpty() || anns.isEmpty() || results.equals(anns))) {
                throw new GenerationException("Colliding annotations: " + anns + " vs. " + results, mi.method);
            }
            results = anns;
        }
        return results;
    }

    public Optional<Map<String, String[]>> getParams() {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        for (Map.Entry<String, String[]> e : this.params.entrySet()) {
            String key = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1 && values[0].equalsIgnoreCase("blank_blank_blank_2014")) {
                map.put(key, new String[0]);
                continue;
            }
            map.put(key, values);
        }
        if (this.params.isEmpty()) {
            return Optional.none();
        }
        return Optional.of(map);
    }
}

