/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseRandomOp
extends BaseOp
implements RandomOp {
    protected long[] shape;
    protected DataType dataType = Nd4j.defaultFloatingPointType();

    public BaseRandomOp(SameDiff sameDiff, SDVariable i_v) {
        Preconditions.checkNotNull((Object)i_v, (String)"Input variable can't be null with this constructor");
        this.sameDiff = sameDiff;
        this.xVertexId = i_v.name();
        if (i_v.getShape() != null) {
            this.shape = i_v.getShape();
        } else if (i_v.getArr() != null && i_v.getArr().shape() != null) {
            this.shape = i_v.getArr().shape();
        }
        sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
    }

    public BaseRandomOp(SameDiff sd, long[] shape) {
        super(sd, (Object[])null);
        Preconditions.checkArgument((shape != null && shape.length > 0 ? 1 : 0) != 0, (String)"Shape must be non-null, length > 0. Got: %s", (Object)shape);
        this.sameDiff = sd;
        this.shape = shape;
        this.setInstanceId();
        this.sameDiff.addArgsFor(new String[0], (DifferentialFunction)this);
    }

    public BaseRandomOp(INDArray x, INDArray y, INDArray z) {
        super(x, y, z);
    }

    @Override
    public Op.Type opType() {
        return Op.Type.RANDOM;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        return this.calculateOutputShape(null);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        return Collections.singletonList(DataType.FLOAT);
    }

    @Override
    public boolean isInPlace() {
        return this.x == null || this.x == this.z || this.x.data().pointer().address() == this.z.data().pointer().address();
    }

    public boolean isTripleArgRngOp() {
        return false;
    }

    public BaseRandomOp() {
    }
}

