/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.strict;

import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.EluBp;

public class ELU
extends DynamicCustomOp {
    public static final double DEFAULT_ALPHA = 1.0;
    protected double alpha;

    public ELU(SameDiff sameDiff, SDVariable i_v) {
        super(sameDiff, new SDVariable[]{i_v});
        this.alpha = 1.0;
        this.addTArgument(this.alpha);
    }

    public ELU() {
    }

    public ELU(INDArray x, INDArray z) {
        this(x, z, 1.0);
    }

    public ELU(INDArray x, INDArray z, double alpha) {
        super(null, ELU.wrapOrNull(x), ELU.wrapOrNull(z));
        this.alpha = alpha;
        this.addTArgument(alpha);
    }

    public ELU(INDArray x) {
        this(x, null, 1.0);
    }

    @Override
    public String opName() {
        return "elu";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Elu";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return new EluBp(this.sameDiff, this.arg(), i_v.get(0), this.alpha).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 datatype for ELU, got %s", dataTypes);
        Preconditions.checkState((boolean)dataTypes.get(0).isFPType(), (String)"Expected floating point input type for ELU, got %s", dataTypes);
        return dataTypes;
    }
}

