/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce3;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.util.SameDiffUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.reduce3.BaseReduce3Op;
import org.nd4j.linalg.factory.Nd4j;

public class CosineSimilarity
extends BaseReduce3Op {
    public static final String OP_NAME = "cosinesimilarity";

    public CosineSimilarity(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public CosineSimilarity(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public CosineSimilarity(SameDiff sameDiff, SDVariable i_v, SDVariable dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public CosineSimilarity(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, SDVariable dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public CosineSimilarity() {
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public CosineSimilarity(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        super(x, y, z, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public CosineSimilarity(INDArray x, INDArray y, int ... dimensions) {
        this(x, y, null, dimensions);
    }

    public CosineSimilarity(INDArray x, INDArray y, INDArray z) {
        this(x, y, z, null);
    }

    public CosineSimilarity(INDArray x, INDArray y, INDArray z, boolean allDistances, int ... dimension) {
        this(x, y, z, dimension);
        this.isComplex = allDistances;
    }

    public CosineSimilarity(INDArray x, INDArray y, boolean allDistances, int ... dimension) {
        this(x, y, null, allDistances, dimension);
    }

    public CosineSimilarity(INDArray x, INDArray y, INDArray z, boolean keepDims, boolean allDistances, int ... dimensions) {
        super(x, y, z, keepDims, allDistances, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public CosineSimilarity(SameDiff sd, SDVariable x, SDVariable y, boolean keepDims, boolean isComplex, int[] dimensions) {
        super(sd, x, y, keepDims, isComplex, dimensions);
    }

    public CosineSimilarity(INDArray x, INDArray y, boolean keepDims, boolean isComplex, int[] dimensions) {
        super(x, y, null, keepDims, isComplex, dimensions);
    }

    @Override
    public int opNum() {
        return 2;
    }

    @Override
    public String opName() {
        return OP_NAME;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        return CosineSimilarity.doDiff(this.sameDiff, this.larg(), this.rarg(), i_v1.get(0), this.keepDims, this.dimensions);
    }

    public static List<SDVariable> doDiff(SameDiff sameDiff, SDVariable x, SDVariable y, SDVariable gradOut, boolean keepDims, int ... dimensions) {
        SDVariable a = sameDiff.sum(x.mul(y), true, dimensions);
        SDVariable l2x = sameDiff.norm2(x, true, dimensions);
        SDVariable l2y = sameDiff.norm2(y, true, dimensions);
        SDVariable b = l2x.mul(l2y);
        SDVariable l2xSq = sameDiff.math().square(l2x);
        SDVariable l2ySq = sameDiff.math().square(l2y);
        SDVariable broadcastableGrad = keepDims || dimensions == null || dimensions.length == 0 || dimensions.length == 1 && dimensions[0] == Integer.MAX_VALUE ? gradOut : SameDiffUtils.reductionBroadcastableWithOrigShape(x, sameDiff.constant(Nd4j.createFromArray(dimensions)), gradOut);
        SDVariable dcdx = y.sub(x.mul(a).div(l2xSq)).div(b);
        SDVariable dcdy = x.sub(y.mul(a).div(l2ySq)).div(b);
        return Arrays.asList(dcdx.mul(broadcastableGrad), dcdy.mul(broadcastableGrad));
    }
}

