/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.loss.BaseLoss;
import org.nd4j.linalg.api.ops.impl.loss.bp.SoftmaxCrossEntropyLossBp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class SoftmaxCrossEntropyLoss
extends BaseLoss {
    public static final double DEFAULT_LABEL_SMOOTHING = 0.0;
    private double labelSmoothing = 0.0;

    public SoftmaxCrossEntropyLoss(SameDiff sameDiff, SDVariable labels, SDVariable logits, SDVariable weights, LossReduce lossReduce, double labelSmoothing) {
        this(sameDiff, lossReduce, logits, weights, labels, labelSmoothing);
    }

    public SoftmaxCrossEntropyLoss(SameDiff sameDiff, LossReduce lossReduce, SDVariable logits, SDVariable weights, SDVariable labels, double labelSmoothing) {
        super(sameDiff, lossReduce, logits, weights, labels);
        this.labelSmoothing = labelSmoothing;
        this.tArguments.add(labelSmoothing);
    }

    public SoftmaxCrossEntropyLoss(SameDiff sameDiff, LossReduce lossReduce, SDVariable logits, SDVariable weights, SDVariable labels) {
        this(sameDiff, lossReduce, logits, weights, labels, 0.0);
    }

    public SoftmaxCrossEntropyLoss(INDArray labels, INDArray predictions, INDArray weights, LossReduce lossReduce, double labelSmoothing) {
        super(lossReduce, predictions, weights, labels);
        this.labelSmoothing = labelSmoothing;
        this.tArguments.add(labelSmoothing);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        super.addArgs();
        this.tArguments.add(this.labelSmoothing);
    }

    @Override
    public String opName() {
        return "softmax_cross_entropy_loss";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "SoftmaxCrossEntropy";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        if (this.tArguments.size() > 0) {
            this.labelSmoothing = (Double)this.tArguments.get(this.tArguments.size() - 1);
        }
        return new SoftmaxCrossEntropyLossBp(this.sameDiff, this.lossReduce, this.arg(0), this.arg(1), this.arg(2), this.labelSmoothing).outputs();
    }

    public SoftmaxCrossEntropyLoss() {
    }
}

