/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv3DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv3DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeConv3D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DeConv3D.class);
    protected DeConv3DConfig config;

    public DeConv3D(SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull DeConv3DConfig config) {
        super(sameDiff, DeConv3D.toArr(input, weights, bias));
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.addArgs();
    }

    public DeConv3D(SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable weights, @NonNull DeConv3DConfig config) {
        super(sameDiff, DeConv3D.toArr(input, weights, null));
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.addArgs();
    }

    public DeConv3D(INDArray[] inputs, INDArray[] outputs, DeConv3DConfig config) {
        super(inputs, outputs);
        this.config = config;
        this.addArgs();
    }

    public DeConv3D(@NonNull INDArray input, @NonNull INDArray weights, INDArray bias, INDArray output, @NonNull DeConv3DConfig config) {
        this(DeConv3D.wrapFilterNull(input, weights, bias), DeConv3D.wrapOrNull(output), config);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public DeConv3D(INDArray input, INDArray weights, INDArray bias, DeConv3DConfig config) {
        this(input, weights, bias, null, config);
    }

    private static SDVariable[] toArr(SDVariable input, SDVariable weights, SDVariable bias) {
        if (bias != null) {
            return new SDVariable[]{input, weights, bias};
        }
        return new SDVariable[]{input, weights};
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = DeConv3DConfig.builder().kD((Long)this.iArguments.get(0)).kH((Long)this.iArguments.get(1)).kW((Long)this.iArguments.get(2)).sD((Long)this.iArguments.get(3)).sH((Long)this.iArguments.get(4)).sW((Long)this.iArguments.get(5)).pD((Long)this.iArguments.get(6)).pH((Long)this.iArguments.get(7)).pW((Long)this.iArguments.get(8)).dD((Long)this.iArguments.get(9)).dH((Long)this.iArguments.get(10)).dW((Long)this.iArguments.get(11)).isSameMode((Long)this.iArguments.get(12) == 1L).dataFormat((Long)this.iArguments.get(13) == 1L ? "NDHWC" : "NCDHW").build();
        }
        return this.config.toProperties();
    }

    @Override
    public void configureFromArguments() {
        if (this.config == null && this.iArguments.size() >= 14) {
            DeConv3DConfig.DeConv3DConfigBuilder builder = DeConv3DConfig.builder();
            builder.kD(this.getIArgument(0));
            builder.kH(this.getIArgument(1));
            builder.kW(this.getIArgument(2));
            builder.sD(this.getIArgument(3));
            builder.sH(this.getIArgument(4));
            builder.sW(this.getIArgument(5));
            builder.pD(this.getIArgument(6));
            builder.pH(this.getIArgument(7));
            builder.pW(this.getIArgument(8));
            builder.dD(this.getIArgument(9));
            builder.dH(this.getIArgument(10));
            builder.dW(this.getIArgument(11));
            builder.isSameMode(this.getIArgument(12) > 0L);
            builder.dataFormat(this.getIArgument(13) > 0L ? "NCDHW" : "NCHWDC");
            this.config = builder.build();
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (this.config == null) {
            Boolean isSameMode;
            Long kH;
            Long kW;
            Long kD;
            Long pH;
            Long sH;
            Long pD;
            Long dW;
            Long sD;
            Long pW;
            Long sW;
            Long dH;
            DeConv3DConfig.DeConv3DConfigBuilder builder = DeConv3DConfig.builder();
            Long dD = this.getLongValueFromProperty("dD", properties);
            if (dD != null) {
                builder.dD(dD);
            }
            if ((dH = this.getLongValueFromProperty("dH", properties)) != null) {
                builder.dH(dH);
            }
            if ((sW = this.getLongValueFromProperty("sW", properties)) != null) {
                builder.sW(sW);
            }
            if ((pW = this.getLongValueFromProperty("pW", properties)) != null) {
                builder.pW(pW);
            }
            if ((sD = this.getLongValueFromProperty("sD", properties)) != null) {
                builder.sD(sD);
            }
            if ((dW = this.getLongValueFromProperty("dW", properties)) != null) {
                builder.dW(dW);
            }
            if ((pD = this.getLongValueFromProperty("pD", properties)) != null) {
                builder.pD(pD);
            }
            if ((sH = this.getLongValueFromProperty("sH", properties)) != null) {
                builder.sH(sH);
            }
            if ((pH = this.getLongValueFromProperty("pH", properties)) != null) {
                builder.pH(pH);
            }
            if ((kD = this.getLongValueFromProperty("kD", properties)) != null) {
                builder.kD(kD);
            }
            if ((kW = this.getLongValueFromProperty("kW", properties)) != null) {
                builder.kW(kW);
            }
            if ((kH = this.getLongValueFromProperty("kH", properties)) != null) {
                builder.kH(kH);
            }
            if ((isSameMode = this.getBooleanFromProperty("isSameMode", properties)) != null) {
                builder.isSameMode(isSameMode);
            }
            if (properties.containsKey("dataFormat")) {
                builder.dataFormat(properties.get("dataFormat").toString());
            }
            this.config = builder.build();
        }
    }

    private void addArgs() {
        this.addIArgument(this.config.getKD());
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getSD());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getPD());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getDD());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.getDW());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isSameMode()));
        this.addIArgument(this.config.getDataFormat().equalsIgnoreCase("NCDHW") ? 0 : 1);
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = DeConv3DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public String opName() {
        return "deconv3d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable bias = this.args().length > 2 ? this.arg(2) : null;
        return new DeConv3DDerivative(this.sameDiff, this.arg(0), this.arg(1), bias, f1.get(0), this.config).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public DeConv3DConfig getConfig() {
        return this.config;
    }

    public DeConv3D() {
    }
}

