/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.kotlin.FullyQualifiedKotlinType;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinType;
import org.mybatis.generator.codegen.AbstractKotlinGenerator;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.runtime.kotlin.KotlinDynamicSqlSupportClassGenerator;
import org.mybatis.generator.runtime.kotlin.elements.AbstractKotlinFunctionGenerator;
import org.mybatis.generator.runtime.kotlin.elements.BasicInsertMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.BasicMultipleInsertMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.BasicSelectManyMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.BasicSelectOneMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.ColumnListGenerator;
import org.mybatis.generator.runtime.kotlin.elements.DeleteByPrimaryKeyMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.GeneralCountMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.GeneralDeleteMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.GeneralSelectDistinctMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.GeneralSelectMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.GeneralSelectOneMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.GeneralUpdateMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.InsertMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.InsertMultipleMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.InsertMultipleVarargMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.InsertSelectiveMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFragmentGenerator;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFunctionAndImports;
import org.mybatis.generator.runtime.kotlin.elements.KotlinPropertyAndImports;
import org.mybatis.generator.runtime.kotlin.elements.SelectByPrimaryKeyMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.UpdateAllColumnsMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.UpdateByPrimaryKeyMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.UpdateByPrimaryKeySelectiveMethodGenerator;
import org.mybatis.generator.runtime.kotlin.elements.UpdateSelectiveColumnsMethodGenerator;

public class KotlinMapperAndExtensionsGenerator
extends AbstractKotlinGenerator {
    protected FullyQualifiedKotlinType recordType;
    protected String resultMapId;
    protected KotlinFragmentGenerator fragmentGenerator;
    protected KotlinDynamicSqlSupportClassGenerator supportClassGenerator;
    protected boolean hasGeneratedKeys;

    public KotlinMapperAndExtensionsGenerator(String project) {
        super(project);
    }

    protected void preCalculate() {
        this.supportClassGenerator = new KotlinDynamicSqlSupportClassGenerator(this.context, this.introspectedTable, this.warnings);
        this.recordType = new FullyQualifiedKotlinType(this.introspectedTable.getKotlinRecordType());
        this.resultMapId = this.recordType.getShortNameWithoutTypeArguments() + "Result";
        this.fragmentGenerator = new KotlinFragmentGenerator.Builder().withIntrospectedTable(this.introspectedTable).withResultMapId(this.resultMapId).withDynamicSqlSupportClassGenerator(this.supportClassGenerator).withTableFieldName(this.supportClassGenerator.getTablePropertyName()).build();
        this.hasGeneratedKeys = this.introspectedTable.getGeneratedKey().isPresent();
    }

    protected KotlinFile createMapperInterfaceFile() {
        FullyQualifiedKotlinType type = new FullyQualifiedKotlinType(this.introspectedTable.getMyBatis3JavaMapperType());
        KotlinFile kf = new KotlinFile(type.getShortNameWithoutTypeArguments());
        kf.setPackage(type.getPackageName());
        return kf;
    }

    protected KotlinType createMapperInterface(KotlinFile kotlinFile) {
        FullyQualifiedKotlinType type = new FullyQualifiedKotlinType(this.introspectedTable.getMyBatis3JavaMapperType());
        KotlinType intf = ((KotlinType.Builder)KotlinType.newInterface(type.getShortNameWithoutTypeArguments()).withAnnotation("@Mapper")).build();
        kotlinFile.addImport("org.apache.ibatis.annotations.Mapper");
        kotlinFile.addNamedItem(intf);
        this.context.getCommentGenerator().addFileComment(kotlinFile);
        return intf;
    }

    protected void addBasicInsertMethod(KotlinFile kotlinFile, KotlinType kotlinType) {
        BasicInsertMethodGenerator generator = ((BasicInsertMethodGenerator.Builder)((BasicInsertMethodGenerator.Builder)((BasicInsertMethodGenerator.Builder)new BasicInsertMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).withKotlinFile(kotlinFile).build();
        this.generate(kotlinFile, kotlinType, generator);
    }

    protected boolean addBasicSelectManyMethod(KotlinFile kotlinFile, KotlinType kotlinType) {
        BasicSelectManyMethodGenerator generator = ((BasicSelectManyMethodGenerator.Builder)((BasicSelectManyMethodGenerator.Builder)((BasicSelectManyMethodGenerator.Builder)new BasicSelectManyMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).build();
        return this.generate(kotlinFile, kotlinType, generator);
    }

    protected boolean generate(KotlinFile kotlinFile, AbstractKotlinFunctionGenerator generator) {
        KotlinFunctionAndImports mi = generator.generateMethodAndImports();
        if (mi != null && generator.callPlugins(mi.getFunction(), kotlinFile)) {
            kotlinFile.addNamedItem(mi.getFunction());
            kotlinFile.addImports(mi.getImports());
            return true;
        }
        return false;
    }

    protected boolean generate(KotlinFile kotlinFile, KotlinType kotlinType, AbstractKotlinFunctionGenerator generator) {
        KotlinFunctionAndImports mi = generator.generateMethodAndImports();
        if (mi != null && generator.callPlugins(mi.getFunction(), kotlinFile)) {
            kotlinType.addNamedItem(mi.getFunction());
            kotlinFile.addImports(mi.getImports());
            return true;
        }
        return false;
    }

    @Override
    public List<KotlinFile> getKotlinFiles() {
        this.progressCallback.startTask(Messages.getString("Progress.17", this.introspectedTable.getFullyQualifiedTable().toString()));
        this.preCalculate();
        KotlinFile mapperFile = this.createMapperInterfaceFile();
        KotlinType mapper = this.createMapperInterface(mapperFile);
        if (this.hasGeneratedKeys) {
            this.addBasicInsertMethod(mapperFile, mapper);
            this.addBasicInsertMultipleMethod(mapperFile, mapper);
        }
        boolean reuseResultMap = this.addBasicSelectManyMethod(mapperFile, mapper);
        this.addBasicSelectOneMethod(mapperFile, mapper, reuseResultMap);
        String mapperName = mapper.getName();
        this.addGeneralCountMethod(mapperFile, mapper, mapperName);
        this.addGeneralDeleteMethod(mapperFile, mapper, mapperName);
        this.addDeleteByPrimaryKeyMethod(mapperFile, mapperName);
        this.addInsertOneMethod(mapperFile, mapper, mapperName);
        this.addInsertMultipleMethod(mapperFile, mapper, mapperName);
        this.addInsertMultipleVarargMethod(mapperFile, mapperName);
        this.addInsertSelectiveMethod(mapperFile, mapper, mapperName);
        this.addColumnListProperty(mapperFile);
        this.addGeneralSelectMethod(mapperFile, mapperName);
        this.addSelectDistinctMethod(mapperFile, mapperName);
        this.addSelectByPrimaryKeyMethod(mapperFile, mapperName);
        this.addGeneralUpdateMethod(mapperFile, mapper, mapperName);
        this.addUpdateAllMethod(mapperFile);
        this.addUpdateSelectiveMethod(mapperFile);
        this.addUpdateByPrimaryKeyMethod(mapperFile, mapperName);
        this.addUpdateByPrimaryKeySelectiveMethod(mapperFile, mapperName);
        KotlinFile supportFile = this.supportClassGenerator.getKotlinFile();
        ArrayList<KotlinFile> answer = new ArrayList<KotlinFile>();
        if (this.context.getPlugins().dynamicSqlSupportGenerated(supportFile, this.supportClassGenerator.getOuterObject(), this.supportClassGenerator.getInnerClass(), this.introspectedTable)) {
            answer.add(supportFile);
        }
        if (this.context.getPlugins().mapperGenerated(mapperFile, mapper, this.introspectedTable)) {
            answer.add(mapperFile);
        }
        return answer;
    }

    protected void addInsertOneMethod(KotlinFile mapperFile, KotlinType mapper, String mapperName) {
        InsertMethodGenerator generator = ((InsertMethodGenerator.Builder)((InsertMethodGenerator.Builder)((InsertMethodGenerator.Builder)new InsertMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).withMapperName(mapperName).withSupportObjectImport(this.supportClassGenerator.getSupportObjectImport()).build();
        if (this.generate(mapperFile, generator) && !this.hasGeneratedKeys) {
            this.addCommonInsertInterface(mapperFile, mapper);
        }
    }

    protected void addCommonInsertInterface(KotlinFile mapperFile, KotlinType mapper) {
        mapper.addSuperType("CommonInsertMapper<" + this.recordType.getShortNameWithTypeArguments() + ">");
        mapperFile.addImport("org.mybatis.dynamic.sql.util.mybatis3.CommonInsertMapper");
        mapperFile.addImports(this.recordType.getImportList());
    }

    protected void addBasicInsertMultipleMethod(KotlinFile kotlinFile, KotlinType kotlinType) {
        BasicMultipleInsertMethodGenerator generator = ((BasicMultipleInsertMethodGenerator.Builder)((BasicMultipleInsertMethodGenerator.Builder)((BasicMultipleInsertMethodGenerator.Builder)new BasicMultipleInsertMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).build();
        this.generate(kotlinFile, kotlinType, generator);
    }

    protected void addInsertMultipleMethod(KotlinFile mapperFile, KotlinType mapper, String mapperName) {
        InsertMultipleMethodGenerator generator = ((InsertMultipleMethodGenerator.Builder)((InsertMultipleMethodGenerator.Builder)((InsertMultipleMethodGenerator.Builder)new InsertMultipleMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).withMapperName(mapperName).withSupportObjectImport(this.supportClassGenerator.getSupportObjectImport()).build();
        if (this.generate(mapperFile, generator) && !this.hasGeneratedKeys) {
            this.addCommonInsertInterface(mapperFile, mapper);
        }
    }

    protected void addInsertMultipleVarargMethod(KotlinFile kotlinFile, String mapperName) {
        InsertMultipleVarargMethodGenerator generator = ((InsertMultipleVarargMethodGenerator.Builder)((InsertMultipleVarargMethodGenerator.Builder)((InsertMultipleVarargMethodGenerator.Builder)new InsertMultipleVarargMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).withMapperName(mapperName).build();
        this.generate(kotlinFile, generator);
    }

    protected void addGeneralCountMethod(KotlinFile mapperFile, KotlinType mapper, String mapperName) {
        GeneralCountMethodGenerator generator = ((GeneralCountMethodGenerator.Builder)((GeneralCountMethodGenerator.Builder)((GeneralCountMethodGenerator.Builder)new GeneralCountMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withTableFieldImport(this.supportClassGenerator.getTablePropertyImport()).withMapperName(mapperName).build();
        if (this.generate(mapperFile, generator)) {
            mapper.addSuperType("CommonCountMapper");
            mapperFile.addImport("org.mybatis.dynamic.sql.util.mybatis3.CommonCountMapper");
        }
    }

    protected void addGeneralDeleteMethod(KotlinFile mapperFile, KotlinType mapper, String mapperName) {
        GeneralDeleteMethodGenerator generator = ((GeneralDeleteMethodGenerator.Builder)((GeneralDeleteMethodGenerator.Builder)((GeneralDeleteMethodGenerator.Builder)new GeneralDeleteMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withMapperName(mapperName).build();
        if (this.generate(mapperFile, generator)) {
            mapper.addSuperType("CommonDeleteMapper");
            mapperFile.addImport("org.mybatis.dynamic.sql.util.mybatis3.CommonDeleteMapper");
        }
    }

    protected void addColumnListProperty(KotlinFile kotlinFile) {
        ColumnListGenerator generator = new ColumnListGenerator.Builder().withContext(this.context).withIntrospectedTable(this.introspectedTable).withSupportObjectImport(this.supportClassGenerator.getSupportObjectImport()).withTableFieldName(this.supportClassGenerator.getTablePropertyName()).build();
        KotlinPropertyAndImports propertyAndImports = generator.generatePropertyAndImports();
        if (propertyAndImports != null && generator.callPlugins(propertyAndImports.getProperty(), kotlinFile)) {
            kotlinFile.addNamedItem(propertyAndImports.getProperty());
            kotlinFile.addImports(propertyAndImports.getImports());
        }
    }

    protected void addGeneralSelectMethod(KotlinFile kotlinFile, String mapperName) {
        this.addGeneralSelectOneMethod(kotlinFile, mapperName);
        GeneralSelectMethodGenerator generator = ((GeneralSelectMethodGenerator.Builder)((GeneralSelectMethodGenerator.Builder)((GeneralSelectMethodGenerator.Builder)new GeneralSelectMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withMapperName(mapperName).build();
        this.generate(kotlinFile, generator);
    }

    protected void addSelectDistinctMethod(KotlinFile kotlinFile, String mapperName) {
        GeneralSelectDistinctMethodGenerator generator = ((GeneralSelectDistinctMethodGenerator.Builder)((GeneralSelectDistinctMethodGenerator.Builder)((GeneralSelectDistinctMethodGenerator.Builder)new GeneralSelectDistinctMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withMapperName(mapperName).build();
        this.generate(kotlinFile, generator);
    }

    protected void addGeneralSelectOneMethod(KotlinFile kotlinFile, String mapperName) {
        GeneralSelectOneMethodGenerator generator = ((GeneralSelectOneMethodGenerator.Builder)((GeneralSelectOneMethodGenerator.Builder)((GeneralSelectOneMethodGenerator.Builder)new GeneralSelectOneMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withMapperName(mapperName).build();
        this.generate(kotlinFile, generator);
    }

    protected void addGeneralUpdateMethod(KotlinFile mapperFile, KotlinType mapper, String mapperName) {
        GeneralUpdateMethodGenerator generator = ((GeneralUpdateMethodGenerator.Builder)((GeneralUpdateMethodGenerator.Builder)((GeneralUpdateMethodGenerator.Builder)new GeneralUpdateMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withMapperName(mapperName).build();
        if (this.generate(mapperFile, generator)) {
            mapper.addSuperType("CommonUpdateMapper");
            mapperFile.addImport("org.mybatis.dynamic.sql.util.mybatis3.CommonUpdateMapper");
        }
    }

    protected void addUpdateAllMethod(KotlinFile kotlinFile) {
        UpdateAllColumnsMethodGenerator generator = ((UpdateAllColumnsMethodGenerator.Builder)((UpdateAllColumnsMethodGenerator.Builder)((UpdateAllColumnsMethodGenerator.Builder)new UpdateAllColumnsMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withFragmentGenerator(this.fragmentGenerator).withRecordType(this.recordType).build();
        this.generate(kotlinFile, generator);
    }

    protected void addUpdateSelectiveMethod(KotlinFile kotlinFile) {
        UpdateSelectiveColumnsMethodGenerator generator = ((UpdateSelectiveColumnsMethodGenerator.Builder)((UpdateSelectiveColumnsMethodGenerator.Builder)((UpdateSelectiveColumnsMethodGenerator.Builder)new UpdateSelectiveColumnsMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withFragmentGenerator(this.fragmentGenerator).withRecordType(this.recordType).build();
        this.generate(kotlinFile, generator);
    }

    protected void addBasicSelectOneMethod(KotlinFile kotlinFile, KotlinType kotlinType, boolean reuseResultMap) {
        BasicSelectOneMethodGenerator generator = ((BasicSelectOneMethodGenerator.Builder)((BasicSelectOneMethodGenerator.Builder)((BasicSelectOneMethodGenerator.Builder)new BasicSelectOneMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).withResultMapId(this.resultMapId).withReuseResultMap(reuseResultMap).build();
        this.generate(kotlinFile, kotlinType, generator);
    }

    protected void addDeleteByPrimaryKeyMethod(KotlinFile kotlinFile, String mapperName) {
        DeleteByPrimaryKeyMethodGenerator generator = ((DeleteByPrimaryKeyMethodGenerator.Builder)((DeleteByPrimaryKeyMethodGenerator.Builder)((DeleteByPrimaryKeyMethodGenerator.Builder)new DeleteByPrimaryKeyMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withFragmentGenerator(this.fragmentGenerator).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withMapperName(mapperName).build();
        this.generate(kotlinFile, generator);
    }

    protected void addInsertSelectiveMethod(KotlinFile mapperFile, KotlinType mapper, String mapperName) {
        InsertSelectiveMethodGenerator generator = ((InsertSelectiveMethodGenerator.Builder)((InsertSelectiveMethodGenerator.Builder)((InsertSelectiveMethodGenerator.Builder)new InsertSelectiveMethodGenerator.Builder().withContext(this.context)).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).withMapperName(mapperName).withSupportObjectImport(this.supportClassGenerator.getSupportObjectImport()).build();
        if (this.generate(mapperFile, generator) && !this.hasGeneratedKeys) {
            this.addCommonInsertInterface(mapperFile, mapper);
        }
    }

    protected void addSelectByPrimaryKeyMethod(KotlinFile kotlinFile, String mapperName) {
        SelectByPrimaryKeyMethodGenerator generator = ((SelectByPrimaryKeyMethodGenerator.Builder)((SelectByPrimaryKeyMethodGenerator.Builder)((SelectByPrimaryKeyMethodGenerator.Builder)new SelectByPrimaryKeyMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withMapperName(mapperName).build();
        this.generate(kotlinFile, generator);
    }

    protected void addUpdateByPrimaryKeyMethod(KotlinFile kotlinFile, String mapperName) {
        UpdateByPrimaryKeyMethodGenerator generator = ((UpdateByPrimaryKeyMethodGenerator.Builder)((UpdateByPrimaryKeyMethodGenerator.Builder)((UpdateByPrimaryKeyMethodGenerator.Builder)new UpdateByPrimaryKeyMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).withMapperName(mapperName).build();
        this.generate(kotlinFile, generator);
    }

    protected void addUpdateByPrimaryKeySelectiveMethod(KotlinFile kotlinFile, String mapperName) {
        UpdateByPrimaryKeySelectiveMethodGenerator generator = ((UpdateByPrimaryKeySelectiveMethodGenerator.Builder)((UpdateByPrimaryKeySelectiveMethodGenerator.Builder)((UpdateByPrimaryKeySelectiveMethodGenerator.Builder)new UpdateByPrimaryKeySelectiveMethodGenerator.Builder().withContext(this.context)).withFragmentGenerator(this.fragmentGenerator).withIntrospectedTable(this.introspectedTable)).withTableFieldName(this.supportClassGenerator.getTablePropertyName())).withRecordType(this.recordType).withMapperName(mapperName).build();
        this.generate(kotlinFile, generator);
    }
}

