/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements;

import java.util.HashSet;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;

public class InsertMethodGenerator
extends AbstractMethodGenerator {
    private final FullyQualifiedJavaType recordType;

    private InsertMethodGenerator(Builder builder) {
        super(builder);
        this.recordType = builder.recordType;
    }

    @Override
    public MethodAndImports generateMethodAndImports() {
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        imports.add(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.mybatis3.MyBatis3Utils"));
        imports.add(this.recordType);
        Method method = new Method("insert");
        method.setDefault(true);
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addParameter(new Parameter(this.recordType, "row"));
        method.addBodyLine("return MyBatis3Utils.insert(this::insert, row, " + this.tableFieldName + ", c ->");
        List<IntrospectedColumn> columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns(this.introspectedTable.getAllColumns());
        boolean first = true;
        for (IntrospectedColumn column : columns) {
            String fieldName = this.calculateFieldName(column);
            if (first) {
                method.addBodyLine("    c.map(" + fieldName + ").toProperty(\"" + column.getJavaProperty() + "\")");
                first = false;
                continue;
            }
            method.addBodyLine("    .map(" + fieldName + ").toProperty(\"" + column.getJavaProperty() + "\")");
        }
        method.addBodyLine(");");
        return MethodAndImports.withMethod(method).withImports(imports).build();
    }

    @Override
    public boolean callPlugins(Method method, Interface interfaze) {
        return this.context.getPlugins().clientInsertMethodGenerated(method, interfaze, this.introspectedTable);
    }

    public static class Builder
    extends AbstractMethodGenerator.BaseBuilder<Builder> {
        private FullyQualifiedJavaType recordType;

        public Builder withRecordType(FullyQualifiedJavaType recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public InsertMethodGenerator build() {
            return new InsertMethodGenerator(this);
        }
    }
}

