/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodParts;

public class FragmentGenerator {
    private final IntrospectedTable introspectedTable;
    private final String resultMapId;
    private final String tableFieldName;

    private FragmentGenerator(Builder builder) {
        this.introspectedTable = builder.introspectedTable;
        this.resultMapId = builder.resultMapId;
        this.tableFieldName = builder.tableFieldName;
    }

    public String getSelectList() {
        return this.introspectedTable.getAllColumns().stream().map(c -> AbstractMethodGenerator.calculateFieldName(this.tableFieldName, c)).collect(Collectors.joining(", "));
    }

    public MethodParts getPrimaryKeyWhereClauseAndParameters() {
        MethodParts.Builder builder = new MethodParts.Builder();
        boolean first = true;
        for (IntrospectedColumn column : this.introspectedTable.getPrimaryKeyColumns()) {
            String fieldName = AbstractMethodGenerator.calculateFieldName(this.tableFieldName, column);
            builder.withImport(column.getFullyQualifiedJavaType());
            builder.withParameter(new Parameter(column.getFullyQualifiedJavaType(), column.getJavaProperty() + "_"));
            if (first) {
                builder.withBodyLine("    c.where(" + fieldName + ", isEqualTo(" + column.getJavaProperty() + "_))");
                first = false;
                continue;
            }
            builder.withBodyLine("    .and(" + fieldName + ", isEqualTo(" + column.getJavaProperty() + "_))");
        }
        builder.withBodyLine(");");
        return builder.build();
    }

    public List<String> getPrimaryKeyWhereClauseForUpdate(String prefix) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean first = true;
        for (IntrospectedColumn column : this.introspectedTable.getPrimaryKeyColumns()) {
            String fieldName = AbstractMethodGenerator.calculateFieldName(this.tableFieldName, column);
            String methodName = JavaBeansUtil.getGetterMethodName(column.getJavaProperty(), column.getFullyQualifiedJavaType());
            if (first) {
                lines.add(prefix + ".where(" + fieldName + ", isEqualTo(row::" + methodName + "))");
                first = false;
                continue;
            }
            lines.add(prefix + ".and(" + fieldName + ", isEqualTo(row::" + methodName + "))");
        }
        return lines;
    }

    public MethodParts getAnnotatedConstructorArgs() {
        IntrospectedColumn introspectedColumn;
        MethodParts.Builder builder = new MethodParts.Builder();
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.type.JdbcType"));
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.ConstructorArgs"));
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Arg"));
        builder.withAnnotation("@ConstructorArgs({");
        StringBuilder sb = new StringBuilder();
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        Iterator<IntrospectedColumn> iterPk = this.introspectedTable.getPrimaryKeyColumns().iterator();
        Iterator<IntrospectedColumn> iterNonPk = this.introspectedTable.getNonPrimaryKeyColumns().iterator();
        while (iterPk.hasNext()) {
            introspectedColumn = iterPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(this.getArgAnnotation(imports, introspectedColumn, true));
            if (iterPk.hasNext() || iterNonPk.hasNext()) {
                sb.append(',');
            }
            builder.withAnnotation(sb.toString());
        }
        while (iterNonPk.hasNext()) {
            introspectedColumn = iterNonPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(this.getArgAnnotation(imports, introspectedColumn, false));
            if (iterNonPk.hasNext()) {
                sb.append(',');
            }
            builder.withAnnotation(sb.toString());
        }
        builder.withAnnotation("})").withImports(imports);
        return builder.build();
    }

    public MethodParts getAnnotatedResults() {
        IntrospectedColumn introspectedColumn;
        MethodParts.Builder builder = new MethodParts.Builder();
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.type.JdbcType"));
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Result"));
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Results"));
        builder.withAnnotation("@Results(id=\"" + this.resultMapId + "\", value = {");
        StringBuilder sb = new StringBuilder();
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        Iterator<IntrospectedColumn> iterPk = this.introspectedTable.getPrimaryKeyColumns().iterator();
        Iterator<IntrospectedColumn> iterNonPk = this.introspectedTable.getNonPrimaryKeyColumns().iterator();
        while (iterPk.hasNext()) {
            introspectedColumn = iterPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(this.getResultAnnotation(imports, introspectedColumn, true));
            if (iterPk.hasNext() || iterNonPk.hasNext()) {
                sb.append(',');
            }
            builder.withAnnotation(sb.toString());
        }
        while (iterNonPk.hasNext()) {
            introspectedColumn = iterNonPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(this.getResultAnnotation(imports, introspectedColumn, false));
            if (iterNonPk.hasNext()) {
                sb.append(',');
            }
            builder.withAnnotation(sb.toString());
        }
        builder.withAnnotation("})").withImports(imports);
        return builder.build();
    }

    private String getArgAnnotation(Set<FullyQualifiedJavaType> imports, IntrospectedColumn introspectedColumn, boolean idColumn) {
        imports.add(introspectedColumn.getFullyQualifiedJavaType());
        return "@Arg(column=\"" + introspectedColumn.getActualColumnName() + "\", javaType=" + introspectedColumn.getFullyQualifiedJavaType().getShortName() + ".class" + this.generateAdditionalItems(imports, introspectedColumn, idColumn) + ')';
    }

    private String getResultAnnotation(Set<FullyQualifiedJavaType> imports, IntrospectedColumn introspectedColumn, boolean idColumn) {
        return "@Result(column=\"" + introspectedColumn.getActualColumnName() + "\", property=\"" + introspectedColumn.getJavaProperty() + '\"' + this.generateAdditionalItems(imports, introspectedColumn, idColumn) + ')';
    }

    private String generateAdditionalItems(Set<FullyQualifiedJavaType> imports, IntrospectedColumn introspectedColumn, boolean idColumn) {
        StringBuilder sb = new StringBuilder();
        if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(introspectedColumn.getTypeHandler());
            imports.add(fqjt);
            sb.append(", typeHandler=");
            sb.append(fqjt.getShortName());
            sb.append(".class");
        }
        sb.append(", jdbcType=JdbcType.");
        sb.append(introspectedColumn.getJdbcTypeName());
        if (idColumn) {
            sb.append(", id=true");
        }
        return sb.toString();
    }

    public MethodParts getGeneratedKeyAnnotation(GeneratedKey gk) {
        MethodParts.Builder builder = new MethodParts.Builder();
        StringBuilder sb = new StringBuilder();
        this.introspectedTable.getColumn(gk.getColumn()).ifPresent(introspectedColumn -> {
            if (gk.isJdbcStandard()) {
                builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Options"));
                sb.append("@Options(useGeneratedKeys=true,keyProperty=\"row.");
                sb.append(introspectedColumn.getJavaProperty());
                sb.append("\")");
            } else {
                builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.SelectKey"));
                FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
                sb.append("@SelectKey(statement=\"");
                sb.append(gk.getRuntimeSqlStatement());
                sb.append("\", keyProperty=\"row.");
                sb.append(introspectedColumn.getJavaProperty());
                sb.append("\", before=");
                sb.append(gk.isIdentity() ? "false" : "true");
                sb.append(", resultType=");
                sb.append(fqjt.getShortName());
                sb.append(".class)");
            }
            builder.withAnnotation(sb.toString());
        });
        return builder.build();
    }

    public List<String> getSetEqualLines(List<IntrospectedColumn> columnList, String firstLinePrefix, String subsequentLinePrefix, boolean terminate) {
        return this.getSetLines(columnList, firstLinePrefix, subsequentLinePrefix, terminate, "equalTo");
    }

    public List<String> getSetEqualWhenPresentLines(List<IntrospectedColumn> columnList, String firstLinePrefix, String subsequentLinePrefix, boolean terminate) {
        return this.getSetLines(columnList, firstLinePrefix, subsequentLinePrefix, terminate, "equalToWhenPresent");
    }

    private List<String> getSetLines(List<IntrospectedColumn> columnList, String firstLinePrefix, String subsequentLinePrefix, boolean terminate, String fragment) {
        ArrayList<String> lines = new ArrayList<String>();
        List<IntrospectedColumn> columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns(columnList);
        Iterator<IntrospectedColumn> iter = columns.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String start;
            IntrospectedColumn column = iter.next();
            String fieldName = AbstractMethodGenerator.calculateFieldName(this.tableFieldName, column);
            String methodName = JavaBeansUtil.getGetterMethodName(column.getJavaProperty(), column.getFullyQualifiedJavaType());
            if (first) {
                start = firstLinePrefix;
                first = false;
            } else {
                start = subsequentLinePrefix;
            }
            String line = start + ".set(" + fieldName + ")." + fragment + "(row::" + methodName + ")";
            if (terminate && !iter.hasNext()) {
                line = line + ";";
            }
            lines.add(line);
        }
        return lines;
    }

    public static class Builder {
        private IntrospectedTable introspectedTable;
        private String resultMapId;
        private String tableFieldName;

        public Builder withIntrospectedTable(IntrospectedTable introspectedTable) {
            this.introspectedTable = introspectedTable;
            return this;
        }

        public Builder withResultMapId(String resultMapId) {
            this.resultMapId = resultMapId;
            return this;
        }

        public Builder withTableFieldName(String tableFieldName) {
            this.tableFieldName = tableFieldName;
            return this;
        }

        public FragmentGenerator build() {
            return new FragmentGenerator(this);
        }
    }
}

