/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.logging.Log;
import org.mybatis.generator.logging.LogFactory;

public class ClassloaderUtility {
    private static final Log LOG = LogFactory.getLog(ClassloaderUtility.class);

    private ClassloaderUtility() {
    }

    public static ClassLoader getCustomClassloader(Collection<String> entries) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (entries != null) {
            for (String classPathEntry : entries) {
                File file = new File(classPathEntry);
                if (!file.exists()) {
                    LOG.warn(Messages.getString("Warning.31", classPathEntry));
                    continue;
                }
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(Messages.getString("RuntimeError.9", classPathEntry));
                }
            }
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }
}

