/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen;

import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractGenerator;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public abstract class AbstractJavaGenerator
extends AbstractGenerator {
    private final String project;

    public abstract List<CompilationUnit> getCompilationUnits();

    protected AbstractJavaGenerator(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public static Method getGetter(Field field) {
        Method method = new Method(JavaBeansUtil.getGetterMethodName(field.getName(), field.getType()));
        method.setReturnType(field.getType());
        method.setVisibility(JavaVisibility.PUBLIC);
        String s = "return " + field.getName() + ';';
        method.addBodyLine(s);
        return method;
    }

    public String getRootClass() {
        String rootClass = this.introspectedTable.getTableConfigurationProperty("rootClass");
        if (rootClass == null) {
            Properties properties = this.context.getJavaModelGeneratorConfiguration().getProperties();
            rootClass = properties.getProperty("rootClass");
        }
        return rootClass;
    }

    protected void addDefaultConstructor(TopLevelClass topLevelClass) {
        topLevelClass.addMethod(this.getDefaultConstructor(topLevelClass));
    }

    protected void addDefaultConstructorWithGeneratedAnnotatoin(TopLevelClass topLevelClass) {
        topLevelClass.addMethod(this.getDefaultConstructorWithGeneratedAnnotation(topLevelClass));
    }

    private Method getDefaultConstructor(TopLevelClass topLevelClass) {
        Method method = this.getBasicConstructor(topLevelClass);
        this.addGeneratedJavaDoc(method);
        return method;
    }

    private Method getDefaultConstructorWithGeneratedAnnotation(TopLevelClass topLevelClass) {
        Method method = this.getBasicConstructor(topLevelClass);
        this.addGeneratedAnnotation(method, topLevelClass);
        return method;
    }

    private Method getBasicConstructor(TopLevelClass topLevelClass) {
        Method method = new Method(topLevelClass.getType().getShortName());
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setConstructor(true);
        method.addBodyLine("super();");
        return method;
    }

    private void addGeneratedJavaDoc(Method method) {
        this.context.getCommentGenerator().addGeneralMethodComment(method, this.introspectedTable);
    }

    private void addGeneratedAnnotation(Method method, TopLevelClass topLevelClass) {
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, topLevelClass.getImportedTypes());
    }
}

