/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java.render;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaDomUtils;
import org.mybatis.generator.api.dom.java.render.RenderingUtilities;
import org.mybatis.generator.internal.util.CustomCollectors;

public class InnerEnumRenderer {
    public List<String> render(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        List<String> lines = new ArrayList<String>();
        lines.addAll(innerEnum.getJavaDocLines());
        lines.addAll(innerEnum.getAnnotations());
        lines.add(this.renderFirstLine(innerEnum, compilationUnit));
        lines.addAll(this.renderEnumConstants(innerEnum));
        lines.addAll(RenderingUtilities.renderFields(innerEnum.getFields(), compilationUnit));
        lines.addAll(RenderingUtilities.renderInitializationBlocks(innerEnum.getInitializationBlocks()));
        lines.addAll(RenderingUtilities.renderClassOrEnumMethods(innerEnum.getMethods(), compilationUnit));
        lines.addAll(RenderingUtilities.renderInnerClasses(innerEnum.getInnerClasses(), compilationUnit));
        lines.addAll(RenderingUtilities.renderInnerInterfaces(innerEnum.getInnerInterfaces(), compilationUnit));
        lines.addAll(RenderingUtilities.renderInnerEnums(innerEnum.getInnerEnums(), compilationUnit));
        lines = RenderingUtilities.removeLastEmptyLine(lines);
        lines.add("}");
        return lines;
    }

    private String renderFirstLine(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        sb.append(innerEnum.getVisibility().getValue());
        if (innerEnum.isStatic()) {
            sb.append("static ");
        }
        sb.append("enum ");
        sb.append(innerEnum.getType().getShortName());
        sb.append(this.renderSuperInterfaces(innerEnum, compilationUnit));
        sb.append(" {");
        return sb.toString();
    }

    private List<String> renderEnumConstants(InnerEnum innerEnum) {
        ArrayList<String> answer = new ArrayList<String>();
        Iterator<String> iter = innerEnum.getEnumConstants().iterator();
        while (iter.hasNext()) {
            String enumConstant = iter.next();
            if (iter.hasNext()) {
                answer.add("    " + enumConstant + ",");
                continue;
            }
            answer.add("    " + enumConstant + ";");
        }
        answer.add("");
        return answer;
    }

    private String renderSuperInterfaces(InnerEnum innerEnum, CompilationUnit compilationUnit) {
        return innerEnum.getSuperInterfaceTypes().stream().map(tp -> JavaDomUtils.calculateTypeName(compilationUnit, tp)).collect(CustomCollectors.joining(", ", " implements ", ""));
    }
}

