/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api;

import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.dom.java.CompilationUnit;

public class GeneratedJavaFile
extends GeneratedFile {
    private final CompilationUnit compilationUnit;
    private final String fileEncoding;
    private final JavaFormatter javaFormatter;

    public GeneratedJavaFile(CompilationUnit compilationUnit, String targetProject, String fileEncoding, JavaFormatter javaFormatter) {
        super(targetProject);
        this.compilationUnit = compilationUnit;
        this.fileEncoding = fileEncoding;
        this.javaFormatter = javaFormatter;
    }

    public GeneratedJavaFile(CompilationUnit compilationUnit, String targetProject, JavaFormatter javaFormatter) {
        this(compilationUnit, targetProject, null, javaFormatter);
    }

    @Override
    public String getFormattedContent() {
        return this.javaFormatter.getFormattedContent(this.compilationUnit);
    }

    @Override
    public String getFileName() {
        return this.compilationUnit.getType().getShortNameWithoutTypeArguments() + ".java";
    }

    @Override
    public String getTargetPackage() {
        return this.compilationUnit.getType().getPackageName();
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    @Override
    public boolean isMergeable() {
        return true;
    }

    @Override
    public String getFileEncoding() {
        return this.fileEncoding;
    }
}

