/*
 *    Copyright 2006-2022 the original author or authors.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.mybatis.generator.api.dom.xml;

public class PublicDocType implements DocType {
    private final String dtdLocation;
    private final String dtdName;

    public PublicDocType(String dtdName, String dtdLocation) {
        super();
        this.dtdName = dtdName;
        this.dtdLocation = dtdLocation;
    }

    public String getDtdLocation() {
        return dtdLocation;
    }

    public String getDtdName() {
        return dtdName;
    }

    @Override
    public <R> R accept(DocTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}
