/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.modelmapper.internal.converter.ArrayConverter;
import org.modelmapper.internal.converter.AssignableConverter;
import org.modelmapper.internal.converter.BooleanConverter;
import org.modelmapper.internal.converter.CalendarConverter;
import org.modelmapper.internal.converter.CharacterConverter;
import org.modelmapper.internal.converter.DateConverter;
import org.modelmapper.internal.converter.EnumConverter;
import org.modelmapper.internal.converter.MapConverter;
import org.modelmapper.internal.converter.MergingCollectionConverter;
import org.modelmapper.internal.converter.NumberConverter;
import org.modelmapper.internal.converter.StringConverter;
import org.modelmapper.spi.ConditionalConverter;

public final class ConverterStore {
    private static final ConditionalConverter<?, ?>[] DEFAULT_CONVERTERS = new ConditionalConverter[]{new ArrayConverter(), new MergingCollectionConverter(), new MapConverter(), new AssignableConverter(), new StringConverter(), new EnumConverter(), new NumberConverter(), new BooleanConverter(), new CharacterConverter(), new DateConverter(), new CalendarConverter()};
    private final List<ConditionalConverter<?, ?>> converters;

    public ConverterStore() {
        this(new CopyOnWriteArrayList(DEFAULT_CONVERTERS));
    }

    ConverterStore(List<ConditionalConverter<?, ?>> converters) {
        this.converters = converters;
    }

    public <S, D> ConditionalConverter<S, D> getFirstSupported(Class<?> sourceType, Class<?> destinationType) {
        ConditionalConverter<?, ?> firstPartialMatchConverter = null;
        for (ConditionalConverter<?, ?> converter : this.converters) {
            ConditionalConverter.MatchResult matchResult = converter.match(sourceType, destinationType);
            if (matchResult == ConditionalConverter.MatchResult.FULL) {
                return converter;
            }
            if (firstPartialMatchConverter != null || matchResult != ConditionalConverter.MatchResult.PARTIAL) continue;
            firstPartialMatchConverter = converter;
        }
        return firstPartialMatchConverter;
    }

    public List<ConditionalConverter<?, ?>> getConverters() {
        return this.converters;
    }

    public ConverterStore removeConverter(Class<? extends ConditionalConverter<?, ?>> converterClass) {
        ConditionalConverter<?, ?> matchConverter = this.getConverterByType(converterClass);
        if (matchConverter != null) {
            this.converters.remove(matchConverter);
        }
        return this;
    }

    public boolean hasConverter(Class<? extends ConditionalConverter<?, ?>> converterClass) {
        return this.getConverterByType(converterClass) != null;
    }

    public ConverterStore addConverter(ConditionalConverter<?, ?> converter) {
        this.converters.add(converter);
        return this;
    }

    private ConditionalConverter<?, ?> getConverterByType(Class<? extends ConditionalConverter<?, ?>> converterClass) {
        for (ConditionalConverter<?, ?> converter : this.converters) {
            if (!converter.getClass().equals(converterClass)) continue;
            return converter;
        }
        return null;
    }
}

