/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.modelmapper.Condition;
import org.modelmapper.Converter;
import org.modelmapper.ExpressionMap;
import org.modelmapper.PropertyMap;
import org.modelmapper.Provider;
import org.modelmapper.TypeMap;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.ConfigurableMapExpressionImpl;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.ImplicitMappingBuilder;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.InternalMapping;
import org.modelmapper.internal.MappingContextImpl;
import org.modelmapper.internal.MappingEngineImpl;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.internal.PropertyReferenceCollector;
import org.modelmapper.internal.ReferenceMapExpressionImpl;
import org.modelmapper.internal.TypeInfo;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.util.Objects;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.DestinationSetter;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.SourceGetter;
import org.modelmapper.spi.TypeSafeSourceGetter;

class TypeMapImpl<S, D>
implements TypeMap<S, D> {
    private final Class<S> sourceType;
    private final Class<D> destinationType;
    private final String name;
    final InheritingConfiguration configuration;
    private final MappingEngineImpl engine;
    private final Map<String, InternalMapping> mappings = new TreeMap<String, InternalMapping>();
    private Converter<S, D> converter;
    private Converter<S, D> preConverter;
    private Converter<S, D> postConverter;
    private Condition<?, ?> condition;
    private Provider<D> provider;
    private Converter<?, ?> propertyConverter;
    private Condition<?, ?> propertyCondition;
    private Provider<?> propertyProvider;

    TypeMapImpl(Class<S> sourceType, Class<D> destinationType, String name, InheritingConfiguration configuration, MappingEngineImpl engine) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.name = name;
        this.configuration = configuration;
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeMapImpl(TypeMapImpl<? super S, ? super D> baseTypeMap, Class<S> sourceTYpe, Class<D> destinationType) {
        this.sourceType = sourceTYpe;
        this.destinationType = destinationType;
        this.name = baseTypeMap.name;
        this.configuration = baseTypeMap.configuration;
        this.engine = baseTypeMap.engine;
        Map<String, InternalMapping> map = baseTypeMap.mappings;
        synchronized (map) {
            this.mappings.putAll(baseTypeMap.mappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeMap<S, D> addMappings(PropertyMap<S, D> propertyMap) {
        if (this.sourceType.isEnum() || this.destinationType.isEnum()) {
            throw new Errors().mappingForEnum().toConfigurationException();
        }
        Map<String, InternalMapping> map = this.mappings;
        synchronized (map) {
            for (InternalMapping internalMapping : ExplicitMappingBuilder.build(this.sourceType, this.destinationType, this.configuration, propertyMap)) {
                InternalMapping existingMapping = this.addMapping(internalMapping);
                if (existingMapping == null || !existingMapping.isExplicit()) continue;
                throw new Errors().duplicateMapping(internalMapping.getLastDestinationProperty()).toConfigurationException();
            }
        }
        return this;
    }

    @Override
    public Condition<?, ?> getCondition() {
        return this.condition;
    }

    @Override
    public Converter<S, D> getConverter() {
        return this.converter;
    }

    @Override
    public Class<D> getDestinationType() {
        return this.destinationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Mapping> getMappings() {
        Map<String, InternalMapping> map = this.mappings;
        synchronized (map) {
            return new ArrayList<Mapping>(this.mappings.values());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Converter<S, D> getPostConverter() {
        return this.postConverter;
    }

    @Override
    public Converter<S, D> getPreConverter() {
        return this.preConverter;
    }

    @Override
    public Condition<?, ?> getPropertyCondition() {
        return this.propertyCondition;
    }

    @Override
    public Converter<?, ?> getPropertyConverter() {
        return this.propertyConverter;
    }

    @Override
    public Provider<?> getPropertyProvider() {
        return this.propertyProvider;
    }

    @Override
    public Provider<D> getProvider() {
        return this.provider;
    }

    @Override
    public Class<S> getSourceType() {
        return this.sourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyInfo> getUnmappedProperties() {
        PathProperties pathProperties = this.getDestinationProperties();
        Map<String, InternalMapping> map = this.mappings;
        synchronized (map) {
            for (Map.Entry<String, InternalMapping> entry : this.mappings.entrySet()) {
                pathProperties.matchAndRemove(entry.getKey());
            }
        }
        return pathProperties.get();
    }

    @Override
    public D map(S source) {
        Class sourceType = Types.deProxy(source.getClass());
        MappingContextImpl<S, Object> context = new MappingContextImpl<S, Object>(source, sourceType, null, this.destinationType, null, this.name, this.engine);
        D result = null;
        try {
            result = this.engine.typeMap(context, this);
        }
        catch (Throwable t) {
            context.errors.errorMapping(sourceType, this.destinationType, t);
        }
        context.errors.throwMappingExceptionIfErrorsExist();
        return result;
    }

    @Override
    public void map(S source, D destination) {
        Class sourceType = Types.deProxy(source.getClass());
        MappingContextImpl<S, D> context = new MappingContextImpl<S, D>(source, sourceType, destination, this.destinationType, null, this.name, this.engine);
        try {
            this.engine.typeMap(context, this);
        }
        catch (Throwable t) {
            context.errors.errorMapping(sourceType, this.destinationType, t);
        }
        context.errors.throwMappingExceptionIfErrorsExist();
    }

    @Override
    public TypeMap<S, D> setCondition(Condition<?, ?> condition) {
        this.condition = Assert.notNull(condition, "condition");
        return this;
    }

    @Override
    public TypeMap<S, D> setConverter(Converter<S, D> converter) {
        this.converter = Assert.notNull(converter, "converter");
        return this;
    }

    @Override
    public TypeMap<S, D> setPostConverter(Converter<S, D> converter) {
        this.postConverter = Assert.notNull(converter, "converter");
        return this;
    }

    @Override
    public TypeMap<S, D> setPreConverter(Converter<S, D> converter) {
        this.preConverter = Assert.notNull(converter, "converter");
        return this;
    }

    @Override
    public TypeMap<S, D> setPropertyCondition(Condition<?, ?> condition) {
        this.propertyCondition = Assert.notNull(condition, "condition");
        return this;
    }

    @Override
    public TypeMap<S, D> setPropertyConverter(Converter<?, ?> converter) {
        this.propertyConverter = Assert.notNull(converter, "converter");
        return this;
    }

    @Override
    public TypeMap<S, D> setPropertyProvider(Provider<?> provider) {
        this.propertyProvider = Assert.notNull(provider, "provider");
        return this;
    }

    @Override
    public TypeMap<S, D> setProvider(Provider<D> provider) {
        this.provider = Assert.notNull(provider, "provider");
        return this;
    }

    @Override
    public <V> TypeMap<S, D> addMapping(SourceGetter<S> sourceGetter, DestinationSetter<D, V> destinationSetter) {
        new ReferenceMapExpressionImpl<S, D>(this).map(sourceGetter, destinationSetter);
        return this;
    }

    @Override
    public TypeMap<S, D> addMappings(ExpressionMap<S, D> mapper) {
        mapper.configure(new ConfigurableMapExpressionImpl(this));
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TypeMap[").append(this.sourceType.getSimpleName()).append(" -> ").append(this.destinationType.getSimpleName());
        if (this.name != null) {
            b.append(' ').append(this.name);
        }
        return b.append(']').toString();
    }

    @Override
    public void validate() {
        if (this.converter != null || this.preConverter != null || this.postConverter != null) {
            return;
        }
        Errors errors = new Errors();
        List<PropertyInfo> unmappedProperties = this.getUnmappedProperties();
        if (!unmappedProperties.isEmpty()) {
            errors.errorUnmappedProperties(this, unmappedProperties);
        }
        errors.throwValidationExceptionIfErrorsExist();
    }

    @Override
    public <DS extends S, DD extends D> TypeMap<S, D> include(Class<DS> sourceType, Class<DD> destinationType) {
        TypeMapImpl<DS, DD> derivedTypeMap = new TypeMapImpl<DS, DD>(this, sourceType, destinationType);
        this.configuration.typeMapStore.put(derivedTypeMap);
        return this;
    }

    @Override
    public TypeMap<S, D> include(Class<? super D> baseDestinationType) {
        if (this.provider == null) {
            this.provider = new Provider<D>(){

                @Override
                public D get(Provider.ProvisionRequest<D> request) {
                    return Objects.instantiate(TypeMapImpl.this.destinationType);
                }
            };
        }
        this.configuration.typeMapStore.put(this.sourceType, baseDestinationType, this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeMap<S, D> includeBase(Class<? super S> sourceType, Class<? super D> destinationType) {
        TypeMapImpl baseTypeMap = (TypeMapImpl)this.configuration.typeMapStore.get(sourceType, destinationType, this.name);
        Assert.notNull(baseTypeMap, "Cannot find base TypeMap");
        Map<String, InternalMapping> map = baseTypeMap.mappings;
        synchronized (map) {
            for (Map.Entry<String, InternalMapping> entry : baseTypeMap.mappings.entrySet()) {
                this.addMapping(entry.getValue());
            }
        }
        return this;
    }

    @Override
    public <P> TypeMap<S, D> include(TypeSafeSourceGetter<S, P> sourceGetter, Class<P> propertyType) {
        TypeMapImpl childTypeMap = (TypeMapImpl)this.configuration.typeMapStore.get(propertyType, this.destinationType, this.name);
        Assert.notNull(childTypeMap, "Cannot find child TypeMap");
        List<Accessor> accessors = PropertyReferenceCollector.collect(this, sourceGetter);
        for (Mapping mapping : childTypeMap.getMappings()) {
            InternalMapping internalMapping = (InternalMapping)mapping;
            this.addMapping(internalMapping.createMergedCopy(accessors, Collections.emptyList()));
        }
        return this;
    }

    @Override
    public TypeMap<S, D> implicitMappings() {
        ImplicitMappingBuilder.build(null, this, this.configuration.typeMapStore, this.configuration.converterStore);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMappingIfAbsent(InternalMapping mapping) {
        Map<String, InternalMapping> map = this.mappings;
        synchronized (map) {
            if (!this.mappings.containsKey(mapping.getPath())) {
                this.mappings.put(mapping.getPath(), mapping);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalMapping addMapping(InternalMapping mapping) {
        Map<String, InternalMapping> map = this.mappings;
        synchronized (map) {
            return this.mappings.put(mapping.getPath(), mapping);
        }
    }

    boolean isSkipped(String path) {
        Mapping mapping = this.mappings.get(path);
        return mapping != null && mapping.isSkipped();
    }

    Mapping mappingFor(String path) {
        return this.mappings.get(path);
    }

    boolean isFullMatching() {
        return this.getUnmappedProperties().isEmpty() || this.configuration.valueAccessStore.getFirstSupportedReader(this.sourceType) == null;
    }

    private PathProperties getDestinationProperties() {
        PathProperties pathProperties = new PathProperties();
        HashSet classes = new HashSet();
        Stack<Property> propertyStack = new Stack<Property>();
        propertyStack.push(new Property("", TypeInfoRegistry.typeInfoFor(this.destinationType, this.configuration)));
        while (!propertyStack.isEmpty()) {
            Property property = (Property)propertyStack.pop();
            classes.add(property.typeInfo.getType());
            for (Map.Entry<String, Mutator> entry : property.typeInfo.getMutators().entrySet()) {
                if (entry.getValue() instanceof PropertyInfoImpl.FieldPropertyInfo && !this.configuration.isFieldMatchingEnabled()) continue;
                String path = property.prefix + entry.getKey() + ".";
                Mutator mutator = entry.getValue();
                pathProperties.pathProperties.add(new PathProperty(path, mutator));
                if (classes.contains(mutator.getType()) || !Types.mightContainsProperties(mutator.getType())) continue;
                propertyStack.push(new Property(path, TypeInfoRegistry.typeInfoFor(mutator.getType(), this.configuration)));
            }
        }
        return pathProperties;
    }

    private static final class PathProperty {
        String path;
        Mutator mutator;

        private PathProperty(String path, Mutator mutator) {
            this.path = path;
            this.mutator = mutator;
        }
    }

    private static final class PathProperties {
        List<PathProperty> pathProperties = new ArrayList<PathProperty>();

        private PathProperties() {
        }

        private void matchAndRemove(String path) {
            int endIndex;
            int startIndex = 0;
            while ((endIndex = path.indexOf(".", startIndex)) != -1) {
                String currentPath = path.substring(0, endIndex + 1);
                Iterator<PathProperty> iterator = this.pathProperties.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().path.equals(currentPath)) continue;
                    iterator.remove();
                }
                startIndex = endIndex + 1;
            }
            Iterator<PathProperty> iterator = this.pathProperties.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().path.startsWith(path)) continue;
                iterator.remove();
            }
        }

        public List<PropertyInfo> get() {
            ArrayList<PropertyInfo> mutators = new ArrayList<PropertyInfo>(this.pathProperties.size());
            for (PathProperty pathProperty : this.pathProperties) {
                mutators.add(pathProperty.mutator);
            }
            return mutators;
        }
    }

    private static final class Property {
        String prefix;
        TypeInfo<?> typeInfo;

        public Property(String prefix, TypeInfo<?> typeInfo) {
            this.prefix = prefix;
            this.typeInfo = typeInfo;
        }
    }
}

