/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.mbox;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import net.fortuna.mstor.connector.DelegateException;
import net.fortuna.mstor.connector.FolderDelegate;
import net.fortuna.mstor.connector.MessageDelegate;
import net.fortuna.mstor.connector.mbox.AbstractMetaFolder;
import net.fortuna.mstor.connector.mbox.YamlMetaMessage;
import net.fortuna.mstor.data.yaml.FolderExt;
import net.fortuna.mstor.data.yaml.MessageExt;
import org.ho.yaml.Yaml;
import org.ho.yaml.YamlDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlMetaFolder
extends AbstractMetaFolder<YamlMetaMessage> {
    public static final String FILE_EXTENSION = ".yml";
    private FolderExt folderExt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlMetaFolder(FolderDelegate<MessageDelegate> delegate) {
        super(delegate);
        YamlDecoder decoder = null;
        try {
            decoder = new YamlDecoder((InputStream)new FileInputStream(this.getFile()));
            this.folderExt = (FolderExt)decoder.readObjectOfType(FolderExt.class);
        }
        catch (IOException ioe) {
            this.folderExt = new FolderExt();
        }
        finally {
            if (decoder != null) {
                decoder.close();
            }
        }
    }

    @Override
    protected String getFileExtension() {
        return FILE_EXTENSION;
    }

    protected YamlMetaMessage[] removeMessages(Message[] deleted) {
        ArrayList<YamlMetaMessage> metas = new ArrayList<YamlMetaMessage>();
        block0: for (MessageExt messageExt : this.folderExt.getMessages()) {
            int messageNumber = messageExt.getMessageNumber();
            for (int n = 0; n < deleted.length; ++n) {
                if (deleted[n].getMessageNumber() != messageNumber) continue;
                this.folderExt.getMessages().remove(messageExt);
                metas.add(new YamlMetaMessage(messageExt, this));
                this.updateMessageNumbers(messageNumber, -1);
                continue block0;
            }
        }
        return metas.toArray(new YamlMetaMessage[metas.size()]);
    }

    private void updateMessageNumbers(int startIndex, int delta) {
        for (MessageExt messageExt : this.folderExt.getMessages()) {
            int messageNumber = messageExt.getMessageNumber();
            if (messageNumber < startIndex) continue;
            messageExt.setMessageNumber(messageNumber + delta);
        }
    }

    @Override
    protected void save() throws DelegateException {
        try {
            Yaml.dump((Object)this.folderExt, (File)this.getFile(), (boolean)true);
        }
        catch (IOException ioe) {
            throw new DelegateException("Error saving metadata", ioe);
        }
    }

    @Override
    protected YamlMetaMessage createMessage(int messageNumber) throws DelegateException {
        MessageExt messageExt = new MessageExt(messageNumber);
        messageExt.setFlags(new Flags());
        YamlMetaMessage delegate = new YamlMetaMessage(messageExt, this);
        if (messageNumber > 0) {
            this.folderExt.getMessages().add(messageNumber - 1, messageExt);
        }
        return delegate;
    }

    @Override
    protected void setLastUid(long uid) throws UnsupportedOperationException, DelegateException {
        this.folderExt.setLastUid(uid);
    }

    public YamlMetaFolder getFolder(String name) throws MessagingException {
        return new YamlMetaFolder(this.getDelegate().getFolder(name));
    }

    @Override
    public long getLastUid() throws UnsupportedOperationException {
        return this.folderExt.getLastUid();
    }

    @Override
    public YamlMetaMessage getMessage(int messageNumber) throws DelegateException {
        for (MessageExt messageExt : this.folderExt.getMessages()) {
            if (messageExt.getMessageNumber() != messageNumber) continue;
            return new YamlMetaMessage(messageExt, this);
        }
        YamlMetaMessage newMessage = this.createMessage(messageNumber);
        this.allocateUid(newMessage);
        return newMessage;
    }

    public YamlMetaFolder getParent() {
        return new YamlMetaFolder(this.getDelegate().getParent());
    }

    @Override
    public long getUidValidity() throws UnsupportedOperationException, MessagingException {
        if (this.folderExt.getUidValidity() <= 0L) {
            this.folderExt.setUidValidity(this.newUidValidity());
            try {
                this.save();
            }
            catch (DelegateException de) {
                throw new MessagingException("Error in delegate", (Exception)de);
            }
        }
        return this.folderExt.getUidValidity();
    }

    public YamlMetaFolder[] list(String pattern) {
        FolderDelegate<MessageDelegate>[] folders = this.getDelegate().list(pattern);
        ArrayList<YamlMetaFolder> folderList = new ArrayList<YamlMetaFolder>();
        for (int i = 0; i < folders.length; ++i) {
            folderList.add(new YamlMetaFolder(folders[i]));
        }
        return folderList.toArray(new YamlMetaFolder[folderList.size()]);
    }
}

