/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.mbox;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import net.fortuna.mstor.connector.AbstractMessageDelegate;
import net.fortuna.mstor.connector.DelegateException;
import net.fortuna.mstor.connector.MessageDelegate;
import net.fortuna.mstor.connector.mbox.MetaFolder;
import net.fortuna.mstor.data.xml.ElementBinding;
import net.fortuna.mstor.util.MessageUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaMessage
extends AbstractMessageDelegate {
    private static final long serialVersionUID = -3882112036857983804L;
    private static final String SPACE_SUBSTITUTE = "__SPACE__";
    protected static final String ELEMENT_MESSAGE = "message";
    protected static final String ATTRIBUTE_MESSAGE_NUMBER = "messageNumber";
    protected static final String ATTRIBUTE_UID = "uid";
    private static final String ELEMENT_FLAGS = "flags";
    private static final String ELEMENT_HEADERS = "headers";
    private static final String ELEMENT_EXPUNGED = "expunged";
    private static final String ELEMENT_RECEIVED = "received";
    private static final String ELEMENT_REPLIED = "replied";
    private static final String ELEMENT_FORWARDED = "forwarded";
    private static final String META_DATE_PATTERN = "EEE MMM d HH:mm:ss yyyy";
    private static final DateFormat MESSAGE_DATE_FORMAT = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
    private Log log = LogFactory.getLog(MetaMessage.class);
    private ElementBinding binding;
    private MetaFolder metaFolder;

    public MetaMessage(int messageNumber, MetaFolder folder, Namespace namespace) {
        this(new Element(ELEMENT_MESSAGE, namespace).setAttribute(ATTRIBUTE_MESSAGE_NUMBER, String.valueOf(messageNumber)), folder, namespace);
        this.metaFolder = folder;
    }

    public MetaMessage(Element element, MetaFolder folder, Namespace namespace) {
        this.binding = new ElementBinding(element, namespace);
        this.metaFolder = folder;
    }

    protected final Element getElement() {
        return this.binding.getElement();
    }

    @Override
    public final int getMessageNumber() {
        try {
            return Integer.parseInt(this.getElement().getAttributeValue(ATTRIBUTE_MESSAGE_NUMBER));
        }
        catch (Exception e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Date getReceived() {
        String received = this.binding.getElement(ELEMENT_RECEIVED).getText();
        try {
            DateFormat dateFormat = MESSAGE_DATE_FORMAT;
            synchronized (dateFormat) {
                return MESSAGE_DATE_FORMAT.parse(received);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Invalid received date [" + received + "]"));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setReceived(Date date) {
        Element received = this.binding.getElement(ELEMENT_RECEIVED);
        DateFormat dateFormat = MESSAGE_DATE_FORMAT;
        synchronized (dateFormat) {
            received.setText(MESSAGE_DATE_FORMAT.format(date));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Date getForwarded() {
        String forwarded = this.binding.getElement(ELEMENT_FORWARDED).getText();
        try {
            DateFormat dateFormat = MESSAGE_DATE_FORMAT;
            synchronized (dateFormat) {
                return MESSAGE_DATE_FORMAT.parse(forwarded);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Invalid forwarded date [" + forwarded + "]"));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setForwarded(Date date) {
        Element forwarded = this.binding.getElement(ELEMENT_FORWARDED);
        DateFormat dateFormat = MESSAGE_DATE_FORMAT;
        synchronized (dateFormat) {
            forwarded.setText(MESSAGE_DATE_FORMAT.format(date));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Date getReplied() {
        String replied = this.binding.getElement(ELEMENT_REPLIED).getText();
        try {
            DateFormat dateFormat = MESSAGE_DATE_FORMAT;
            synchronized (dateFormat) {
                return MESSAGE_DATE_FORMAT.parse(replied);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Invalid replied date [" + replied + "]"));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setReplied(Date date) {
        Element replied = this.binding.getElement(ELEMENT_REPLIED);
        DateFormat dateFormat = MESSAGE_DATE_FORMAT;
        synchronized (dateFormat) {
            replied.setText(MESSAGE_DATE_FORMAT.format(date));
        }
    }

    @Override
    public final boolean isExpunged() {
        Element expunged = this.binding.getElement(ELEMENT_EXPUNGED);
        try {
            return Boolean.valueOf(expunged.getText());
        }
        catch (Exception e) {
            this.log.warn((Object)("Invalid expunged value [" + expunged.getText() + "]"));
            return false;
        }
    }

    @Override
    public final void setExpunged(boolean flag) {
        Element expunged = this.binding.getElement(ELEMENT_EXPUNGED);
        expunged.setText(String.valueOf(flag));
    }

    @Override
    public final Flags getFlags() {
        Flags flags = new Flags();
        for (Element flagElement : this.binding.getElement(ELEMENT_FLAGS).getChildren()) {
            Flags.Flag flag = MessageUtils.getFlag(flagElement.getName());
            if (flag != null) {
                flags.add(flag);
                continue;
            }
            flags.add(flagElement.getName().replaceAll(SPACE_SUBSTITUTE, " "));
        }
        return flags;
    }

    @Override
    public final void setFlags(Flags flags) {
        int i;
        Element flagsElement = this.binding.getElement(ELEMENT_FLAGS);
        flagsElement.removeContent();
        for (i = 0; i < flags.getSystemFlags().length; ++i) {
            String flagName = MessageUtils.getFlagName(flags.getSystemFlags()[i]);
            if (flagName == null) continue;
            flagsElement.addContent((Content)new Element(flagName));
        }
        for (i = 0; i < flags.getUserFlags().length; ++i) {
            String flag = flags.getUserFlags()[i].replaceAll(" ", SPACE_SUBSTITUTE);
            flagsElement.addContent((Content)new Element(flag));
        }
    }

    @Override
    public final InternetHeaders getHeaders() {
        InternetHeaders headers = new InternetHeaders();
        for (Element header : this.binding.getElement(ELEMENT_HEADERS).getChildren()) {
            headers.addHeader(header.getName(), header.getText());
        }
        return headers;
    }

    @Override
    public final void setHeaders(Enumeration<Header> headers) {
        Element headersElement = this.binding.getElement(ELEMENT_HEADERS);
        headersElement.removeContent();
        while (headers.hasMoreElements()) {
            Header header = headers.nextElement();
            try {
                if (header.getName().startsWith("From ")) continue;
                headersElement.addContent((Content)new Element(header.getName()).setText(header.getValue()));
            }
            catch (IllegalNameException ine) {
                this.log.warn((Object)("Invalid header (ignored): " + header.getName() + "=" + header.getValue()));
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)ine);
            }
            catch (IllegalDataException ide) {
                this.log.warn((Object)("Invalid header (ignored): " + header.getName() + "=" + header.getValue()));
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)ide);
            }
        }
    }

    @Override
    public void saveChanges() throws DelegateException {
        this.metaFolder.save();
    }

    @Override
    public long getUid() {
        return Long.parseLong(this.getElement().getAttributeValue(ATTRIBUTE_UID));
    }

    @Override
    public void setUid(long uid) {
        this.getElement().setAttribute(ATTRIBUTE_UID, String.valueOf(uid));
    }

    @Override
    public MessageDelegate getInReplyTo() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Message references not supported");
    }

    @Override
    public List<? extends MessageDelegate> getReferences() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Message references not supported");
    }

    @Override
    public InputStream getInputStream() {
        return null;
    }
}

