/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import net.fortuna.mstor.connector.DelegateException;
import net.fortuna.mstor.connector.FolderDelegate;
import net.fortuna.mstor.connector.MessageDelegate;
import net.fortuna.mstor.connector.jcr.JcrConnector;
import net.fortuna.mstor.connector.jcr.JcrFolderDao;
import net.fortuna.mstor.connector.jcr.JcrMessage;
import net.fortuna.mstor.connector.jcr.JcrMessageDao;
import net.fortuna.mstor.util.MessageUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcrom.AbstractJcrEntity;
import org.jcrom.JcrMappingException;
import org.jcrom.annotations.JcrProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrFolder
extends AbstractJcrEntity
implements FolderDelegate<JcrMessage> {
    private static final Log LOG = LogFactory.getLog(JcrFolder.class);
    private static final long serialVersionUID = 4533514532820747829L;
    @JcrProperty
    private String folderName;
    @JcrProperty
    private Integer type;
    @JcrProperty
    private Long lastUid;
    @JcrProperty
    private Long uidValidity;
    private JcrFolder parent;
    private JcrConnector connector;
    private JcrFolderDao folderDao;
    private JcrMessageDao messageDao;
    private int messageCount = -1;

    @Override
    public synchronized long allocateUid(MessageDelegate message) throws UnsupportedOperationException, DelegateException {
        Long uid = this.lastUid + 1L;
        message.setUid(uid);
        this.lastUid = uid;
        return uid;
    }

    @Override
    public void appendMessages(Message[] messages) throws MessagingException {
        Date defaultReceivedDate = new Date();
        for (Message message : messages) {
            try {
                Object[] references;
                List<JcrMessage> inReplyToMessages;
                List<JcrMessage> jcrMessages;
                JcrMessage jcrMessage = null;
                boolean update = false;
                String messageId = MessageUtils.getMessageId(message);
                if (messageId != null && (jcrMessages = this.getMessageDao().findByMessageId(this.getConnector().getJcrom().getPath((Object)this) + "/messages", messageId)).size() > 0) {
                    jcrMessage = jcrMessages.get(0);
                    update = true;
                }
                if (jcrMessage == null) {
                    jcrMessage = new JcrMessage();
                    jcrMessage.setMessageNumber((int)this.getMessageDao().getSize(this.getConnector().getJcrom().getPath((Object)this) + "/messages") + 1);
                    this.allocateUid(jcrMessage);
                }
                jcrMessage.setFlags(message.getFlags());
                jcrMessage.setHeaders(message.getAllHeaders());
                if (message.getReceivedDate() != null) {
                    jcrMessage.setReceived(message.getReceivedDate());
                } else {
                    jcrMessage.setReceived(defaultReceivedDate);
                }
                jcrMessage.setExpunged(message.isExpunged());
                jcrMessage.setMessage(message);
                Object[] inReplyTo = message.getHeader("In-Reply-To");
                if (!ArrayUtils.isEmpty((Object[])inReplyTo) && !(inReplyToMessages = this.getMessageDao().findByMessageId(this.getConnector().getJcrom().getPath(this.getRootFolder()) + "/", (String)inReplyTo[0])).isEmpty()) {
                    jcrMessage.setInReplyTo(inReplyToMessages.get(0));
                    inReplyToMessages.get(0).getReferences().add(jcrMessage);
                }
                if (!ArrayUtils.isEmpty((Object[])(references = message.getHeader("References")))) {
                    for (String referenced : ((String)references[0]).split(",")) {
                        List<JcrMessage> referencedMessages = this.getMessageDao().findByMessageId(this.getConnector().getJcrom().getPath(this.getRootFolder()) + "/", referenced.trim());
                        if (referencedMessages.isEmpty()) continue;
                        jcrMessage.getReferences().addAll(referencedMessages);
                    }
                }
                if (update) {
                    this.getMessageDao().update(jcrMessage);
                    continue;
                }
                this.getMessageDao().create(this.getConnector().getJcrom().getPath((Object)this) + "/messages", jcrMessage);
            }
            catch (IOException e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        try {
            this.saveChanges();
        }
        catch (RepositoryException e) {
            throw new MessagingException("Unexpected error", (Exception)((Object)e));
        }
        this.messageCount = -1;
    }

    @Override
    public void close() throws MessagingException {
        try {
            this.saveChanges();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
    }

    @Override
    public boolean create(int type) throws MessagingException {
        this.type = type;
        if (this.parent != null) {
            this.getFolderDao().create(this.getConnector().getJcrom().getPath((Object)this.parent) + "/folders", this);
        }
        if ((2 & type) > 0) {
            try {
                this.getNode().addNode("folders");
            }
            catch (RepositoryException re) {
                throw new MessagingException("Error initialising path", (Exception)((Object)re));
            }
        }
        if ((1 & type) > 0) {
            try {
                this.getNode().addNode("messages");
            }
            catch (RepositoryException re) {
                throw new MessagingException("Error initialising path", (Exception)((Object)re));
            }
        }
        try {
            if (this.parent != null) {
                this.parent.saveChanges();
            } else {
                this.getConnector().getSession().save();
            }
            this.saveChanges();
        }
        catch (RepositoryException e) {
            throw new MessagingException("Unexpected error", (Exception)((Object)e));
        }
        return true;
    }

    @Override
    public boolean delete() {
        this.getFolderDao().remove(this.getConnector().getJcrom().getPath((Object)this));
        return true;
    }

    @Override
    public boolean exists() {
        try {
            Node node = this.getNode();
            return node != null && !node.isNew();
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return false;
        }
    }

    @Override
    public void expunge(Message[] deleted) throws MessagingException {
        for (Message message : deleted) {
            List<JcrMessage> messages = this.getMessageDao().findByMessageNumber(this.getConnector().getJcrom().getPath((Object)this) + "/messages", message.getMessageNumber());
            for (JcrMessage jcrMessage : messages) {
                jcrMessage.setExpunged(true);
            }
        }
        this.messageCount = -1;
    }

    @Override
    public FolderDelegate<JcrMessage> getFolder(String name) throws MessagingException {
        JcrFolder retVal = null;
        List<JcrFolder> folders = this.getFolderDao().findByName(this.getConnector().getJcrom().getPath((Object)this) + "/folders", name);
        if (!folders.isEmpty()) {
            retVal = folders.get(0);
        }
        if (retVal == null) {
            retVal = new JcrFolder();
            retVal.folderName = name;
            retVal.setName(name);
        }
        retVal.setParent(this);
        return retVal;
    }

    @Override
    public String getFullName() {
        return this.getConnector().getJcrom().getPath((Object)this);
    }

    @Override
    public long getLastModified() throws UnsupportedOperationException {
        return 0L;
    }

    @Override
    public long getLastUid() throws UnsupportedOperationException {
        if (this.lastUid == null) {
            this.lastUid = 1L;
        }
        return this.lastUid;
    }

    private void allocateUid(JcrMessage message) {
        long uid = this.getLastUid() + 1L;
        message.setUid(uid);
        this.lastUid = uid;
    }

    @Override
    public JcrMessage getMessage(int messageNumber) throws DelegateException {
        List<JcrMessage> messages = this.getMessageDao().findByMessageNumber(this.getConnector().getJcrom().getPath((Object)this) + "/messages", messageNumber);
        if (messages.size() > 0) {
            return messages.get(0);
        }
        return null;
    }

    @Override
    public InputStream getMessageAsStream(int index) throws IOException {
        List messages = this.getMessageDao().findAll(this.getConnector().getJcrom().getPath((Object)this) + "/messages", index - 1, 1L);
        if (!messages.isEmpty()) {
            return ((JcrMessage)messages.get(0)).getInputStream();
        }
        return null;
    }

    @Override
    public int getMessageCount() throws MessagingException {
        if (this.messageCount < 0) {
            this.messageCount = (int)this.getMessageDao().getSize(this.getConnector().getJcrom().getPath((Object)this) + "/messages");
        }
        return this.messageCount;
    }

    @Override
    public int getDeletedMessageCount() throws MessagingException, UnsupportedOperationException {
        return this.getMessageDao().findByFlag(this.getConnector().getJcrom().getPath((Object)this) + "/messages", Flags.Flag.DELETED).size();
    }

    @Override
    public FolderDelegate<JcrMessage> getParent() {
        return this.parent;
    }

    @Override
    public char getSeparator() {
        return '/';
    }

    @Override
    public int getType() {
        if (this.type != null) {
            return this.type;
        }
        return -1;
    }

    @Override
    public long getUidValidity() throws UnsupportedOperationException, MessagingException {
        return this.uidValidity;
    }

    @Override
    public FolderDelegate<JcrMessage>[] list(String pattern) {
        List<JcrFolder> folders = this.getFolderDao().findByPattern(this.getConnector().getJcrom().getPath((Object)this) + "/folders", pattern);
        for (JcrFolder folder : folders) {
            folder.setParent(this);
        }
        return folders.toArray(new JcrFolder[folders.size()]);
    }

    @Override
    public void open(int mode) {
    }

    @Override
    public boolean renameTo(String name) {
        this.folderName = name;
        return true;
    }

    @Override
    public final String getFolderName() {
        return this.folderName;
    }

    private Node getNode() throws PathNotFoundException, JcrMappingException, RepositoryException {
        String path = this.getConnector().getJcrom().getPath((Object)this);
        if (path != null) {
            return this.getConnector().getSession().getRootNode().getNode(path.substring(1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JcrFolderDao getFolderDao() {
        if (this.folderDao == null) {
            JcrFolder jcrFolder = this;
            synchronized (jcrFolder) {
                if (this.folderDao == null) {
                    this.folderDao = new JcrFolderDao(this.getConnector().getSession(), this.getConnector().getJcrom());
                }
            }
        }
        return this.folderDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JcrMessageDao getMessageDao() {
        if (this.messageDao == null) {
            JcrFolder jcrFolder = this;
            synchronized (jcrFolder) {
                if (this.messageDao == null) {
                    this.messageDao = new JcrMessageDao(this.getConnector().getSession(), this.getConnector().getJcrom());
                }
            }
        }
        return this.messageDao;
    }

    private FolderDelegate<JcrMessage> getRootFolder() {
        FolderDelegate<JcrMessage> root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    void setConnector(JcrConnector connector) {
        this.connector = connector;
    }

    private JcrConnector getConnector() {
        if (this.connector == null && this.parent != null) {
            return this.parent.getConnector();
        }
        return this.connector;
    }

    private void saveChanges() throws JcrMappingException, PathNotFoundException, RepositoryException {
        this.getFolderDao().update(this);
    }

    void setParent(JcrFolder parent) {
        this.parent = parent;
    }
}

