/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.UIDFolder;
import net.fortuna.mstor.MStorMessage;
import net.fortuna.mstor.MStorStore;
import net.fortuna.mstor.connector.DelegateException;
import net.fortuna.mstor.connector.FolderDelegate;
import net.fortuna.mstor.connector.MessageDelegate;
import net.fortuna.mstor.util.CacheAdapter;
import net.fortuna.mstor.util.Configurator;
import net.fortuna.mstor.util.EhCacheAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MStorFolder
extends Folder
implements UIDFolder {
    private static final Log LOG = LogFactory.getLog(MStorFolder.class);
    private static final String INVALID_FOLDER_TYPE_MESSAGE = "Invalid folder type";
    private boolean open;
    private FolderDelegate<? extends MessageDelegate> delegate;
    private CacheAdapter cacheAdapter;
    private MStorStore mStore;

    public MStorFolder(MStorStore store, FolderDelegate<? extends MessageDelegate> delegate) {
        super((Store)store);
        this.mStore = store;
        this.delegate = delegate;
    }

    public String getName() {
        return this.delegate.getFolderName();
    }

    public String getFullName() {
        return this.delegate.getFullName();
    }

    public Folder getParent() throws MessagingException {
        return new MStorFolder(this.mStore, this.delegate.getParent());
    }

    public boolean exists() throws MessagingException {
        return this.delegate.exists();
    }

    public Folder[] list(String pattern) throws MessagingException {
        if ((this.getType() & 2) == 0) {
            throw new MessagingException(INVALID_FOLDER_TYPE_MESSAGE);
        }
        ArrayList<MStorFolder> folders = new ArrayList<MStorFolder>();
        FolderDelegate<? extends MessageDelegate>[] childDelegates = this.delegate.list(pattern);
        for (int i = 0; i < childDelegates.length; ++i) {
            folders.add(new MStorFolder(this.mStore, childDelegates[i]));
        }
        return folders.toArray(new Folder[folders.size()]);
    }

    public char getSeparator() throws MessagingException {
        this.assertExists();
        return this.delegate.getSeparator();
    }

    public int getType() throws MessagingException {
        this.assertExists();
        return this.delegate.getType();
    }

    public boolean create(int type) throws MessagingException {
        if (this.exists()) {
            throw new MessagingException("Folder already exists");
        }
        boolean created = this.delegate.create(type);
        if (created) {
            this.notifyFolderListeners(1);
        }
        return created;
    }

    public boolean hasNewMessages() throws MessagingException {
        return false;
    }

    public Folder getFolder(String name) throws MessagingException {
        return new MStorFolder(this.mStore, this.delegate.getFolder(name));
    }

    public boolean delete(boolean recurse) throws MessagingException {
        this.assertClosed();
        boolean deleted = false;
        if ((this.getType() & 2) > 0) {
            if (recurse) {
                int i;
                ExecutorCompletionService<Boolean> processor = new ExecutorCompletionService<Boolean>(Executors.newCachedThreadPool());
                Folder[] subfolders = this.list();
                for (i = 0; i < subfolders.length; ++i) {
                    processor.submit(new DeleteFolderCommand(subfolders[i], recurse));
                }
                deleted = true;
                for (i = 0; i < subfolders.length; ++i) {
                    try {
                        if (((Boolean)processor.take().get()).booleanValue()) continue;
                        deleted = false;
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.list().length > 0) {
                deleted = false;
            }
        }
        if (deleted) {
            deleted = this.delegate.delete();
        }
        if (deleted) {
            this.notifyFolderListeners(2);
        }
        return deleted;
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        this.assertExists();
        this.assertClosed();
        boolean renamed = this.delegate.renameTo(folder.getName());
        if (renamed) {
            this.notifyFolderRenamedListeners(folder);
        }
        return renamed;
    }

    public void open(int mode) throws MessagingException {
        this.assertExists();
        this.assertClosed();
        this.delegate.open(mode);
        this.mode = mode;
        this.open = true;
        this.notifyConnectionListeners(1);
    }

    public void close(boolean expunge) throws MessagingException {
        this.assertOpen();
        if (expunge) {
            this.expunge();
        }
        this.clearMessageCache();
        this.open = false;
        this.notifyConnectionListeners(3);
        this.delegate.close();
    }

    public boolean isOpen() {
        return this.open;
    }

    public Flags getPermanentFlags() {
        return null;
    }

    public int getMessageCount() throws MessagingException {
        this.assertExists();
        if ((this.getType() & 1) == 0) {
            throw new MessagingException(INVALID_FOLDER_TYPE_MESSAGE);
        }
        if (!this.isOpen()) {
            return -1;
        }
        return this.delegate.getMessageCount();
    }

    public synchronized int getDeletedMessageCount() throws MessagingException {
        try {
            return this.delegate.getDeletedMessageCount();
        }
        catch (UnsupportedOperationException e) {
            LOG.debug((Object)e.getMessage());
            return super.getDeletedMessageCount();
        }
    }

    public Message getMessage(int index) throws MessagingException {
        this.assertExists();
        this.assertOpen();
        if (index <= 0 || index > this.getMessageCount()) {
            throw new IndexOutOfBoundsException("Message [" + index + "] does not exist");
        }
        if ((this.getType() & 1) == 0) {
            throw new MessagingException(INVALID_FOLDER_TYPE_MESSAGE);
        }
        Object message = null;
        message = this.retrieveMessageFromCache(index);
        if (message == null) {
            try {
                MessageDelegate messageDelegate = this.delegate.getMessage(index);
                message = messageDelegate != null && messageDelegate.getInputStream() != null ? new MStorMessage((Folder)this, messageDelegate.getInputStream(), index, messageDelegate) : new MStorMessage((Folder)this, this.delegate.getMessageAsStream(index), index, messageDelegate);
                this.putMessageIntoCache(index, (Message)message);
            }
            catch (IOException ioe) {
                throw new MessagingException("Error ocurred reading message [" + index + "]", (Exception)ioe);
            }
            catch (DelegateException de) {
                throw new MessagingException("Error ocurred reading message [" + index + "]", (Exception)de);
            }
        }
        return message;
    }

    public void appendMessages(Message[] messages) throws MessagingException {
        this.assertExists();
        this.delegate.appendMessages(messages);
        this.notifyMessageAddedListeners(messages);
    }

    public Message[] expunge() throws MessagingException {
        this.assertExists();
        this.assertOpen();
        if (1 == this.getMode()) {
            throw new MessagingException("Folder is read-only");
        }
        int count = this.getDeletedMessageCount();
        ArrayList<Message> deletedList = new ArrayList<Message>();
        for (int i = 1; i <= this.getMessageCount() && deletedList.size() < count; ++i) {
            Message message = this.getMessage(i);
            if (!message.isSet(Flags.Flag.DELETED)) continue;
            deletedList.add(message);
        }
        MStorMessage[] deleted = deletedList.toArray(new MStorMessage[deletedList.size()]);
        this.delegate.expunge((Message[])deleted);
        for (int i = 0; i < deleted.length; ++i) {
            deleted[i].setExpunged(true);
        }
        this.notifyMessageRemovedListeners(true, (Message[])deleted);
        this.clearMessageCache();
        return deleted;
    }

    private void assertOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Folder not open");
        }
    }

    private void assertClosed() {
        if (this.isOpen()) {
            throw new IllegalStateException("Folder not closed");
        }
    }

    private void assertExists() throws MessagingException {
        if (!this.exists()) {
            throw new FolderNotFoundException((Folder)this, "Folder [" + this.getName() + "] does not exist.");
        }
    }

    public Message getMessageByUID(long uid) throws MessagingException {
        for (int i = 1; i <= this.getMessageCount(); ++i) {
            MStorMessage message = (MStorMessage)this.getMessage(i);
            if (message.getUid() != uid) continue;
            return message;
        }
        throw new MessagingException("Message with UID [" + uid + "] does not exist");
    }

    public Message[] getMessagesByUID(long start, long end) throws MessagingException {
        long lastUid = end;
        if (end == -1L) {
            try {
                lastUid = this.delegate.getLastUid();
            }
            catch (UnsupportedOperationException uoe) {
                throw new MessagingException("Error retrieving UID", (Exception)uoe);
            }
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        for (long uid = start; uid <= lastUid; ++uid) {
            messages.add(this.getMessageByUID(uid));
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public Message[] getMessagesByUID(long[] uids) throws MessagingException {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = 0; i < uids.length; ++i) {
            messages.add(this.getMessageByUID(uids[i]));
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public long getUID(Message message) throws MessagingException {
        if (!(message instanceof MStorMessage)) {
            throw new MessagingException("Incompatible message type");
        }
        return ((MStorMessage)message).getUid();
    }

    public long getUIDValidity() throws MessagingException {
        try {
            return this.delegate.getUidValidity();
        }
        catch (UnsupportedOperationException uoe) {
            throw new MessagingException("An error occurred retrieving UID validity", (Exception)uoe);
        }
    }

    private void clearMessageCache() {
        this.getCacheAdapter().clearCache();
    }

    private Message retrieveMessageFromCache(int index) {
        return (Message)this.getCacheAdapter().retrieveObjectFromCache(index);
    }

    private void putMessageIntoCache(int index, Message message) {
        this.getCacheAdapter().putObjectIntoCache(index, message);
    }

    private CacheAdapter getCacheAdapter() {
        if (this.cacheAdapter == null) {
            this.cacheAdapter = Configurator.getProperty("mstor.cache.disabled", "false").equals("true") ? new CacheAdapter() : new EhCacheAdapter("mstor.folder." + this.getFullName().hashCode());
        }
        return this.cacheAdapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeleteFolderCommand
    implements Callable<Boolean> {
        private final Folder folder;
        private final boolean recurse;

        public DeleteFolderCommand(Folder folder, boolean recurse) {
            this.folder = folder;
            this.recurse = recurse;
        }

        @Override
        public Boolean call() throws Exception {
            return this.folder.delete(this.recurse);
        }
    }
}

