/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.locale;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;

public class JimuLocaleResolver
implements LocaleResolver {
    private static final String LANG_PARAM = "jmLang";
    private static final String LANG_COOKIE_NAME = "user-lang";

    public Locale resolveLocale(HttpServletRequest request) {
        String string = request.getParameter(LANG_PARAM);
        if (!StringUtils.hasText((String)string)) {
            string = this.getCookieValue(request, LANG_COOKIE_NAME);
        }
        if (!StringUtils.hasText((String)string)) {
            string = request.getHeader("Accept-Language");
        }
        return StringUtils.hasText((String)string) ? Locale.forLanguageTag(string) : Locale.getDefault();
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        this.setCookieValue(response, LANG_COOKIE_NAME, locale.toLanguageTag());
    }

    private String getCookieValue(HttpServletRequest request, String name) {
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private void setCookieValue(HttpServletResponse response, String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(604800);
        cookie.setPath("/");
        response.addCookie(cookie);
    }
}

