/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.NoResolvedResultException;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.VersionResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenVersionRangeResult;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.TransitiveExclusionPolicy;
import org.jboss.shrinkwrap.resolver.impl.maven.ConfigurableMavenWorkingSessionImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenResolvedArtifactImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenVersionRangeResultImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.PostResolutionFilterApplicator;
import org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.MavenModelResolver;
import org.jboss.shrinkwrap.resolver.impl.maven.internal.SettingsXmlProfileSelector;
import org.jboss.shrinkwrap.resolver.impl.maven.logging.LogModelProblemCollector;
import org.jboss.shrinkwrap.resolver.impl.maven.pom.ParsedPomFileImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenWorkingSessionImpl
extends ConfigurableMavenWorkingSessionImpl {
    private static final Logger log = Logger.getLogger(MavenWorkingSessionImpl.class.getName());
    private final Set<MavenDependency> dependencyManagement;
    private final List<MavenDependency> dependencies;
    private final Set<MavenDependency> declaredDependencies;
    private static final String MAVEN_CENTRAL_NAME = "central";
    private static final RemoteRepository MAVEN_CENTRAL = new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2").build();
    private Model model;
    private final List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private final List<RemoteRepository> additionalRemoteRepositories = new ArrayList<RemoteRepository>();
    private boolean useMavenCentralRepository = true;

    public MavenWorkingSessionImpl() {
        this.dependencies = new ArrayList<MavenDependency>();
        this.dependencyManagement = new LinkedHashSet<MavenDependency>();
        this.declaredDependencies = new LinkedHashSet<MavenDependency>();
    }

    public Set<MavenDependency> getDependencyManagement() {
        return this.dependencyManagement;
    }

    public List<MavenDependency> getDependenciesForResolution() {
        return this.dependencies;
    }

    public Set<MavenDependency> getDeclaredDependencies() {
        return this.declaredDependencies;
    }

    public MavenWorkingSession loadPomFromFile(File pomFile, String ... profiles) throws InvalidConfigurationFileException {
        Model model;
        ModelBuildingResult result;
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest().setSystemProperties(SecurityActions.getProperties()).setProfiles(this.getSettingsDefinedProfiles()).setPomFile(pomFile).setActiveProfileIds(SettingsXmlProfileSelector.explicitlyActivatedProfiles(profiles)).setInactiveProfileIds(SettingsXmlProfileSelector.explicitlyDisabledProfiles(profiles));
        DefaultModelBuilder builder = new DefaultModelBuilderFactory().newInstance();
        try {
            request.setModelResolver((ModelResolver)new MavenModelResolver(this.getSystem(), (RepositorySystemSession)this.getSession(), this.getRemoteRepositories()));
            result = builder.build((ModelBuildingRequest)request);
        }
        catch (ModelBuildingException e) {
            String pomPath = request.getPomFile().getAbsolutePath();
            StringBuilder sb = new StringBuilder("Found ").append(e.getProblems().size()).append(" problems while building POM model from ").append(pomPath).append("\n");
            int counter = 1;
            for (ModelProblem problem : e.getProblems()) {
                sb.append(counter++).append("/ ").append(problem).append("\n");
            }
            throw new InvalidConfigurationFileException(sb.toString());
        }
        this.model = model = result.getEffectiveModel();
        for (Repository repository : model.getRepositories()) {
            this.remoteRepositories.add(MavenConverter.asRemoteRepository(repository));
        }
        return this;
    }

    public Collection<MavenResolvedArtifact> resolveDependencies(MavenResolutionStrategy strategy) throws ResolutionException {
        List<MavenDependency> depsForResolution = Collections.unmodifiableList(new ArrayList<MavenDependency>(this.getDependenciesForResolution()));
        ArrayList<MavenDependency> depManagement = new ArrayList<MavenDependency>(this.getDependencyManagement());
        List<RemoteRepository> repos = this.getRemoteRepositories();
        CollectRequest request = new CollectRequest(MavenConverter.asDependencies(depsForResolution, this.getSession().getArtifactTypeRegistry()), MavenConverter.asDependencies(depManagement, this.getSession().getArtifactTypeRegistry()), repos);
        Collection<Object> results = Collections.emptyList();
        LinkedHashSet<Object> dependencySelectors = new LinkedHashSet<Object>(3);
        TransitiveExclusionPolicy transitiveExclusionPolicy = strategy.getTransitiveExclusionPolicy();
        ScopeType[] filteredScopes = transitiveExclusionPolicy.getFilteredScopes();
        int numFilteredScopes = filteredScopes.length;
        String[] filteredScopeStrings = new String[numFilteredScopes];
        for (int i = 0; i < numFilteredScopes; ++i) {
            filteredScopeStrings[i] = filteredScopes[i].toString();
        }
        if (numFilteredScopes > 0) {
            dependencySelectors.add(new ScopeDependencySelector(filteredScopeStrings));
        }
        if (!transitiveExclusionPolicy.allowOptional()) {
            dependencySelectors.add(new OptionalDependencySelector());
        }
        dependencySelectors.add(new ExclusionDependencySelector());
        AndDependencySelector dependencySelector = new AndDependencySelector(dependencySelectors);
        this.getSession().setDependencySelector((DependencySelector)dependencySelector);
        try {
            results = this.getSystem().resolveDependencies((RepositorySystemSession)this.getSession(), this, request, strategy.getResolutionFilters());
        }
        catch (DependencyResolutionException e) {
            throw MavenWorkingSessionImpl.wrapException(e);
        }
        ArrayList<MavenResolvedArtifact> resolvedArtifacts = new ArrayList<MavenResolvedArtifact>(results.size());
        for (ArtifactResult artifactResult : results) {
            resolvedArtifacts.add(MavenResolvedArtifactImpl.fromArtifactResult(artifactResult));
        }
        this.getDependenciesForResolution().clear();
        return PostResolutionFilterApplicator.postFilter(resolvedArtifacts);
    }

    public MavenVersionRangeResult resolveVersionRange(MavenCoordinate coordinate) throws VersionResolutionException {
        Artifact artifact = MavenConverter.asArtifact(coordinate, this.getSession().getArtifactTypeRegistry());
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.getRemoteRepositories(), null);
        try {
            VersionRangeResult versionRangeResult = this.getSystem().resolveVersionRange((RepositorySystemSession)this.getSession(), versionRangeRequest);
            if (!versionRangeResult.getVersions().isEmpty()) {
                return new MavenVersionRangeResultImpl(artifact, versionRangeResult);
            }
            List exceptions = versionRangeResult.getExceptions();
            if (exceptions.isEmpty()) {
                return new MavenVersionRangeResultImpl(artifact, versionRangeResult);
            }
            StringBuilder builder = new StringBuilder("Version range request failed with ").append(exceptions.size()).append(" exceptions.").append("\n");
            int counter = 1;
            for (Exception exception : exceptions) {
                log.log(Level.SEVERE, "Version range request failed", exception);
                builder.append(counter++).append("/ ").append(exception.getLocalizedMessage()).append("\n");
            }
            throw new VersionResolutionException(builder.toString());
        }
        catch (VersionRangeResolutionException vrre) {
            throw new VersionResolutionException("Version range request failed", (Throwable)vrre);
        }
    }

    public ParsedPomFile getParsedPomFile() {
        return new ParsedPomFileImpl(this.model, this.getSession().getArtifactTypeRegistry());
    }

    public void disableMavenCentral() {
        log.log(Level.FINEST, "Disabling Maven Central");
        this.useMavenCentralRepository = false;
    }

    public void addRemoteRepo(MavenRemoteRepository repository) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository.getId(), repository.getType(), repository.getUrl());
        builder.setPolicy(new RepositoryPolicy(true, repository.getUpdatePolicy() == null ? null : repository.getUpdatePolicy().apiValue(), repository.getChecksumPolicy() == null ? null : repository.getChecksumPolicy().apiValue()));
        for (RemoteRepository r : this.additionalRemoteRepositories) {
            if (!r.getId().equals(repository.getId())) continue;
            this.additionalRemoteRepositories.remove(r);
        }
        this.additionalRemoteRepositories.add(builder.build());
    }

    private List<RemoteRepository> getRemoteRepositories() throws IllegalStateException {
        if (this.isOffline()) {
            log.log(Level.FINE, "No remote repositories will be available, working in offline mode");
            return Collections.emptyList();
        }
        LinkedHashSet<RemoteRepository> enhancedRepos = new LinkedHashSet<RemoteRepository>();
        enhancedRepos.addAll(this.additionalRemoteRepositories);
        SettingsXmlProfileSelector selector = new SettingsXmlProfileSelector();
        LogModelProblemCollector problems = new LogModelProblemCollector();
        List activeProfiles = selector.getActiveProfiles(MavenConverter.asProfiles(this.getSettings().getProfiles()), new ProfileActivationContext(){

            public Map<String, String> getUserProperties() {
                return Collections.emptyMap();
            }

            public Map<String, String> getSystemProperties() {
                return new HashMap<Object, Object>(SecurityActions.getProperties());
            }

            public File getProjectDirectory() {
                return new File(SecurityActions.getProperty("user.dir"));
            }

            public Map<String, String> getProjectProperties() {
                return Collections.emptyMap();
            }

            public List<String> getInactiveProfileIds() {
                return Collections.emptyList();
            }

            public List<String> getActiveProfileIds() {
                return MavenWorkingSessionImpl.this.getSettings().getActiveProfiles();
            }
        }, problems);
        if (problems.hasSevereFailures()) {
            throw new IllegalStateException("Unable to get active profiles from Maven settings.");
        }
        for (Profile profile : activeProfiles) {
            for (Repository repository : profile.getRepositories()) {
                RemoteRepository remoteRepository = MavenConverter.asRemoteRepository(repository);
                if (MavenWorkingSessionImpl.isIdIncluded(this.additionalRemoteRepositories, remoteRepository)) continue;
                enhancedRepos.add(remoteRepository);
            }
        }
        for (RemoteRepository remoteRepository : this.remoteRepositories) {
            if (MavenWorkingSessionImpl.isIdIncluded(this.additionalRemoteRepositories, remoteRepository)) continue;
            enhancedRepos.add(remoteRepository);
        }
        if (this.useMavenCentralRepository) {
            if (!MavenWorkingSessionImpl.isIdIncluded(this.additionalRemoteRepositories, MAVEN_CENTRAL)) {
                enhancedRepos.add(MAVEN_CENTRAL);
            }
        } else {
            ArrayList<RemoteRepository> reposToRemove = new ArrayList<RemoteRepository>();
            for (RemoteRepository remoteRepository : enhancedRepos) {
                String string = remoteRepository.getUrl();
                if (!string.contains("maven.org") && !string.contains("apache.org") || !remoteRepository.getId().equalsIgnoreCase(MAVEN_CENTRAL_NAME) || MavenWorkingSessionImpl.isIdIncluded(this.additionalRemoteRepositories, MAVEN_CENTRAL)) continue;
                reposToRemove.add(remoteRepository);
            }
            enhancedRepos.removeAll(reposToRemove);
        }
        DefaultMirrorSelector dms = new DefaultMirrorSelector();
        for (Mirror mirror : this.getSettings().getMirrors()) {
            dms.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        LinkedHashSet<RemoteRepository> linkedHashSet = new LinkedHashSet<RemoteRepository>();
        for (RemoteRepository remoteRepository : enhancedRepos) {
            RemoteRepository remoteRepository2 = dms.getMirror(remoteRepository);
            if (remoteRepository2 != null) {
                linkedHashSet.add(remoteRepository2);
                continue;
            }
            linkedHashSet.add(remoteRepository);
        }
        LinkedHashSet<RemoteRepository> linkedHashSet2 = new LinkedHashSet<RemoteRepository>();
        for (RemoteRepository remoteRepository : linkedHashSet) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(remoteRepository);
            Server server = this.getSettings().getServer(remoteRepository.getId());
            if (server != null) {
                AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).addPrivateKey(server.getPrivateKey(), server.getPassphrase());
                builder.setAuthentication(authenticationBuilder.build());
            }
            linkedHashSet2.add(builder.build());
        }
        if (log.isLoggable(Level.FINER)) {
            for (RemoteRepository remoteRepository : linkedHashSet2) {
                log.finer("Repository " + remoteRepository.getUrl() + " have been made available for artifact resolution");
            }
        }
        return new ArrayList<RemoteRepository>(linkedHashSet2);
    }

    private static boolean isIdIncluded(Collection<RemoteRepository> repositories, RemoteRepository candidate) {
        for (RemoteRepository r : repositories) {
            if (!r.getId().equals(candidate.getId())) continue;
            return true;
        }
        return false;
    }

    private List<Profile> getSettingsDefinedProfiles() {
        return MavenConverter.asProfiles(this.getSettings().getProfiles());
    }

    private static ResolutionException wrapException(DependencyResolutionException e) {
        Throwable cause = e;
        Throwable nextCause = null;
        while ((nextCause = cause.getCause()) != null) {
            cause = nextCause;
        }
        if (cause instanceof ArtifactResolutionException) {
            throw new NoResolvedResultException("Unable to get artifact from the repository due to: " + e.getMessage() + ", caused by: " + cause.getMessage());
        }
        if (cause instanceof DependencyCollectionException) {
            throw new NoResolvedResultException("Unable to collect dependency tree for given dependencies due to: " + e.getMessage() + ", caused by: " + cause.getMessage(), (Throwable)e);
        }
        throw new NoResolvedResultException("Unable to collect/resolve dependency tree for a resolution due to: " + e.getMessage() + ", caused by: " + cause.getMessage(), (Throwable)e);
    }
}

