/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.TypeKindVisitor8;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.internal.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;

public class AnnotationTypeMemberCheck
extends AbstractConstraintCheck {
    private final AnnotationApiHelper annotationApiHelper;
    private final Types typeUtils;

    public AnnotationTypeMemberCheck(AnnotationApiHelper annotationApiHelper, Types typeUtils) {
        this.annotationApiHelper = annotationApiHelper;
        this.typeUtils = typeUtils;
    }

    @Override
    public Set<ConstraintCheckIssue> checkAnnotationType(TypeElement element, AnnotationMirror annotation) {
        HashSet<ConstraintCheckIssue> theValue = CollectionHelper.newHashSet();
        theValue.addAll(this.checkMessageAttribute(element));
        theValue.addAll(this.checkGroupsAttribute(element));
        theValue.addAll(this.checkPayloadAttribute(element));
        return theValue;
    }

    private Set<ConstraintCheckIssue> checkMessageAttribute(TypeElement element) {
        ExecutableElement messageMethod = this.getMethod(element, "message");
        if (messageMethod == null) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, null, "CONSTRAINT_TYPE_MUST_DECLARE_MESSAGE_MEMBER", new Object[0]));
        }
        if (!this.typeUtils.isSameType(this.annotationApiHelper.getMirrorForType(String.class), messageMethod.getReturnType())) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(messageMethod, null, "RETURN_TYPE_MUST_BE_STRING", new Object[0]));
        }
        return Collections.emptySet();
    }

    private Set<ConstraintCheckIssue> checkGroupsAttribute(TypeElement element) {
        ExecutableElement groupsMethod = this.getMethod(element, "groups");
        if (groupsMethod == null) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, null, "CONSTRAINT_TYPE_MUST_DECLARE_GROUPS_MEMBER", new Object[0]));
        }
        DeclaredType type = this.getComponentTypeOfArrayReturnType(groupsMethod);
        if (type == null) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(groupsMethod, null, "RETURN_TYPE_MUST_BE_CLASS_ARRAY", new Object[0]));
        }
        boolean typeHasNameClass = type.asElement().getSimpleName().contentEquals("Class");
        boolean typeHasExactlyOneTypeArgument = type.getTypeArguments().size() == 1;
        boolean typeArgumentIsUnboundWildcard = this.validateWildcardBounds(type.getTypeArguments().get(0), null, null);
        if (!(typeHasNameClass && typeHasExactlyOneTypeArgument && typeArgumentIsUnboundWildcard)) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(groupsMethod, null, "RETURN_TYPE_MUST_BE_CLASS_ARRAY", new Object[0]));
        }
        if (!this.isEmptyArray(groupsMethod.getDefaultValue())) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(groupsMethod, null, "DEFAULT_VALUE_MUST_BE_EMPTY_ARRAY", new Object[0]));
        }
        return Collections.emptySet();
    }

    private Set<ConstraintCheckIssue> checkPayloadAttribute(TypeElement element) {
        ExecutableElement payloadMethod = this.getMethod(element, "payload");
        if (payloadMethod == null) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, null, "CONSTRAINT_TYPE_MUST_DECLARE_PAYLOAD_MEMBER", new Object[0]));
        }
        DeclaredType type = this.getComponentTypeOfArrayReturnType(payloadMethod);
        if (type == null) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(payloadMethod, null, "PAYLOAD_RETURN_TYPE_MUST_BE_CLASS_ARRAY", new Object[0]));
        }
        boolean typeHasNameClass = type.asElement().getSimpleName().contentEquals("Class");
        boolean typeHasExactlyOneTypeArgument = type.getTypeArguments().size() == 1;
        boolean typeArgumentIsWildcardWithPayloadExtendsBound = this.validateWildcardBounds(type.getTypeArguments().get(0), this.annotationApiHelper.getDeclaredTypeByName("jakarta.validation.Payload"), null);
        if (!(typeHasNameClass && typeHasExactlyOneTypeArgument && typeArgumentIsWildcardWithPayloadExtendsBound)) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(payloadMethod, null, "PAYLOAD_RETURN_TYPE_MUST_BE_CLASS_ARRAY", new Object[0]));
        }
        if (!this.isEmptyArray(payloadMethod.getDefaultValue())) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(payloadMethod, null, "PAYLOAD_DEFAULT_VALUE_MUST_BE_EMPTY_ARRAY", new Object[0]));
        }
        return Collections.emptySet();
    }

    private ExecutableElement getMethod(TypeElement element, String name) {
        for (ExecutableElement oneMethod : ElementFilter.methodsIn(element.getEnclosedElements())) {
            if (!oneMethod.getSimpleName().contentEquals(name)) continue;
            return oneMethod;
        }
        return null;
    }

    private DeclaredType getComponentTypeOfArrayReturnType(ExecutableElement method) {
        return method.getReturnType().accept(new TypeKindVisitor8<DeclaredType, Void>(){

            @Override
            public DeclaredType visitArray(ArrayType t, Void p) {
                return t.getComponentType().accept(new TypeKindVisitor8<DeclaredType, Void>(){

                    @Override
                    public DeclaredType visitDeclared(DeclaredType t, Void p) {
                        return t;
                    }
                }, null);
            }
        }, null);
    }

    private boolean validateWildcardBounds(TypeMirror type, final TypeMirror expectedExtendsBound, final TypeMirror expectedSuperBound) {
        Boolean theValue = type.accept(new TypeKindVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitWildcard(WildcardType t, Void p) {
                boolean extendsBoundMatches;
                boolean bl = t.getExtendsBound() == null ? expectedExtendsBound == null : (extendsBoundMatches = expectedExtendsBound != null && AnnotationTypeMemberCheck.this.typeUtils.isSameType(t.getExtendsBound(), expectedExtendsBound));
                boolean superBoundMatches = t.getSuperBound() == null ? expectedSuperBound == null : expectedSuperBound != null && AnnotationTypeMemberCheck.this.typeUtils.isSameType(t.getSuperBound(), expectedSuperBound);
                return extendsBoundMatches && superBoundMatches;
            }
        }, null);
        return Boolean.TRUE.equals(theValue);
    }

    private boolean isEmptyArray(AnnotationValue annotationValue) {
        return annotationValue != null && Boolean.TRUE.equals(annotationValue.accept(new SimpleAnnotationValueVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitArray(List<? extends AnnotationValue> values, Void p) {
                return values.size() == 0;
            }
        }, null));
    }
}

