/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.hibernate.validator.ap.internal.AbstractElementVisitor;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.classchecks.ClassCheck;
import org.hibernate.validator.ap.internal.classchecks.ClassCheckFactory;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;
import org.hibernate.validator.ap.internal.util.CollectionHelper;
import org.hibernate.validator.ap.internal.util.Configuration;
import org.hibernate.validator.ap.internal.util.ConstraintHelper;
import org.hibernate.validator.ap.internal.util.MessagerAdapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ClassVisitor
extends AbstractElementVisitor<Void, Void> {
    private final Set<Name> processedTypes;
    private final ClassCheckFactory factory;
    private final Elements elementUtils;

    public ClassVisitor(ProcessingEnvironment processingEnvironment, MessagerAdapter messager, Configuration configuration) {
        super(messager, configuration);
        this.elementUtils = processingEnvironment.getElementUtils();
        this.factory = ClassCheckFactory.getInstance(processingEnvironment.getTypeUtils(), processingEnvironment.getElementUtils(), new ConstraintHelper(processingEnvironment.getTypeUtils(), new AnnotationApiHelper(processingEnvironment.getElementUtils(), processingEnvironment.getTypeUtils())));
        this.processedTypes = CollectionHelper.newHashSet();
    }

    @Override
    public Void visitTypeAsClass(TypeElement element, Void aVoid) {
        this.visitAllMyElements(element);
        return null;
    }

    @Override
    public Void visitTypeAsInterface(TypeElement element, Void aVoid) {
        this.visitAllMyElements(element);
        return null;
    }

    @Override
    public Void visitTypeAsRecord(TypeElement element, Void aVoid) {
        this.visitAllMyElements(element);
        return null;
    }

    @Override
    public Void visitExecutableAsMethod(ExecutableElement element, Void aVoid) {
        this.processClassChecks(element);
        return null;
    }

    private void visitAllMyElements(TypeElement typeElement) {
        Name qualifiedName = typeElement.getQualifiedName();
        if (!this.processedTypes.contains(qualifiedName)) {
            this.processedTypes.add(qualifiedName);
            for (Element element : this.elementUtils.getAllMembers(typeElement)) {
                this.visit(element);
            }
        }
    }

    private void processClassChecks(Element element) {
        block3: {
            try {
                HashSet<ConstraintCheckIssue> allIssues = CollectionHelper.newHashSet();
                Collection<ClassCheck> classChecks = this.factory.getClassChecks(element);
                for (ClassCheck classCheck : classChecks) {
                    allIssues.addAll(classCheck.execute(element));
                }
                this.reportIssues(allIssues);
            }
            catch (Exception e) {
                if (!this.verbose) break block3;
                this.messager.getDelegate().printMessage(Diagnostic.Kind.NOTE, e.getMessage() != null ? e.getMessage() : e.toString(), element);
            }
        }
    }
}

