/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal;

import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.util.ElementKindVisitor14;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.util.CollectionHelper;
import org.hibernate.validator.ap.internal.util.Configuration;
import org.hibernate.validator.ap.internal.util.MessagerAdapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AbstractElementVisitor<T, V>
extends ElementKindVisitor14<T, V> {
    protected final MessagerAdapter messager;
    protected final boolean verbose;

    public AbstractElementVisitor(MessagerAdapter messager, Configuration configuration) {
        this.messager = messager;
        this.verbose = configuration.isVerbose();
    }

    protected void reportIssues(Collection<ConstraintCheckIssue> foundIssues) {
        HashSet<ConstraintCheckIssue> warnings = CollectionHelper.newHashSet();
        HashSet<ConstraintCheckIssue> errors = CollectionHelper.newHashSet();
        for (ConstraintCheckIssue issue : foundIssues) {
            if (issue.isError()) {
                errors.add(issue);
                continue;
            }
            if (!issue.isWarning()) continue;
            warnings.add(issue);
        }
        this.messager.reportErrors(errors);
        this.messager.reportWarnings(warnings);
    }
}

