/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.util.Iterator;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.ApplicationSettings;
import org.gitlab4j.api.models.Setting;
import org.gitlab4j.api.utils.ISO8601;

public class ApplicationSettingsApi
extends AbstractApi {
    public ApplicationSettingsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public ApplicationSettings getApplicationSettings() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "application", "settings");
        JsonNode root = (JsonNode)response.readEntity(JsonNode.class);
        return ApplicationSettingsApi.parseApplicationSettings(root);
    }

    public ApplicationSettings updateApplicationSettings(ApplicationSettings appSettings) throws GitLabApiException {
        if (appSettings == null || appSettings.getSettings().isEmpty()) {
            throw new GitLabApiException("ApplicationSettings cannot be null or empty.");
        }
        GitLabApiForm form = new GitLabApiForm();
        appSettings.getSettings().forEach((s, v) -> form.withParam((String)s, v));
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"application", "settings"});
        JsonNode root = (JsonNode)response.readEntity(JsonNode.class);
        return ApplicationSettingsApi.parseApplicationSettings(root);
    }

    public ApplicationSettings updateApplicationSetting(Setting setting, Object value) throws GitLabApiException {
        if (setting == null) {
            throw new GitLabApiException("setting cannot be null.");
        }
        return this.updateApplicationSetting(setting.toString(), value);
    }

    public ApplicationSettings updateApplicationSetting(String setting, Object value) throws GitLabApiException {
        if (setting == null || setting.trim().isEmpty()) {
            throw new GitLabApiException("setting cannot be null or empty.");
        }
        GitLabApiForm form = new GitLabApiForm().withParam(setting, value);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), new Object[]{"application", "settings"});
        JsonNode root = (JsonNode)response.readEntity(JsonNode.class);
        return ApplicationSettingsApi.parseApplicationSettings(root);
    }

    public static final ApplicationSettings parseApplicationSettings(JsonNode root) throws GitLabApiException {
        ApplicationSettings appSettings = new ApplicationSettings();
        Iterator fieldNames = root.fieldNames();
        block14: while (fieldNames.hasNext()) {
            String fieldName;
            switch (fieldName = (String)fieldNames.next()) {
                case "id": {
                    appSettings.setId(root.path(fieldName).asInt());
                    continue block14;
                }
                case "created_at": {
                    String value;
                    try {
                        value = root.path(fieldName).asText();
                        appSettings.setCreatedAt(ISO8601.toDate(value));
                        continue block14;
                    }
                    catch (ParseException pe) {
                        throw new GitLabApiException(pe);
                    }
                }
                case "updated_at": {
                    String value;
                    try {
                        value = root.path(fieldName).asText();
                        appSettings.setUpdatedAt(ISO8601.toDate(value));
                        continue block14;
                    }
                    catch (ParseException pe) {
                        throw new GitLabApiException(pe);
                    }
                }
            }
            Setting setting = Setting.forValue(fieldName);
            if (setting != null) {
                appSettings.addSetting(setting, (Object)root.path(fieldName));
                continue;
            }
            GitLabApi.getLogger().warning(String.format("Unknown setting: %s, type: %s", fieldName, root.path(fieldName).getClass().getSimpleName()));
            appSettings.addSetting(fieldName, (Object)root.path(fieldName));
        }
        return appSettings;
    }
}

