/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.firebirdsql.encodings.Encoding;

public final class XdrInputStream {
    private InputStream in = null;
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private final byte[] readBuffer = new byte[8];

    public XdrInputStream(InputStream in) {
        this.in = new BufferedInputStream(in, 16384);
    }

    public int skipPadding(int length) throws IOException {
        return this.skipFully(4 - length & 3);
    }

    public int skipFully(int n) throws IOException {
        int total;
        int cur;
        for (total = 0; total < n && (cur = (int)this.in.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    public byte[] readBuffer() throws IOException {
        int len = this.readInt();
        byte[] buffer = new byte[len];
        this.readFully(buffer, 0, len);
        this.skipPadding(len);
        return buffer;
    }

    public byte[] readRawBuffer(int len) throws IOException {
        byte[] buffer = new byte[len];
        this.readFully(buffer, 0, len);
        return buffer;
    }

    public String readString(Encoding encoding) throws IOException {
        byte[] buffer = this.readBuffer();
        return encoding.decodeFromCharset(buffer);
    }

    public long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)(this.readBuffer[7] & 0xFF);
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public int readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void setCipher(Cipher cipher) throws IOException {
        if (this.in instanceof CipherInputStream) {
            throw new IOException("Input stream already encrypted");
        }
        this.in = new CipherInputStream(this.in, cipher);
    }
}

