/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.plexus.util.StringUtils;
import org.eluder.coveralls.maven.plugin.ProcessingException;

public class TimestampParser {
    public static final String EPOCH_MILLIS = "EpochMillis";
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private final Parser parser;

    public TimestampParser(String format) {
        try {
            this.parser = EPOCH_MILLIS.equalsIgnoreCase(format) ? new EpochMillisParser() : (StringUtils.isNotBlank((String)format) ? new DateFormatParser(format) : new DateFormatParser(DEFAULT_FORMAT));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid timestamp format \"" + format + "\"", ex);
        }
    }

    public Date parse(String timestamp) throws ProcessingException {
        if (StringUtils.isBlank((String)timestamp)) {
            return null;
        }
        try {
            return this.parser.parse(timestamp);
        }
        catch (Exception ex) {
            throw new ProcessingException("Unable to parse timestamp \"" + timestamp + "\"", ex);
        }
    }

    private static class EpochMillisParser
    implements Parser {
        private EpochMillisParser() {
        }

        @Override
        public Date parse(String timestamp) {
            return new Date(Long.valueOf(timestamp));
        }
    }

    private static class DateFormatParser
    implements Parser {
        final DateFormat format;

        DateFormatParser(String format) {
            this.format = new SimpleDateFormat(format);
        }

        @Override
        public synchronized Date parse(String timestamp) throws ParseException {
            return this.format.parse(timestamp);
        }
    }

    private static interface Parser {
        public Date parse(String var1) throws Exception;
    }
}

