/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class BulkRequestBuilder
extends ActionRequestBuilder<BulkRequest, BulkResponse>
implements WriteRequestBuilder<BulkRequestBuilder> {
    @Deprecated
    public BulkRequestBuilder(ElasticsearchClient client, BulkAction action, @Nullable String globalIndex, @Nullable String globalType) {
        super(client, action, new BulkRequest(globalIndex, globalType));
    }

    public BulkRequestBuilder(ElasticsearchClient client, BulkAction action, @Nullable String globalIndex) {
        super(client, action, new BulkRequest(globalIndex));
    }

    public BulkRequestBuilder(ElasticsearchClient client, BulkAction action) {
        super(client, action, new BulkRequest());
    }

    public BulkRequestBuilder add(IndexRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(IndexRequestBuilder request) {
        ((BulkRequest)this.request).add((IndexRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(DeleteRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(DeleteRequestBuilder request) {
        ((BulkRequest)this.request).add((DeleteRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(UpdateRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(UpdateRequestBuilder request) {
        ((BulkRequest)this.request).add((UpdateRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(byte[] data, int from, int length, XContentType xContentType) throws Exception {
        ((BulkRequest)this.request).add(data, from, length, null, xContentType);
        return this;
    }

    @Deprecated
    public BulkRequestBuilder add(byte[] data, int from, int length, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws Exception {
        ((BulkRequest)this.request).add(data, from, length, defaultIndex, defaultType, xContentType);
        return this;
    }

    public BulkRequestBuilder add(byte[] data, int from, int length, @Nullable String defaultIndex, XContentType xContentType) throws Exception {
        ((BulkRequest)this.request).add(data, from, length, defaultIndex, "_doc", xContentType);
        return this;
    }

    public BulkRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((BulkRequest)this.request).waitForActiveShards(waitForActiveShards);
        return this;
    }

    public BulkRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public final BulkRequestBuilder setTimeout(TimeValue timeout) {
        ((BulkRequest)this.request).timeout(timeout);
        return this;
    }

    public final BulkRequestBuilder setTimeout(String timeout) {
        ((BulkRequest)this.request).timeout(timeout);
        return this;
    }

    public int numberOfActions() {
        return ((BulkRequest)this.request).numberOfActions();
    }

    public BulkRequestBuilder pipeline(String globalPipeline) {
        ((BulkRequest)this.request).pipeline(globalPipeline);
        return this;
    }

    public BulkRequestBuilder routing(String globalRouting) {
        ((BulkRequest)this.request).routing(globalRouting);
        return this;
    }
}

