/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.snapshots.SnapshotInfo;

public class GetSnapshotsResponse
extends ActionResponse
implements ToXContentObject {
    private static final ConstructingObjectParser<GetSnapshotsResponse, Void> GET_SNAPSHOT_PARSER = new ConstructingObjectParser(GetSnapshotsResponse.class.getName(), true, args -> new GetSnapshotsResponse((List)args[0], (Map)args[1], (String)args[2]));
    private final List<SnapshotInfo> snapshots;
    private final Map<String, ElasticsearchException> failures;
    @Nullable
    private final String next;

    public GetSnapshotsResponse(List<SnapshotInfo> snapshots, Map<String, ElasticsearchException> failures, @Nullable String next) {
        this.snapshots = org.elasticsearch.core.List.copyOf(snapshots);
        this.failures = failures == null ? org.elasticsearch.core.Map.of() : org.elasticsearch.core.Map.copyOf(failures);
        this.next = next;
    }

    public GetSnapshotsResponse(StreamInput in) throws IOException {
        this.snapshots = in.readList(SnapshotInfo::readFrom);
        if (in.getVersion().onOrAfter(GetSnapshotsRequest.MULTIPLE_REPOSITORIES_SUPPORT_ADDED)) {
            Map<String, ElasticsearchException> failedResponses = in.readMap(StreamInput::readString, StreamInput::readException);
            this.failures = Collections.unmodifiableMap(failedResponses);
            this.next = in.readOptionalString();
        } else {
            this.failures = Collections.emptyMap();
            this.next = null;
        }
    }

    public List<SnapshotInfo> getSnapshots() {
        return this.snapshots;
    }

    public Map<String, ElasticsearchException> getFailures() {
        return this.failures;
    }

    @Nullable
    public String next() {
        return this.next;
    }

    public boolean isFailed() {
        return !this.failures.isEmpty();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.snapshots);
        if (out.getVersion().onOrAfter(GetSnapshotsRequest.MULTIPLE_REPOSITORIES_SUPPORT_ADDED)) {
            out.writeMap(this.failures, StreamOutput::writeString, StreamOutput::writeException);
            out.writeOptionalString(this.next);
        } else if (!this.failures.isEmpty()) {
            assert (false) : "transport action should have thrown directly for old version but saw " + this.failures;
            throw this.failures.values().iterator().next();
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("snapshots");
        for (SnapshotInfo snapshotInfo : this.snapshots) {
            snapshotInfo.toXContent(builder, params);
        }
        builder.endArray();
        if (!this.failures.isEmpty()) {
            builder.startObject("failures");
            for (Map.Entry entry : this.failures.entrySet()) {
                builder.field((String)entry.getKey(), (b, pa) -> {
                    b.startObject();
                    ((ElasticsearchException)error.getValue()).toXContent(b, pa);
                    b.endObject();
                    return b;
                });
            }
            builder.endObject();
        }
        if (this.next != null) {
            builder.field("next", this.next);
        }
        builder.endObject();
        return builder;
    }

    public static GetSnapshotsResponse fromXContent(XContentParser parser) throws IOException {
        return (GetSnapshotsResponse)GET_SNAPSHOT_PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSnapshotsResponse that = (GetSnapshotsResponse)o;
        return Objects.equals(this.snapshots, that.snapshots) && Objects.equals(this.failures, that.failures) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        return Objects.hash(this.snapshots, this.failures, this.next);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        GET_SNAPSHOT_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> ((SnapshotInfo.SnapshotInfoBuilder)SnapshotInfo.SNAPSHOT_INFO_PARSER.apply(p, c)).build(), new ParseField("snapshots", new String[0]));
        GET_SNAPSHOT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(HashMap::new, ElasticsearchException::fromXContent), new ParseField("failures", new String[0]));
        GET_SNAPSHOT_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("next", new String[0]));
    }
}

