/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio.channel;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.elasticsearch.mocksocket.PrivilegedSocketAccess;
import org.elasticsearch.transport.nio.AcceptingSelector;
import org.elasticsearch.transport.nio.SocketSelector;
import org.elasticsearch.transport.nio.channel.AbstractNioChannel;
import org.elasticsearch.transport.nio.channel.NioServerSocketChannel;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;

public abstract class ChannelFactory<ServerSocket extends NioServerSocketChannel, Socket extends NioSocketChannel> {
    private final RawChannelFactory rawChannelFactory;

    ChannelFactory(RawChannelFactory rawChannelFactory) {
        this.rawChannelFactory = rawChannelFactory;
    }

    public Socket openNioChannel(InetSocketAddress remoteAddress, SocketSelector selector) throws IOException {
        SocketChannel rawChannel = this.rawChannelFactory.openNioChannel(remoteAddress);
        Socket channel = this.internalCreateChannel(selector, rawChannel);
        this.scheduleChannel(channel, selector);
        return channel;
    }

    public Socket acceptNioChannel(NioServerSocketChannel serverChannel, SocketSelector selector) throws IOException {
        SocketChannel rawChannel = this.rawChannelFactory.acceptNioChannel(serverChannel);
        Socket channel = this.internalCreateChannel(selector, rawChannel);
        this.scheduleChannel(channel, selector);
        return channel;
    }

    public ServerSocket openNioServerSocketChannel(InetSocketAddress address, AcceptingSelector selector) throws IOException {
        ServerSocketChannel rawChannel = this.rawChannelFactory.openNioServerSocketChannel(address);
        ServerSocket serverChannel = this.internalCreateServerChannel(selector, rawChannel);
        this.scheduleServerChannel(serverChannel, selector);
        return serverChannel;
    }

    public abstract Socket createChannel(SocketSelector var1, SocketChannel var2) throws IOException;

    public abstract ServerSocket createServerChannel(AcceptingSelector var1, ServerSocketChannel var2) throws IOException;

    private Socket internalCreateChannel(SocketSelector selector, SocketChannel rawChannel) throws IOException {
        try {
            Socket channel = this.createChannel(selector, rawChannel);
            assert (((NioSocketChannel)channel).getReadContext() != null) : "read context should have been set on channel";
            assert (((NioSocketChannel)channel).getWriteContext() != null) : "write context should have been set on channel";
            assert (((NioSocketChannel)channel).getExceptionContext() != null) : "exception handler should have been set on channel";
            return channel;
        }
        catch (Exception e) {
            ChannelFactory.closeRawChannel(rawChannel, e);
            throw e;
        }
    }

    private ServerSocket internalCreateServerChannel(AcceptingSelector selector, ServerSocketChannel rawChannel) throws IOException {
        try {
            return this.createServerChannel(selector, rawChannel);
        }
        catch (Exception e) {
            ChannelFactory.closeRawChannel(rawChannel, e);
            throw e;
        }
    }

    private void scheduleChannel(Socket channel, SocketSelector selector) {
        try {
            selector.scheduleForRegistration((NioSocketChannel)channel);
        }
        catch (IllegalStateException e) {
            ChannelFactory.closeRawChannel(((AbstractNioChannel)channel).getRawChannel(), e);
            throw e;
        }
    }

    private void scheduleServerChannel(ServerSocket channel, AcceptingSelector selector) {
        try {
            selector.scheduleForRegistration((NioServerSocketChannel)channel);
        }
        catch (IllegalStateException e) {
            ChannelFactory.closeRawChannel(((AbstractNioChannel)channel).getRawChannel(), e);
            throw e;
        }
    }

    private static void closeRawChannel(Closeable c, Exception e) {
        try {
            c.close();
        }
        catch (IOException closeException) {
            e.addSuppressed(closeException);
        }
    }

    static class RawChannelFactory {
        private final boolean tcpNoDelay;
        private final boolean tcpKeepAlive;
        private final boolean tcpReusedAddress;
        private final int tcpSendBufferSize;
        private final int tcpReceiveBufferSize;

        RawChannelFactory(boolean tcpNoDelay, boolean tcpKeepAlive, boolean tcpReusedAddress, int tcpSendBufferSize, int tcpReceiveBufferSize) {
            this.tcpNoDelay = tcpNoDelay;
            this.tcpKeepAlive = tcpKeepAlive;
            this.tcpReusedAddress = tcpReusedAddress;
            this.tcpSendBufferSize = tcpSendBufferSize;
            this.tcpReceiveBufferSize = tcpReceiveBufferSize;
        }

        SocketChannel openNioChannel(InetSocketAddress remoteAddress) throws IOException {
            SocketChannel socketChannel = SocketChannel.open();
            try {
                this.configureSocketChannel(socketChannel);
                PrivilegedSocketAccess.connect((SocketChannel)socketChannel, (InetSocketAddress)remoteAddress);
            }
            catch (IOException e) {
                ChannelFactory.closeRawChannel(socketChannel, e);
                throw e;
            }
            return socketChannel;
        }

        SocketChannel acceptNioChannel(NioServerSocketChannel serverChannel) throws IOException {
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)serverChannel.getRawChannel();
            SocketChannel socketChannel = PrivilegedSocketAccess.accept((ServerSocketChannel)serverSocketChannel);
            try {
                this.configureSocketChannel(socketChannel);
            }
            catch (IOException e) {
                ChannelFactory.closeRawChannel(socketChannel, e);
                throw e;
            }
            return socketChannel;
        }

        ServerSocketChannel openNioServerSocketChannel(InetSocketAddress address) throws IOException {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            ServerSocket socket = serverSocketChannel.socket();
            try {
                socket.setReuseAddress(this.tcpReusedAddress);
                serverSocketChannel.bind(address);
            }
            catch (IOException e) {
                ChannelFactory.closeRawChannel(serverSocketChannel, e);
                throw e;
            }
            return serverSocketChannel;
        }

        private void configureSocketChannel(SocketChannel channel) throws IOException {
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            socket.setTcpNoDelay(this.tcpNoDelay);
            socket.setKeepAlive(this.tcpKeepAlive);
            socket.setReuseAddress(this.tcpReusedAddress);
            if (this.tcpSendBufferSize > 0) {
                socket.setSendBufferSize(this.tcpSendBufferSize);
            }
            if (this.tcpReceiveBufferSize > 0) {
                socket.setSendBufferSize(this.tcpReceiveBufferSize);
            }
        }
    }
}

