/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.nio.NioTransport;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;
import org.elasticsearch.transport.nio.channel.TcpNioSocketChannel;

public class TcpReadHandler {
    private final String profile;
    private final NioTransport transport;

    public TcpReadHandler(String profile, NioTransport transport) {
        this.profile = profile;
        this.transport = transport;
    }

    public void handleMessage(BytesReference reference, TcpNioSocketChannel channel, int messageBytesLength) {
        try {
            this.transport.messageReceived(reference, channel, this.profile, channel.getRemoteAddress(), messageBytesLength);
        }
        catch (IOException e) {
            this.handleException(channel, e);
        }
    }

    public void handleException(NioSocketChannel channel, Exception e) {
        this.transport.exceptionCaught(channel, e);
    }
}

