/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.transport.nio.EventHandler;
import org.elasticsearch.transport.nio.channel.NioChannel;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;
import org.elasticsearch.transport.nio.channel.SelectionKeyUtils;
import org.elasticsearch.transport.nio.channel.WriteContext;

public class SocketEventHandler
extends EventHandler {
    private final Logger logger;

    public SocketEventHandler(Logger logger) {
        super(logger);
        this.logger = logger;
    }

    void handleRegistration(NioSocketChannel channel) {
        SelectionKeyUtils.setConnectAndReadInterested(channel);
    }

    void registrationException(NioSocketChannel channel, Exception exception) {
        this.logger.debug(() -> new ParameterizedMessage("failed to register socket channel: {}", (Object)channel), (Throwable)exception);
        this.exceptionCaught(channel, exception);
    }

    void handleConnect(NioSocketChannel channel) {
        SelectionKeyUtils.removeConnectInterested(channel);
    }

    void connectException(NioSocketChannel channel, Exception exception) {
        this.logger.debug(() -> new ParameterizedMessage("failed to connect to socket channel: {}", (Object)channel), (Throwable)exception);
        this.exceptionCaught(channel, exception);
    }

    void handleRead(NioSocketChannel channel) throws IOException {
        int bytesRead = channel.getReadContext().read();
        if (bytesRead == -1) {
            this.handleClose(channel);
        }
    }

    void readException(NioSocketChannel channel, Exception exception) {
        this.logger.debug(() -> new ParameterizedMessage("exception while reading from socket channel: {}", (Object)channel), (Throwable)exception);
        this.exceptionCaught(channel, exception);
    }

    void handleWrite(NioSocketChannel channel) throws IOException {
        WriteContext channelContext = channel.getWriteContext();
        channelContext.flushChannel();
        if (channelContext.hasQueuedWriteOps()) {
            SelectionKeyUtils.setWriteInterested(channel);
        } else {
            SelectionKeyUtils.removeWriteInterested(channel);
        }
    }

    void writeException(NioSocketChannel channel, Exception exception) {
        this.logger.debug(() -> new ParameterizedMessage("exception while writing to socket channel: {}", (Object)channel), (Throwable)exception);
        this.exceptionCaught(channel, exception);
    }

    @Override
    void genericChannelException(NioChannel channel, Exception exception) {
        super.genericChannelException(channel, exception);
        this.exceptionCaught((NioSocketChannel)channel, exception);
    }

    <V> void listenerException(ActionListener<V> listener, Exception exception) {
        this.logger.warn((Message)new ParameterizedMessage("exception while executing listener: {}", listener), (Throwable)exception);
    }

    private void exceptionCaught(NioSocketChannel channel, Exception e) {
        channel.getExceptionContext().accept(channel, e);
    }
}

