/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.transport.nio.EventHandler;
import org.elasticsearch.transport.nio.channel.NioChannel;

public abstract class ESSelector
implements Closeable {
    final Selector selector;
    final ConcurrentLinkedQueue<NioChannel> channelsToClose = new ConcurrentLinkedQueue();
    private final EventHandler eventHandler;
    private final ReentrantLock runLock = new ReentrantLock();
    private final CountDownLatch exitedLoop = new CountDownLatch(1);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final PlainActionFuture<Boolean> isRunningFuture = PlainActionFuture.newFuture();
    private volatile Thread thread;

    ESSelector(EventHandler eventHandler) throws IOException {
        this(eventHandler, Selector.open());
    }

    ESSelector(EventHandler eventHandler, Selector selector) throws IOException {
        this.eventHandler = eventHandler;
        this.selector = selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runLoop() {
        if (!this.runLock.tryLock()) {
            throw new IllegalStateException("selector is already running");
        }
        this.isRunningFuture.onResponse((Object)true);
        try {
            this.setThread();
            while (this.isOpen()) {
                this.singleLoop();
            }
            return;
        }
        finally {
            try {
                this.cleanupAndCloseChannels();
            }
            finally {
                try {
                    this.selector.close();
                }
                catch (IOException e) {
                    this.eventHandler.closeSelectorException(e);
                }
                finally {
                    this.runLock.unlock();
                    this.exitedLoop.countDown();
                }
            }
        }
    }

    void singleLoop() {
        try {
            this.closePendingChannels();
            this.preSelect();
            int ready = this.selector.select(300L);
            if (ready > 0) {
                Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> keyIterator = selectionKeys.iterator();
                while (keyIterator.hasNext()) {
                    SelectionKey sk = keyIterator.next();
                    keyIterator.remove();
                    if (sk.isValid()) {
                        try {
                            this.processKey(sk);
                        }
                        catch (CancelledKeyException cke) {
                            this.eventHandler.genericChannelException((NioChannel)sk.attachment(), cke);
                        }
                        continue;
                    }
                    this.eventHandler.genericChannelException((NioChannel)sk.attachment(), new CancelledKeyException());
                }
            }
        }
        catch (ClosedSelectorException e) {
            if (this.isOpen()) {
                throw e;
            }
        }
        catch (IOException e) {
            this.eventHandler.selectException(e);
        }
        catch (Exception e) {
            this.eventHandler.uncaughtException(e);
        }
    }

    void cleanupAndCloseChannels() {
        this.cleanup();
        this.channelsToClose.addAll(this.selector.keys().stream().map(sk -> (NioChannel)sk.attachment()).collect(Collectors.toList()));
        this.closePendingChannels();
    }

    abstract void processKey(SelectionKey var1) throws CancelledKeyException;

    abstract void preSelect();

    abstract void cleanup();

    void setThread() {
        this.thread = Thread.currentThread();
    }

    public boolean isOnCurrentThread() {
        return Thread.currentThread() == this.thread;
    }

    void wakeup() {
        this.selector.wakeup();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.wakeup();
            if (this.isRunning()) {
                try {
                    this.exitedLoop.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Thread was interrupted while waiting for selector to close", e);
                }
            } else if (this.selector.isOpen()) {
                this.selector.close();
            }
        }
    }

    public void queueChannelClose(NioChannel channel) {
        assert (channel.getSelector() == this) : "Must schedule a channel for closure with its selector";
        this.channelsToClose.offer(channel);
        this.ensureSelectorOpenForEnqueuing(this.channelsToClose, channel);
        this.wakeup();
    }

    public Selector rawSelector() {
        return this.selector;
    }

    public boolean isOpen() {
        return !this.isClosed.get();
    }

    public boolean isRunning() {
        return this.runLock.isLocked();
    }

    public PlainActionFuture<Boolean> isRunningFuture() {
        return this.isRunningFuture;
    }

    <O> void ensureSelectorOpenForEnqueuing(ConcurrentLinkedQueue<O> queue, O objectAdded) {
        if (!this.isOpen() && !this.isOnCurrentThread() && queue.remove(objectAdded)) {
            throw new IllegalStateException("selector is already closed");
        }
    }

    private void closePendingChannels() {
        NioChannel channel;
        while ((channel = this.channelsToClose.poll()) != null) {
            this.eventHandler.handleClose(channel);
        }
    }
}

