/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.elasticsearch.transport.nio.AcceptorEventHandler;
import org.elasticsearch.transport.nio.ESSelector;
import org.elasticsearch.transport.nio.channel.NioServerSocketChannel;

public class AcceptingSelector
extends ESSelector {
    private final AcceptorEventHandler eventHandler;
    private final ConcurrentLinkedQueue<NioServerSocketChannel> newChannels = new ConcurrentLinkedQueue();

    public AcceptingSelector(AcceptorEventHandler eventHandler) throws IOException {
        super(eventHandler);
        this.eventHandler = eventHandler;
    }

    public AcceptingSelector(AcceptorEventHandler eventHandler, Selector selector) throws IOException {
        super(eventHandler, selector);
        this.eventHandler = eventHandler;
    }

    @Override
    void processKey(SelectionKey selectionKey) {
        NioServerSocketChannel serverChannel = (NioServerSocketChannel)selectionKey.attachment();
        if (selectionKey.isAcceptable()) {
            try {
                this.eventHandler.acceptChannel(serverChannel);
            }
            catch (IOException e) {
                this.eventHandler.acceptException(serverChannel, e);
            }
        }
    }

    @Override
    void preSelect() {
        this.setUpNewServerChannels();
    }

    @Override
    void cleanup() {
        this.channelsToClose.addAll(this.newChannels);
    }

    public void scheduleForRegistration(NioServerSocketChannel serverSocketChannel) {
        this.newChannels.add(serverSocketChannel);
        this.ensureSelectorOpenForEnqueuing(this.newChannels, serverSocketChannel);
        this.wakeup();
    }

    private void setUpNewServerChannels() {
        NioServerSocketChannel newChannel;
        while ((newChannel = this.newChannels.poll()) != null) {
            assert (newChannel.getSelector() == this) : "The channel must be registered with the selector with which it was created";
            try {
                if (newChannel.isOpen()) {
                    newChannel.register();
                    SelectionKey selectionKey = newChannel.getSelectionKey();
                    selectionKey.attach(newChannel);
                    this.eventHandler.serverChannelRegistered(newChannel);
                    continue;
                }
                this.eventHandler.registrationException(newChannel, new ClosedChannelException());
            }
            catch (IOException e) {
                this.eventHandler.registrationException(newChannel, e);
            }
        }
    }
}

