/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.engine;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class ThrowingLeafReaderWrapper
extends FilterLeafReader {
    private final Thrower thrower;

    public ThrowingLeafReaderWrapper(LeafReader in, Thrower thrower) {
        super(in);
        this.thrower = thrower;
    }

    public Terms terms(String field) throws IOException {
        Terms terms = super.terms(field);
        if (this.thrower.wrapTerms(field)) {
            this.thrower.maybeThrow(Flags.Terms);
            return terms == null ? null : new ThrowingTerms(terms, this.thrower);
        }
        return terms;
    }

    public Fields getTermVectors(int docID) throws IOException {
        Fields fields = super.getTermVectors(docID);
        this.thrower.maybeThrow(Flags.TermVectors);
        return fields == null ? null : new ThrowingFields(fields, this.thrower);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.thrower.maybeThrow(Flags.NumericDocValues);
        return super.getNumericDocValues(field);
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.thrower.maybeThrow(Flags.BinaryDocValues);
        return super.getBinaryDocValues(field);
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.thrower.maybeThrow(Flags.SortedDocValues);
        return super.getSortedDocValues(field);
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.thrower.maybeThrow(Flags.SortedSetDocValues);
        return super.getSortedSetDocValues(field);
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        this.thrower.maybeThrow(Flags.Norms);
        return super.getNormValues(field);
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    static class ThrowingTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private final Thrower thrower;

        ThrowingTermsEnum(TermsEnum in, Thrower thrower) {
            super(in);
            this.thrower = thrower;
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            if ((flags & 0x18) != 0) {
                this.thrower.maybeThrow(Flags.DocsAndPositionsEnum);
            } else {
                this.thrower.maybeThrow(Flags.DocsEnum);
            }
            return super.postings(reuse, flags);
        }
    }

    public static class ThrowingTerms
    extends FilterLeafReader.FilterTerms {
        private final Thrower thrower;

        public ThrowingTerms(Terms in, Thrower thrower) {
            super(in);
            this.thrower = thrower;
        }

        public TermsEnum intersect(CompiledAutomaton automaton, BytesRef bytes) throws IOException {
            TermsEnum termsEnum = this.in.intersect(automaton, bytes);
            this.thrower.maybeThrow(Flags.Intersect);
            return new ThrowingTermsEnum(termsEnum, this.thrower);
        }

        public TermsEnum iterator() throws IOException {
            TermsEnum termsEnum = super.iterator();
            this.thrower.maybeThrow(Flags.TermsEnum);
            return new ThrowingTermsEnum(termsEnum, this.thrower);
        }
    }

    public static class ThrowingFields
    extends FilterLeafReader.FilterFields {
        private final Thrower thrower;

        public ThrowingFields(Fields in, Thrower thrower) {
            super(in);
            this.thrower = thrower;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = super.terms(field);
            if (this.thrower.wrapTerms(field)) {
                this.thrower.maybeThrow(Flags.Terms);
                return terms == null ? null : new ThrowingTerms(terms, this.thrower);
            }
            return terms;
        }
    }

    public static interface Thrower {
        public void maybeThrow(Flags var1) throws IOException;

        public boolean wrapTerms(String var1);
    }

    public static enum Flags {
        TermVectors,
        Terms,
        TermsEnum,
        Intersect,
        DocsEnum,
        DocsAndPositionsEnum,
        Fields,
        Norms,
        NumericDocValues,
        BinaryDocValues,
        SortedDocValues,
        SortedSetDocValues;

    }
}

