/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanBoostQuery;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.TestEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.EqualsHashCodeTestUtils;
import org.elasticsearch.test.IndexSettingsModule;
import org.elasticsearch.test.InternalSettingsPlugin;
import org.elasticsearch.test.TestSearchContext;
import org.elasticsearch.test.VersionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractQueryTestCase<QB extends AbstractQueryBuilder<QB>>
extends ESTestCase {
    public static final String STRING_FIELD_NAME = "mapped_string";
    protected static final String STRING_FIELD_NAME_2 = "mapped_string_2";
    protected static final String INT_FIELD_NAME = "mapped_int";
    protected static final String INT_RANGE_FIELD_NAME = "mapped_int_range";
    protected static final String DOUBLE_FIELD_NAME = "mapped_double";
    protected static final String BOOLEAN_FIELD_NAME = "mapped_boolean";
    protected static final String DATE_FIELD_NAME = "mapped_date";
    protected static final String DATE_RANGE_FIELD_NAME = "mapped_date_range";
    protected static final String OBJECT_FIELD_NAME = "mapped_object";
    protected static final String GEO_POINT_FIELD_NAME = "mapped_geo_point";
    protected static final String GEO_SHAPE_FIELD_NAME = "mapped_geo_shape";
    protected static final String[] MAPPED_FIELD_NAMES = new String[]{"mapped_string", "mapped_int", "mapped_int_range", "mapped_double", "mapped_boolean", "mapped_date", "mapped_date_range", "mapped_object", "mapped_geo_point", "mapped_geo_shape"};
    private static final String[] MAPPED_LEAF_FIELD_NAMES = new String[]{"mapped_string", "mapped_int", "mapped_int_range", "mapped_double", "mapped_boolean", "mapped_date", "mapped_date_range", "mapped_geo_point"};
    private static final int NUMBER_OF_TESTQUERIES = 20;
    protected static Version indexVersionCreated;
    private static ServiceHolder serviceHolder;
    private static int queryNameId;
    private static Settings nodeSettings;
    private static Index index;
    private static String[] currentTypes;
    private static String[] randomTypes;

    protected static Index getIndex() {
        return index;
    }

    protected static String[] getCurrentTypes() {
        return currentTypes;
    }

    protected Collection<Class<? extends Plugin>> getPlugins() {
        return Collections.emptyList();
    }

    protected void initializeAdditionalMappings(MapperService mapperService) throws IOException {
    }

    @BeforeClass
    public static void beforeClass() {
        nodeSettings = Settings.builder().put("node.name", AbstractQueryTestCase.class.toString()).put(Environment.PATH_HOME_SETTING.getKey(), AbstractQueryTestCase.createTempDir()).build();
        index = new Index(AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10), "_na_");
        switch (AbstractQueryTestCase.random().nextInt(3)) {
            case 0: {
                currentTypes = new String[0];
                break;
            }
            default: {
                currentTypes = new String[]{"_doc"};
            }
        }
        randomTypes = AbstractQueryTestCase.getRandomTypes();
    }

    protected Settings indexSettings() {
        indexVersionCreated = AbstractQueryTestCase.randomBoolean() ? Version.CURRENT : VersionUtils.randomVersionBetween(AbstractQueryTestCase.random(), null, Version.CURRENT);
        return Settings.builder().put("index.version.created", indexVersionCreated).build();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{serviceHolder});
        serviceHolder = null;
    }

    @Before
    public void beforeTest() throws IOException {
        if (serviceHolder == null) {
            serviceHolder = new ServiceHolder(nodeSettings, this.indexSettings(), this.getPlugins(), this);
        }
        ((ServiceHolder)AbstractQueryTestCase.serviceHolder).clientInvocationHandler.delegate = this;
    }

    private static SearchContext getSearchContext(String[] types, QueryShardContext context) {
        TestSearchContext testSearchContext = new TestSearchContext(context){

            @Override
            public MapperService mapperService() {
                return serviceHolder.mapperService;
            }

            @Override
            public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
                return (IFD)serviceHolder.indexFieldDataService.getForField(fieldType);
            }
        };
        testSearchContext.getQueryShardContext().setTypes(types);
        return testSearchContext;
    }

    @After
    public void afterTest() {
        ((ServiceHolder)AbstractQueryTestCase.serviceHolder).clientInvocationHandler.delegate = null;
    }

    public final QB createTestQueryBuilder() {
        QB query = this.doCreateTestQueryBuilder();
        if (this.supportsBoostAndQueryName()) {
            if (AbstractQueryTestCase.randomBoolean()) {
                query.boost(2.0f / (float)AbstractQueryTestCase.randomIntBetween(1, 20));
            }
            if (AbstractQueryTestCase.randomBoolean()) {
                query.queryName(AbstractQueryTestCase.createUniqueRandomName());
            }
        }
        return query;
    }

    private static String createUniqueRandomName() {
        String queryName = AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10) + queryNameId;
        ++queryNameId;
        return queryName;
    }

    protected abstract QB doCreateTestQueryBuilder();

    public void testFromXContent() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QB testQuery = this.createTestQueryBuilder();
            XContentType xContentType = AbstractQueryTestCase.randomFrom(XContentType.values());
            BytesReference shuffledXContent = this.toShuffledXContent((ToXContent)testQuery, xContentType, ToXContent.EMPTY_PARAMS, AbstractQueryTestCase.randomBoolean(), this.shuffleProtectedFields());
            AbstractQueryTestCase.assertParsedQuery(this.createParser(xContentType.xContent(), shuffledXContent), testQuery);
            for (Map.Entry<String, QB> alternateVersion : this.getAlternateVersions().entrySet()) {
                String queryAsString = alternateVersion.getKey();
                AbstractQueryTestCase.assertParsedQuery(this.createParser((XContent)JsonXContent.jsonXContent, queryAsString), (QueryBuilder)alternateVersion.getValue());
            }
        }
    }

    protected String[] shuffleProtectedFields() {
        return Strings.EMPTY_ARRAY;
    }

    public void testUnknownField() {
        QB testQuery;
        String marker = "#marker#";
        while ((testQuery = this.createTestQueryBuilder()).toString().contains(marker)) {
        }
        testQuery.queryName(marker);
        String queryAsString = testQuery.toString().replace("\"" + marker + "\"", "\"" + marker + "\", \"bogusField\" : \"someValue\"");
        ParsingException e = (ParsingException)AbstractQueryTestCase.expectThrows(ParsingException.class, () -> this.parseQuery(queryAsString));
        AbstractQueryTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"bogusField"));
    }

    public final void testUnknownObjectException() throws IOException {
        HashSet<String> candidates = new HashSet<String>();
        candidates.add(this.createTestQueryBuilder().toString());
        candidates.addAll(this.getAlternateVersions().keySet());
        List<Tuple<String, Boolean>> testQueries = AbstractQueryTestCase.alterateQueries(candidates, this.getObjectsHoldingArbitraryContent());
        for (Tuple<String, Boolean> testQuery : testQueries) {
            boolean expectedException = (Boolean)testQuery.v2();
            try {
                this.parseQuery((String)testQuery.v1());
                if (!expectedException) continue;
                AbstractQueryTestCase.fail((String)("some parsing exception expected for query: " + testQuery));
            }
            catch (ElasticsearchParseException | ParsingException | XContentParseException e) {
                if (!expectedException) {
                    throw new AssertionError("unexpected exception when parsing query:\n" + testQuery, e);
                }
            }
            catch (IllegalArgumentException e) {
                if (!expectedException) {
                    throw new AssertionError("unexpected exception when parsing query:\n" + testQuery, e);
                }
                AbstractQueryTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"unknown field [newField], parser not found"));
            }
        }
    }

    static List<Tuple<String, Boolean>> alterateQueries(Set<String> queries, Set<String> arbitraryMarkers) throws IOException {
        ArrayList<Tuple<String, Boolean>> results = new ArrayList<Tuple<String, Boolean>>();
        boolean hasArbitraryContent = arbitraryMarkers != null && !arbitraryMarkers.isEmpty();
        block12: for (String query : queries) {
            int mutation = 0;
            while (true) {
                boolean expectException = true;
                BytesStreamOutput out = new BytesStreamOutput();
                XContentGenerator generator = XContentType.JSON.xContent().createGenerator((OutputStream)out);
                Throwable throwable = null;
                try {
                    XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, query);
                    Throwable throwable2 = null;
                    try {
                        XContentParser.Token token;
                        int objectIndex = -1;
                        LinkedList<String> levels = new LinkedList<String>();
                        block14: while ((token = parser.nextToken()) != null) {
                            if (token == XContentParser.Token.START_ARRAY) {
                                levels.addLast(parser.currentName());
                            } else if (token == XContentParser.Token.START_OBJECT) {
                                levels.addLast(parser.currentName());
                                if (++objectIndex == mutation) {
                                    generator.writeStartObject();
                                    generator.writeFieldName("newField");
                                    generator.copyCurrentStructure(parser);
                                    generator.writeEndObject();
                                    if (!hasArbitraryContent) continue;
                                    for (String marker : arbitraryMarkers) {
                                        if (!levels.contains(marker)) continue;
                                        expectException = false;
                                        continue block14;
                                    }
                                    continue;
                                }
                            } else if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                                levels.removeLast();
                            }
                            generator.copyCurrentEvent(parser);
                        }
                        if (objectIndex < mutation) continue block12;
                        ++mutation;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (parser == null) continue block12;
                        AbstractQueryTestCase.$closeResource(throwable2, (AutoCloseable)parser);
                        continue block12;
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (generator == null) continue block12;
                    AbstractQueryTestCase.$closeResource(throwable, (AutoCloseable)generator);
                    continue block12;
                }
                results.add((Tuple<String, Boolean>)new Tuple((Object)out.bytes().utf8ToString(), (Object)expectException));
            }
        }
        return results;
    }

    protected Set<String> getObjectsHoldingArbitraryContent() {
        return Collections.emptySet();
    }

    public final void testQueryWrappedInArray() {
        QB queryBuilder = this.createTestQueryBuilder();
        String queryName = queryBuilder.getName();
        String validQuery = queryBuilder.toString();
        this.queryWrappedInArrayTest(queryName, validQuery);
        for (String query : this.getAlternateVersions().keySet()) {
            this.queryWrappedInArrayTest(queryName, query);
        }
    }

    private void queryWrappedInArrayTest(String queryName, String validQuery) {
        int endArrayPosition;
        int insertionPosition;
        int i = validQuery.indexOf("\"" + queryName + "\"");
        AbstractQueryTestCase.assertThat((Object)i, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        for (insertionPosition = i; insertionPosition < validQuery.length() && validQuery.charAt(insertionPosition) != ':'; ++insertionPosition) {
        }
        ++insertionPosition;
        for (endArrayPosition = validQuery.length() - 1; endArrayPosition >= 0 && validQuery.charAt(endArrayPosition) != '}'; --endArrayPosition) {
        }
        String testQuery = validQuery.substring(0, insertionPosition) + "[" + validQuery.substring(insertionPosition, endArrayPosition) + "]" + validQuery.substring(endArrayPosition, validQuery.length());
        ParsingException e = (ParsingException)AbstractQueryTestCase.expectThrows(ParsingException.class, () -> this.parseQuery(testQuery));
        AbstractQueryTestCase.assertEquals((Object)("[" + queryName + "] query malformed, no start_object after query name"), (Object)e.getMessage());
    }

    protected Map<String, QB> getAlternateVersions() {
        return Collections.emptyMap();
    }

    protected void assertParsedQuery(String queryAsString, QueryBuilder expectedQuery) throws IOException {
        QueryBuilder newQuery = this.parseQuery(queryAsString);
        AbstractQueryTestCase.assertNotSame((Object)newQuery, (Object)expectedQuery);
        AbstractQueryTestCase.assertEquals((Object)expectedQuery, (Object)newQuery);
        AbstractQueryTestCase.assertEquals((long)expectedQuery.hashCode(), (long)newQuery.hashCode());
    }

    private static void assertParsedQuery(XContentParser parser, QueryBuilder expectedQuery) throws IOException {
        QueryBuilder newQuery = AbstractQueryTestCase.parseQuery(parser);
        AbstractQueryTestCase.assertNotSame((Object)newQuery, (Object)expectedQuery);
        AbstractQueryTestCase.assertEquals((Object)expectedQuery, (Object)newQuery);
        AbstractQueryTestCase.assertEquals((long)expectedQuery.hashCode(), (long)newQuery.hashCode());
    }

    protected QueryBuilder parseQuery(AbstractQueryBuilder<?> builder) throws IOException {
        BytesReference bytes = XContentHelper.toXContent(builder, (XContentType)XContentType.JSON, (boolean)false);
        return AbstractQueryTestCase.parseQuery(this.createParser((XContent)JsonXContent.jsonXContent, bytes));
    }

    protected QueryBuilder parseQuery(String queryAsString) throws IOException {
        XContentParser parser = this.createParser((XContent)JsonXContent.jsonXContent, queryAsString);
        return AbstractQueryTestCase.parseQuery(parser);
    }

    protected static QueryBuilder parseQuery(XContentParser parser) throws IOException {
        QueryBuilder parseInnerQueryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
        AbstractQueryTestCase.assertNull((Object)parser.nextToken());
        return parseInnerQueryBuilder;
    }

    protected boolean builderGeneratesCacheableQueries() {
        return true;
    }

    public void testToQuery() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QueryShardContext context = AbstractQueryTestCase.createShardContext();
            assert (context.isCachable());
            context.setAllowUnmappedFields(true);
            QB firstQuery = this.createTestQueryBuilder();
            QB controlQuery = this.copyQuery(firstQuery);
            SearchContext searchContext = AbstractQueryTestCase.getSearchContext(randomTypes, context);
            QueryBuilder rewritten = this.rewriteQuery(firstQuery, (QueryRewriteContext)new QueryShardContext(context));
            Query firstLuceneQuery = rewritten.toQuery(context);
            if (this.isCachable(firstQuery)) {
                AbstractQueryTestCase.assertTrue((String)("query was marked as not cacheable in the context but this test indicates it should be cacheable: " + firstQuery.toString()), (boolean)context.isCachable());
            } else {
                AbstractQueryTestCase.assertFalse((String)("query was marked as cacheable in the context but this test indicates it should not be cacheable: " + firstQuery.toString()), (boolean)context.isCachable());
            }
            AbstractQueryTestCase.assertNotNull((String)"toQuery should not return null", (Object)firstLuceneQuery);
            this.assertLuceneQuery(firstQuery, firstLuceneQuery, searchContext);
            AbstractQueryTestCase.assertTrue((String)("query is not equal to its copy after calling toQuery, firstQuery: " + firstQuery + ", secondQuery: " + controlQuery), (boolean)firstQuery.equals(controlQuery));
            AbstractQueryTestCase.assertTrue((String)("equals is not symmetric after calling toQuery, firstQuery: " + firstQuery + ", secondQuery: " + controlQuery), (boolean)controlQuery.equals(firstQuery));
            AbstractQueryTestCase.assertThat((String)("query copy's hashcode is different from original hashcode after calling toQuery, firstQuery: " + firstQuery + ", secondQuery: " + controlQuery), (Object)controlQuery.hashCode(), (Matcher)CoreMatchers.equalTo((Object)firstQuery.hashCode()));
            QB secondQuery = this.copyQuery(firstQuery);
            if (AbstractQueryTestCase.randomBoolean()) {
                secondQuery.queryName(secondQuery.queryName() == null ? AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 30) : secondQuery.queryName() + AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10));
            }
            searchContext = AbstractQueryTestCase.getSearchContext(randomTypes, context);
            Query secondLuceneQuery = this.rewriteQuery(secondQuery, (QueryRewriteContext)context).toQuery(context);
            AbstractQueryTestCase.assertNotNull((String)"toQuery should not return null", (Object)secondLuceneQuery);
            this.assertLuceneQuery(secondQuery, secondLuceneQuery, searchContext);
            if (this.builderGeneratesCacheableQueries()) {
                AbstractQueryTestCase.assertEquals((String)"two equivalent query builders lead to different lucene queries", (Object)this.rewrite(secondLuceneQuery), (Object)this.rewrite(firstLuceneQuery));
            }
            if (this.supportsBoostAndQueryName()) {
                secondQuery.boost(firstQuery.boost() + 1.0f + AbstractQueryTestCase.randomFloat());
                Query thirdLuceneQuery = this.rewriteQuery(secondQuery, (QueryRewriteContext)context).toQuery(context);
                AbstractQueryTestCase.assertNotEquals((String)"modifying the boost doesn't affect the corresponding lucene query", (Object)this.rewrite(firstLuceneQuery), (Object)this.rewrite(thirdLuceneQuery));
            }
            boolean filterFlag = AbstractQueryTestCase.randomBoolean();
            context.setIsFilter(filterFlag);
            this.rewriteQuery(firstQuery, (QueryRewriteContext)context).toQuery(context);
            AbstractQueryTestCase.assertEquals((String)"isFilter should be unchanged", (Object)filterFlag, (Object)context.isFilter());
        }
    }

    private QueryBuilder rewriteQuery(QB queryBuilder, QueryRewriteContext rewriteContext) throws IOException {
        QueryBuilder rewritten = this.rewriteAndFetch((QueryBuilder)queryBuilder, rewriteContext);
        AbstractQueryTestCase.assertSerialization(rewritten);
        return rewritten;
    }

    protected boolean isCachable(QB queryBuilder) {
        return true;
    }

    protected boolean supportsBoostAndQueryName() {
        return true;
    }

    private void assertLuceneQuery(QB queryBuilder, Query query, SearchContext context) throws IOException {
        if (queryBuilder.queryName() != null) {
            Query namedQuery = (Query)context.getQueryShardContext().copyNamedQueries().get(queryBuilder.queryName());
            AbstractQueryTestCase.assertThat((Object)namedQuery, (Matcher)CoreMatchers.equalTo((Object)query));
        }
        if (query != null && queryBuilder.boost() != 1.0f) {
            AbstractQueryTestCase.assertThat((Object)query, (Matcher)Matchers.either((Matcher)Matchers.instanceOf(BoostQuery.class)).or(Matchers.instanceOf(SpanBoostQuery.class)));
            if (query instanceof SpanBoostQuery) {
                SpanBoostQuery spanBoostQuery = (SpanBoostQuery)query;
                AbstractQueryTestCase.assertThat((Object)Float.valueOf(spanBoostQuery.getBoost()), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(queryBuilder.boost())));
                query = spanBoostQuery.getQuery();
            } else {
                BoostQuery boostQuery = (BoostQuery)query;
                AbstractQueryTestCase.assertThat((Object)Float.valueOf(boostQuery.getBoost()), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(queryBuilder.boost())));
                query = boostQuery.getQuery();
            }
        }
        this.doAssertLuceneQuery(queryBuilder, query, context);
    }

    protected abstract void doAssertLuceneQuery(QB var1, Query var2, SearchContext var3) throws IOException;

    protected static void assertTermOrBoostQuery(Query query, String field, String value, float fieldBoost) {
        if (fieldBoost != 1.0f) {
            AbstractQueryTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(BoostQuery.class));
            BoostQuery boostQuery = (BoostQuery)query;
            AbstractQueryTestCase.assertThat((Object)Float.valueOf(boostQuery.getBoost()), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(fieldBoost)));
            query = boostQuery.getQuery();
        }
        AbstractQueryTestCase.assertTermQuery(query, field, value);
    }

    protected static void assertTermQuery(Query query, String field, String value) {
        AbstractQueryTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(TermQuery.class));
        TermQuery termQuery = (TermQuery)query;
        AbstractQueryTestCase.assertThat((Object)termQuery.getTerm().field(), (Matcher)CoreMatchers.equalTo((Object)field));
        AbstractQueryTestCase.assertThat((Object)termQuery.getTerm().text().toLowerCase(Locale.ROOT), (Matcher)CoreMatchers.equalTo((Object)value.toLowerCase(Locale.ROOT)));
    }

    public void testSerialization() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QB testQuery = this.createTestQueryBuilder();
            AbstractQueryTestCase.assertSerialization(testQuery);
        }
    }

    protected static QueryBuilder assertSerialization(QueryBuilder testQuery) throws IOException {
        return AbstractQueryTestCase.assertSerialization(testQuery, Version.CURRENT);
    }

    protected static QueryBuilder assertSerialization(QueryBuilder testQuery, Version version) throws IOException {
        Throwable throwable = null;
        try (BytesStreamOutput output = new BytesStreamOutput();){
            QueryBuilder queryBuilder;
            output.setVersion(version);
            output.writeNamedWriteable((NamedWriteable)testQuery);
            NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), serviceHolder.namedWriteableRegistry);
            Throwable throwable2 = null;
            try {
                in.setVersion(version);
                QueryBuilder deserializedQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
                AbstractQueryTestCase.assertEquals((Object)testQuery, (Object)deserializedQuery);
                AbstractQueryTestCase.assertEquals((long)testQuery.hashCode(), (long)deserializedQuery.hashCode());
                AbstractQueryTestCase.assertNotSame((Object)testQuery, (Object)deserializedQuery);
                queryBuilder = deserializedQuery;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AbstractQueryTestCase.$closeResource(throwable2, (AutoCloseable)in);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AbstractQueryTestCase.$closeResource(throwable2, (AutoCloseable)in);
            return queryBuilder;
        }
    }

    public void testEqualsAndHashcode() {
        for (int runs = 0; runs < 20; ++runs) {
            EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestQueryBuilder(), this::copyQuery, this::mutateInstance);
        }
    }

    public QB mutateInstance(QB instance) throws IOException {
        return this.changeNameOrBoost(instance);
    }

    public void testValidOutput() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QB testQuery = this.createTestQueryBuilder();
            XContentType xContentType = XContentType.JSON;
            String toString = Strings.toString(testQuery);
            AbstractQueryTestCase.assertParsedQuery(this.createParser(xContentType.xContent(), toString), testQuery);
            BytesReference bytes = XContentHelper.toXContent(testQuery, (XContentType)xContentType, (boolean)false);
            AbstractQueryTestCase.assertParsedQuery(this.createParser(xContentType.xContent(), bytes), testQuery);
        }
    }

    protected QB changeNameOrBoost(QB original) throws IOException {
        QB secondQuery = this.copyQuery(original);
        if (AbstractQueryTestCase.randomBoolean()) {
            secondQuery.queryName(secondQuery.queryName() == null ? AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 30) : secondQuery.queryName() + AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10));
        } else {
            secondQuery.boost(original.boost() + 1.0f + AbstractQueryTestCase.randomFloat());
        }
        return secondQuery;
    }

    private QB copyQuery(QB query) throws IOException {
        Writeable.Reader reader = serviceHolder.namedWriteableRegistry.getReader(QueryBuilder.class, query.getWriteableName());
        return (QB)((AbstractQueryBuilder)AbstractQueryTestCase.copyWriteable(query, serviceHolder.namedWriteableRegistry, reader));
    }

    protected static QueryShardContext createShardContext() {
        return serviceHolder.createShardContext();
    }

    protected static Object getRandomValueForFieldName(String fieldName) {
        Object value;
        switch (fieldName) {
            case "mapped_string": {
                if (AbstractQueryTestCase.rarely()) {
                    JsonStringEncoder encoder = JsonStringEncoder.getInstance();
                    value = new String(encoder.quoteAsString(AbstractQueryTestCase.randomUnicodeOfLength(10)));
                    break;
                }
                value = AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10);
                break;
            }
            case "mapped_int": {
                value = AbstractQueryTestCase.randomIntBetween(0, 10);
                break;
            }
            case "mapped_double": {
                value = 1.0 + AbstractQueryTestCase.randomDouble() * 9.0;
                break;
            }
            case "mapped_boolean": {
                value = AbstractQueryTestCase.randomBoolean();
                break;
            }
            case "mapped_date": {
                value = new DateTime(System.currentTimeMillis(), DateTimeZone.UTC).toString();
                break;
            }
            default: {
                value = AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10);
            }
        }
        return value;
    }

    protected static String getRandomQueryText() {
        int terms = AbstractQueryTestCase.randomIntBetween(0, 3);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < terms; ++i) {
            builder.append(AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10)).append(" ");
        }
        return builder.toString().trim();
    }

    protected static String getRandomFieldName() {
        if (currentTypes.length == 0 || AbstractQueryTestCase.randomBoolean()) {
            return AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10);
        }
        return AbstractQueryTestCase.randomFrom(MAPPED_LEAF_FIELD_NAMES);
    }

    protected static String getRandomRewriteMethod() {
        String rewrite = AbstractQueryTestCase.randomBoolean() ? AbstractQueryTestCase.randomFrom(QueryParsers.CONSTANT_SCORE, QueryParsers.SCORING_BOOLEAN, QueryParsers.CONSTANT_SCORE_BOOLEAN).getPreferredName() : AbstractQueryTestCase.randomFrom(QueryParsers.TOP_TERMS, QueryParsers.TOP_TERMS_BOOST, QueryParsers.TOP_TERMS_BLENDED_FREQS).getPreferredName() + "1";
        return rewrite;
    }

    private static String[] getRandomTypes() {
        String[] types;
        if (currentTypes.length > 0 && AbstractQueryTestCase.randomBoolean()) {
            int numberOfQueryTypes = AbstractQueryTestCase.randomIntBetween(1, currentTypes.length);
            types = new String[numberOfQueryTypes];
            for (int i = 0; i < numberOfQueryTypes; ++i) {
                types[i] = AbstractQueryTestCase.randomFrom(currentTypes);
            }
        } else {
            types = AbstractQueryTestCase.randomBoolean() ? new String[]{"_all"} : new String[]{};
        }
        return types;
    }

    protected static Fuzziness randomFuzziness(String fieldName) {
        switch (fieldName) {
            case "mapped_int": {
                return Fuzziness.build((Object)AbstractQueryTestCase.randomIntBetween(3, 100));
            }
            case "mapped_double": {
                return Fuzziness.build((Object)Float.valueOf(1.0f + AbstractQueryTestCase.randomFloat() * 10.0f));
            }
            case "mapped_date": {
                return Fuzziness.build((Object)AbstractQueryTestCase.randomTimeValue());
            }
        }
        if (AbstractQueryTestCase.randomBoolean()) {
            return Fuzziness.fromEdits((int)AbstractQueryTestCase.randomIntBetween(0, 2));
        }
        return Fuzziness.AUTO;
    }

    protected static String randomAnalyzer() {
        return AbstractQueryTestCase.randomFrom("simple", "standard", "keyword", "whitespace");
    }

    protected static String randomMinimumShouldMatch() {
        return AbstractQueryTestCase.randomFrom("1", "-1", "75%", "-25%", "2<75%", "2<-25%");
    }

    protected GetResponse executeGet(GetRequest getRequest) {
        throw new UnsupportedOperationException("this test can't handle GET requests");
    }

    protected MultiTermVectorsResponse executeMultiTermVectors(MultiTermVectorsRequest mtvRequest) {
        throw new UnsupportedOperationException("this test can't handle MultiTermVector requests");
    }

    public static void checkGeneratedJson(String expected, QueryBuilder source) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
        source.toXContent(builder, ToXContent.EMPTY_PARAMS);
        AbstractQueryTestCase.assertEquals((String)AbstractQueryTestCase.msg(expected, Strings.toString((XContentBuilder)builder)), (Object)expected.replaceAll("\\s+", ""), (Object)Strings.toString((XContentBuilder)builder).replaceAll("\\s+", ""));
    }

    private static String msg(String left, String right) {
        int size = Math.min(left.length(), right.length());
        StringBuilder builder = new StringBuilder("size: " + left.length() + " vs. " + right.length());
        builder.append(" content: <<");
        for (int i = 0; i < size; ++i) {
            if (left.charAt(i) != right.charAt(i)) {
                builder.append(">> ").append("until offset: ").append(i).append(" [").append(left.charAt(i)).append(" vs.").append(right.charAt(i)).append("] [").append((int)left.charAt(i)).append(" vs.").append((int)right.charAt(i)).append(']');
                return builder.toString();
            }
            builder.append(left.charAt(i));
        }
        if (left.length() != right.length()) {
            int leftEnd = Math.max(size, left.length()) - 1;
            int rightEnd = Math.max(size, right.length()) - 1;
            builder.append(">> ").append("until offset: ").append(size).append(" [").append(left.charAt(leftEnd)).append(" vs.").append(right.charAt(rightEnd)).append("] [").append((int)left.charAt(leftEnd)).append(" vs.").append((int)right.charAt(rightEnd)).append(']');
            return builder.toString();
        }
        return "";
    }

    public void testMustRewrite() throws IOException {
        QueryShardContext context = AbstractQueryTestCase.createShardContext();
        context.setAllowUnmappedFields(true);
        QB queryBuilder = this.createTestQueryBuilder();
        queryBuilder.toQuery(context);
    }

    protected Query rewrite(Query query) throws IOException {
        return query;
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return serviceHolder.xContentRegistry;
    }

    protected QueryBuilder rewriteAndFetch(QueryBuilder builder, QueryRewriteContext context) throws IOException {
        PlainActionFuture future = new PlainActionFuture();
        Rewriteable.rewriteAndFetch((Rewriteable)builder, (QueryRewriteContext)context, (ActionListener)future);
        return (QueryBuilder)future.actionGet();
    }

    static {
        queryNameId = 0;
    }

    private static class ServiceHolder
    implements Closeable {
        private final IndexFieldDataService indexFieldDataService;
        private final SearchModule searchModule;
        private final NamedWriteableRegistry namedWriteableRegistry;
        private final NamedXContentRegistry xContentRegistry;
        private final ClientInvocationHandler clientInvocationHandler = new ClientInvocationHandler();
        private final IndexSettings idxSettings;
        private final SimilarityService similarityService;
        private final MapperService mapperService;
        private final BitsetFilterCache bitsetFilterCache;
        private final ScriptService scriptService;
        private final Client client;
        private final long nowInMillis = ESTestCase.randomNonNegativeLong();

        ServiceHolder(Settings nodeSettings, Settings indexSettings, Collection<Class<? extends Plugin>> plugins, AbstractQueryTestCase<?> testCase) throws IOException {
            Environment env = InternalSettingsPreparer.prepareEnvironment((Settings)nodeSettings, null);
            PluginsService pluginsService = new PluginsService(nodeSettings, null, env.modulesFile(), env.pluginsFile(), plugins);
            this.client = (Client)Proxy.newProxyInstance(Client.class.getClassLoader(), new Class[]{Client.class}, (InvocationHandler)this.clientInvocationHandler);
            ScriptModule scriptModule = this.createScriptModule(pluginsService.filterPlugins(ScriptPlugin.class));
            List additionalSettings = pluginsService.getPluginSettings();
            additionalSettings.add(InternalSettingsPlugin.VERSION_CREATED);
            SettingsModule settingsModule = new SettingsModule(nodeSettings, additionalSettings, pluginsService.getPluginSettingsFilter());
            this.searchModule = new SearchModule(nodeSettings, false, pluginsService.filterPlugins(SearchPlugin.class));
            IndicesModule indicesModule = new IndicesModule(pluginsService.filterPlugins(MapperPlugin.class));
            ArrayList entries = new ArrayList();
            entries.addAll(indicesModule.getNamedWriteables());
            entries.addAll(this.searchModule.getNamedWriteables());
            this.namedWriteableRegistry = new NamedWriteableRegistry(entries);
            this.xContentRegistry = new NamedXContentRegistry(Stream.of(this.searchModule.getNamedXContents().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            IndexScopedSettings indexScopedSettings = settingsModule.getIndexScopedSettings();
            this.idxSettings = IndexSettingsModule.newIndexSettings(index, indexSettings, indexScopedSettings);
            AnalysisModule analysisModule = new AnalysisModule(TestEnvironment.newEnvironment(nodeSettings), Collections.emptyList());
            IndexAnalyzers indexAnalyzers = analysisModule.getAnalysisRegistry().build(this.idxSettings);
            this.scriptService = scriptModule.getScriptService();
            this.similarityService = new SimilarityService(this.idxSettings, null, Collections.emptyMap());
            MapperRegistry mapperRegistry = indicesModule.getMapperRegistry();
            this.mapperService = new MapperService(this.idxSettings, indexAnalyzers, this.xContentRegistry, this.similarityService, mapperRegistry, this::createShardContext);
            IndicesFieldDataCache indicesFieldDataCache = new IndicesFieldDataCache(nodeSettings, new IndexFieldDataCache.Listener(){});
            this.indexFieldDataService = new IndexFieldDataService(this.idxSettings, indicesFieldDataCache, (CircuitBreakerService)new NoneCircuitBreakerService(), this.mapperService);
            this.bitsetFilterCache = new BitsetFilterCache(this.idxSettings, new BitsetFilterCache.Listener(){

                public void onCache(ShardId shardId, Accountable accountable) {
                }

                public void onRemoval(ShardId shardId, Accountable accountable) {
                }
            });
            for (String type : currentTypes) {
                this.mapperService.merge(type, new CompressedXContent(Strings.toString((XContentBuilder)PutMappingRequest.buildFromSimplifiedDef((String)type, (Object[])new Object[]{AbstractQueryTestCase.STRING_FIELD_NAME, "type=text", AbstractQueryTestCase.STRING_FIELD_NAME_2, "type=keyword", AbstractQueryTestCase.INT_FIELD_NAME, "type=integer", AbstractQueryTestCase.INT_RANGE_FIELD_NAME, "type=integer_range", AbstractQueryTestCase.DOUBLE_FIELD_NAME, "type=double", AbstractQueryTestCase.BOOLEAN_FIELD_NAME, "type=boolean", AbstractQueryTestCase.DATE_FIELD_NAME, "type=date", AbstractQueryTestCase.DATE_RANGE_FIELD_NAME, "type=date_range", AbstractQueryTestCase.OBJECT_FIELD_NAME, "type=object", AbstractQueryTestCase.GEO_POINT_FIELD_NAME, "type=geo_point", AbstractQueryTestCase.GEO_SHAPE_FIELD_NAME, "type=geo_shape"}))), MapperService.MergeReason.MAPPING_UPDATE, false);
                this.mapperService.merge(type, new CompressedXContent("{\"properties\":{\"mapped_object\":{\"type\":\"object\",\"properties\":{\"mapped_date\":{\"type\":\"date\"},\"mapped_int\":{\"type\":\"integer\"}}}}}"), MapperService.MergeReason.MAPPING_UPDATE, false);
            }
            testCase.initializeAdditionalMappings(this.mapperService);
        }

        @Override
        public void close() throws IOException {
        }

        QueryShardContext createShardContext() {
            return new QueryShardContext(0, this.idxSettings, this.bitsetFilterCache, (arg_0, arg_1) -> ((IndexFieldDataService)this.indexFieldDataService).getForField(arg_0, arg_1), this.mapperService, this.similarityService, this.scriptService, this.xContentRegistry, this.namedWriteableRegistry, this.client, null, () -> this.nowInMillis, null);
        }

        ScriptModule createScriptModule(List<ScriptPlugin> scriptPlugins) {
            if (scriptPlugins == null || scriptPlugins.isEmpty()) {
                return ESTestCase.newTestScriptModule();
            }
            return new ScriptModule(Settings.EMPTY, scriptPlugins);
        }
    }

    private static class ClientInvocationHandler
    implements InvocationHandler {
        AbstractQueryTestCase<?> delegate;

        private ClientInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
            if (method.equals(Client.class.getMethod("get", GetRequest.class, ActionListener.class))) {
                GetResponse getResponse = this.delegate.executeGet((GetRequest)args[0]);
                ActionListener listener = (ActionListener)args[1];
                if (ESTestCase.randomBoolean()) {
                    listener.onResponse((Object)getResponse);
                } else {
                    new Thread(() -> listener.onResponse((Object)getResponse)).start();
                }
                return null;
            }
            if (method.equals(Client.class.getMethod("multiTermVectors", MultiTermVectorsRequest.class))) {
                return new PlainActionFuture<MultiTermVectorsResponse>(){

                    public MultiTermVectorsResponse get() throws InterruptedException, ExecutionException {
                        return delegate.executeMultiTermVectors((MultiTermVectorsRequest)args[0]);
                    }
                };
            }
            if (method.equals(Object.class.getMethod("toString", new Class[0]))) {
                return "MockClient";
            }
            throw new UnsupportedOperationException("this test can't handle calls to: " + method);
        }
    }
}

