/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class FileTestUtils {
    public static void assertFileContent(Path dir, String filename, String expected) throws IOException {
        Assert.assertThat((Object)Files.exists(dir, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)true));
        Path file = dir.resolve(filename);
        if (expected == null) {
            Assert.assertThat((String)("file [" + file + "] should not exist."), (Object)Files.exists(file, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)false));
        } else {
            ElasticsearchAssertions.assertFileExists(file);
            String fileContent = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
            Assert.assertThat((Object)fileContent.trim(), (Matcher)CoreMatchers.equalTo((Object)expected.trim()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(Path zip, Path destDir, @Nullable String prefixToRemove) throws IOException {
        if (Files.notExists(zip, new LinkOption[0])) {
            throw new IOException("[" + zip + "] zip file must exist");
        }
        Files.createDirectories(destDir, new FileAttribute[0]);
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                String entryPath;
                if (prefixToRemove != null) {
                    if (!entry.getName().startsWith(prefixToRemove)) throw new IOException("prefix not found: " + prefixToRemove);
                    entryPath = entry.getName().substring(prefixToRemove.length());
                } else {
                    entryPath = entry.getName();
                }
                Path path = Paths.get(destDir.toString(), entryPath);
                if (entry.isDirectory()) {
                    Files.createDirectories(path, new FileAttribute[0]);
                } else {
                    Files.copy(zipInput, path, new CopyOption[0]);
                }
                zipInput.closeEntry();
            }
            return;
        }
    }
}

