/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.utils;

import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface TryFunction<T, R, Ex extends Throwable>
extends Function<T, R> {
    public static final Logger log = LoggerFactory.getLogger(TryFunction.class);

    public R tryApply(T var1) throws Ex;

    @Override
    default public R apply(T t) {
        try {
            return this.tryApply(t);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    public static <T, R, Ex extends Throwable> Function<T, R> Try(TryFunction<T, R, Ex> function) {
        return function;
    }
}

